/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.tools.usage.util.reader;

import java.io.IOException;
import java.io.Reader;
import org.tigris.subversion.subclipse.tools.usage.util.reader.ReaderVisitor;

public class ReadUntilImpl
implements ReaderVisitor {
    private static final char EOS = '\uffff';
    private Reader reader;
    private boolean matched = false;
    private int numberOfCharactersRead;
    private char[] characters;
    private int matchingCharactersIndex = 0;

    public ReadUntilImpl(Reader reader, char[] characters) {
        this.reader = reader;
        this.numberOfCharactersRead = 0;
        this.characters = characters;
    }

    public final boolean continueRead(char character, int numberOfCharactersRead) throws IOException {
        this.numberOfCharactersRead = numberOfCharactersRead;
        return this.doContinueRead(character, numberOfCharactersRead);
    }

    protected boolean doContinueRead(char character, int numberOfCharactersRead) throws IOException {
        boolean continueRead = false;
        boolean matches = this.doesMatch(character);
        if (!matches) {
            continueRead = !matches;
        } else {
            int matchingIndex = this.getMatchingIndex() + 1;
            this.setMatchingIndex(matchingIndex);
            continueRead = matches && matchingIndex < this.getNumberOfCharactersToMatch();
        }
        this.setMatches(matches);
        return continueRead;
    }

    public boolean isMatching() {
        return this.matched;
    }

    public int getNumberOfCharactersRead() {
        return this.numberOfCharactersRead;
    }

    public void read() throws IOException {
        char character = '\u0000';
        while ((character = (char)this.reader.read()) != '\uffff') {
            if (this.continueRead(character, ++this.numberOfCharactersRead)) continue;
            return;
        }
    }

    protected void setMatchingIndex(int index) {
        this.matchingCharactersIndex = index;
    }

    protected int getMatchingIndex() {
        return this.matchingCharactersIndex;
    }

    protected boolean doesMatch(char character) {
        return this.characters[this.matchingCharactersIndex] == character;
    }

    protected int getNumberOfCharactersToMatch() {
        return this.characters.length;
    }

    protected char[] getCharactersToMatch() {
        return this.characters;
    }

    protected void setMatches(boolean matches) {
        this.matched = matches;
    }
}

