/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.Item;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.EnchantHPBonusData;
import com.l2jserver.gameserver.datatables.PetDataTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.instance.L2EventMonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.skills.SkillsEngine;
import com.l2jserver.gameserver.templates.item.L2Armor;
import com.l2jserver.gameserver.templates.item.L2ArmorType;
import com.l2jserver.gameserver.templates.item.L2EtcItem;
import com.l2jserver.gameserver.templates.item.L2Item;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import com.l2jserver.gameserver.templates.item.L2WeaponType;
import com.l2jserver.gameserver.util.GMAudit;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class ItemTable {
    private static Logger _log = Logger.getLogger(ItemTable.class.getName());
    private static Logger _logItems = Logger.getLogger("item");
    public static final Map<String, Integer> _materials = new FastMap();
    public static final Map<String, Integer> _crystalTypes = new FastMap();
    public static final Map<String, Integer> _slots = new FastMap();
    public static final Map<String, L2WeaponType> _weaponTypes = new FastMap();
    public static final Map<String, L2ArmorType> _armorTypes = new FastMap();
    private L2Item[] _allTemplates;
    private Map<Integer, L2EtcItem> _etcItems = new FastMap();
    private Map<Integer, L2Armor> _armors = new FastMap();
    private Map<Integer, L2Weapon> _weapons = new FastMap();

    public static ItemTable getInstance() {
        return SingletonHolder._instance;
    }

    @Deprecated
    public Item newItem() {
        return new Item();
    }

    private ItemTable() {
        this.load();
    }

    private void load() {
        int highest = 0;
        this._armors.clear();
        this._etcItems.clear();
        this._weapons.clear();
        for (L2Item item : SkillsEngine.getInstance().loadItems()) {
            if (highest < item.getItemId()) {
                highest = item.getItemId();
            }
            if (item instanceof L2EtcItem) {
                this._etcItems.put(item.getItemId(), (L2EtcItem)item);
                continue;
            }
            if (item instanceof L2Armor) {
                this._armors.put(item.getItemId(), (L2Armor)item);
                continue;
            }
            this._weapons.put(item.getItemId(), (L2Weapon)item);
        }
        this.buildFastLookupTable(highest);
    }

    private void buildFastLookupTable(int size) {
        L2Item item;
        _log.info("Highest item id used:" + size);
        this._allTemplates = new L2Item[size + 1];
        Iterator<L2Item> i$ = this._armors.values().iterator();
        while (i$.hasNext()) {
            this._allTemplates[item.getItemId()] = item = i$.next();
        }
        i$ = this._weapons.values().iterator();
        while (i$.hasNext()) {
            this._allTemplates[item.getItemId()] = item = (L2Weapon)i$.next();
        }
        i$ = this._etcItems.values().iterator();
        while (i$.hasNext()) {
            this._allTemplates[item.getItemId()] = item = (L2EtcItem)i$.next();
        }
    }

    public L2Item getTemplate(int id) {
        if (id >= this._allTemplates.length) {
            return null;
        }
        return this._allTemplates[id];
    }

    public L2ItemInstance createItem(String process, int itemId, long count, L2PcInstance actor, Object reference) {
        L2ItemInstance item = new L2ItemInstance(IdFactory.getInstance().getNextId(), itemId);
        if (process.equalsIgnoreCase("loot")) {
            ScheduledFuture<?> itemLootShedule;
            if (reference instanceof L2Attackable && ((L2Attackable)reference).isRaid()) {
                L2Attackable raid = (L2Attackable)reference;
                if (raid.getFirstCommandChannelAttacked() != null && !Config.AUTO_LOOT_RAIDS) {
                    item.setOwnerId(raid.getFirstCommandChannelAttacked().getChannelLeader().getObjectId());
                    itemLootShedule = ThreadPoolManager.getInstance().scheduleGeneral(new ResetOwner(item), Config.LOOT_RAIDS_PRIVILEGE_INTERVAL);
                    item.setItemLootShedule(itemLootShedule);
                }
            } else if (!Config.AUTO_LOOT || reference instanceof L2EventMonsterInstance && ((L2EventMonsterInstance)reference).eventDropOnGround()) {
                item.setOwnerId(actor.getObjectId());
                itemLootShedule = ThreadPoolManager.getInstance().scheduleGeneral(new ResetOwner(item), 15000L);
                item.setItemLootShedule(itemLootShedule);
            }
        }
        if (Config.DEBUG) {
            _log.fine("ItemTable: Item created  oid:" + item.getObjectId() + " itemid:" + itemId);
        }
        L2World.getInstance().storeObject(item);
        if (item.isStackable() && count > 1L) {
            item.setCount(count);
        }
        if (Config.LOG_ITEMS && !process.equals("Reset") && (!Config.LOG_ITEMS_SMALL_LOG || Config.LOG_ITEMS_SMALL_LOG && (item.isEquipable() || item.getItemId() == 57))) {
            LogRecord record = new LogRecord(Level.INFO, "CREATE:" + process);
            record.setLoggerName("item");
            record.setParameters(new Object[]{item, actor, reference});
            _logItems.log(record);
        }
        if (actor != null && actor.isGM()) {
            String targetName;
            String referenceName = "no-reference";
            if (reference instanceof L2Object) {
                referenceName = ((L2Object)reference).getName() != null ? ((L2Object)reference).getName() : "no-name";
            } else if (reference instanceof String) {
                referenceName = (String)reference;
            }
            String string = targetName = actor.getTarget() != null ? actor.getTarget().getName() : "no-target";
            if (Config.GMAUDIT) {
                GMAudit.auditGMAction(actor.getName() + " [" + actor.getObjectId() + "]", process + "(id: " + itemId + " count: " + count + " name: " + item.getItemName() + " objId: " + item.getObjectId() + ")", targetName, "L2Object referencing this action is: " + referenceName);
            }
        }
        return item;
    }

    public L2ItemInstance createItem(String process, int itemId, int count, L2PcInstance actor) {
        return this.createItem(process, itemId, count, actor, null);
    }

    public L2ItemInstance createDummyItem(int itemId) {
        L2Item item = this.getTemplate(itemId);
        if (item == null) {
            return null;
        }
        L2ItemInstance temp = new L2ItemInstance(0, item);
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyItem(String process, L2ItemInstance item, L2PcInstance actor, Object reference) {
        L2ItemInstance l2ItemInstance = item;
        synchronized (l2ItemInstance) {
            long old = item.getCount();
            item.setCount(0L);
            item.setOwnerId(0);
            item.setLocation(L2ItemInstance.ItemLocation.VOID);
            item.setLastChange(3);
            L2World.getInstance().removeObject(item);
            IdFactory.getInstance().releaseId(item.getObjectId());
            if (Config.LOG_ITEMS && (!Config.LOG_ITEMS_SMALL_LOG || Config.LOG_ITEMS_SMALL_LOG && (item.isEquipable() || item.getItemId() == 57))) {
                LogRecord record = new LogRecord(Level.INFO, "DELETE:" + process);
                record.setLoggerName("item");
                record.setParameters(new Object[]{item, "PrevCount(" + old + ")", actor, reference});
                _logItems.log(record);
            }
            if (actor != null && actor.isGM()) {
                String targetName;
                String referenceName = "no-reference";
                if (reference instanceof L2Object) {
                    referenceName = ((L2Object)reference).getName() != null ? ((L2Object)reference).getName() : "no-name";
                } else if (reference instanceof String) {
                    referenceName = (String)reference;
                }
                String string = targetName = actor.getTarget() != null ? actor.getTarget().getName() : "no-target";
                if (Config.GMAUDIT) {
                    GMAudit.auditGMAction(actor.getName() + " [" + actor.getObjectId() + "]", process + "(id: " + item.getItemId() + " count: " + item.getCount() + " itemObjId: " + item.getObjectId() + ")", targetName, "L2Object referencing this action is: " + referenceName);
                }
            }
            if (PetDataTable.isPetItem(item.getItemId())) {
                Connection con = null;
                try {
                    con = L2DatabaseFactory.getInstance().getConnection();
                    PreparedStatement statement = con.prepareStatement("DELETE FROM pets WHERE item_obj_id=?");
                    statement.setInt(1, item.getObjectId());
                    statement.execute();
                    statement.close();
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "could not delete pet objectid:", e);
                }
                finally {
                    L2DatabaseFactory.close(con);
                }
            }
        }
    }

    public void reload() {
        this.load();
        EnchantHPBonusData.getInstance().reload();
    }

    public Set<Integer> getAllEtcId() {
        return this._etcItems.keySet();
    }

    public Set<Integer> getAllArmorsId() {
        return this._armors.keySet();
    }

    public Set<Integer> getAllWeaponsId() {
        return this._weapons.keySet();
    }

    public int getArraySize() {
        return this._allTemplates.length;
    }

    static {
        _materials.put("adamantaite", 15);
        _materials.put("blood_steel", 2);
        _materials.put("bone", 12);
        _materials.put("bronze", 3);
        _materials.put("cloth", 10);
        _materials.put("chrysolite", 16);
        _materials.put("cobweb", 21);
        _materials.put("cotton", 1);
        _materials.put("crystal", 17);
        _materials.put("damascus", 14);
        _materials.put("dyestuff", 20);
        _materials.put("fine_steel", 1);
        _materials.put("fish", 23);
        _materials.put("gold", 5);
        _materials.put("horn", 13);
        _materials.put("leather", 11);
        _materials.put("liquid", 18);
        _materials.put("mithril", 6);
        _materials.put("oriharukon", 7);
        _materials.put("paper", 8);
        _materials.put("rune_xp", 24);
        _materials.put("rune_sp", 25);
        _materials.put("rune_remove_penalty", 32);
        _materials.put("scale_of_dragon", 19);
        _materials.put("seed", 22);
        _materials.put("silver", 4);
        _materials.put("steel", 0);
        _materials.put("wood", 9);
        _crystalTypes.put("s84", 7);
        _crystalTypes.put("s80", 6);
        _crystalTypes.put("s", 5);
        _crystalTypes.put("a", 4);
        _crystalTypes.put("b", 3);
        _crystalTypes.put("c", 2);
        _crystalTypes.put("d", 1);
        _crystalTypes.put("none", 0);
        for (L2WeaponType l2WeaponType : L2WeaponType.values()) {
            _weaponTypes.put(l2WeaponType.toString(), l2WeaponType);
        }
        for (Enum enum_ : L2ArmorType.values()) {
            _armorTypes.put(((L2ArmorType)enum_).toString(), (L2ArmorType)enum_);
        }
        _slots.put("shirt", 1);
        _slots.put("lbracelet", 0x200000);
        _slots.put("rbracelet", 0x100000);
        _slots.put("talisman", 0x400000);
        _slots.put("chest", 1024);
        _slots.put("fullarmor", 32768);
        _slots.put("head", 64);
        _slots.put("hair", 65536);
        _slots.put("hairall", 524288);
        _slots.put("underwear", 1);
        _slots.put("back", 8192);
        _slots.put("neck", 8);
        _slots.put("legs", 2048);
        _slots.put("feet", 4096);
        _slots.put("gloves", 512);
        _slots.put("chest,legs", 3072);
        _slots.put("belt", 0x10000000);
        _slots.put("rhand", 128);
        _slots.put("lhand", 256);
        _slots.put("lrhand", 16384);
        _slots.put("rear;lear", 6);
        _slots.put("rfinger;lfinger", 48);
        _slots.put("wolf", -100);
        _slots.put("greatwolf", -104);
        _slots.put("hatchling", -101);
        _slots.put("strider", -102);
        _slots.put("babypet", -103);
        _slots.put("none", 0);
        _slots.put("onepiece", 32768);
        _slots.put("hair2", 262144);
        _slots.put("dhair", 524288);
        _slots.put("alldress", 131072);
        _slots.put("deco1", 0x400000);
        _slots.put("waist", 0x10000000);
    }

    private static class SingletonHolder {
        protected static final ItemTable _instance = new ItemTable();

        private SingletonHolder() {
        }
    }

    protected static class ResetOwner
    implements Runnable {
        L2ItemInstance _item;

        public ResetOwner(L2ItemInstance item) {
            this._item = item;
        }

        @Override
        public void run() {
            this._item.setOwnerId(0);
            this._item.setItemLootShedule(null);
        }
    }
}

