/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.model.base.Race;
import com.l2jserver.gameserver.model.base.SubClass;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.util.Util;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javolution.util.FastList;
import javolution.util.FastMap;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class SkillTreesData {
    private static final Logger _log = Logger.getLogger(SkillTreesData.class.getName());
    private static final FastMap<ClassId, FastMap<Integer, L2SkillLearn>> _classSkillTrees = new FastMap();
    private static final FastMap<ClassId, FastMap<Integer, L2SkillLearn>> _transferSkillTrees = new FastMap();
    private static final FastMap<Integer, L2SkillLearn> _collectSkillTree = new FastMap();
    private static final FastMap<Integer, L2SkillLearn> _fishingSkillTree = new FastMap();
    private static final FastMap<Integer, L2SkillLearn> _pledgeSkillTree = new FastMap();
    private static final FastMap<Integer, L2SkillLearn> _subClassSkillTree = new FastMap();
    private static final FastMap<Integer, L2SkillLearn> _subPledgeSkillTree = new FastMap();
    private static final FastMap<Integer, L2SkillLearn> _transformSkillTree = new FastMap();
    private static final FastMap<Integer, L2SkillLearn> _commonSkillTree = new FastMap();
    private TIntObjectHashMap<int[]> _skillsByClassIdHashCodes;
    private TIntObjectHashMap<int[]> _skillsByRaceHashCodes;
    private int[] _allSkillsHashCodes;
    private boolean _loading = true;
    private static final FastMap<ClassId, ClassId> _parentClassMap = new FastMap();

    private SkillTreesData() {
        this.load();
    }

    public void load() {
        this._loading = true;
        _classSkillTrees.clear();
        _collectSkillTree.clear();
        _fishingSkillTree.clear();
        _pledgeSkillTree.clear();
        _subClassSkillTree.clear();
        _subPledgeSkillTree.clear();
        _transferSkillTrees.clear();
        _transformSkillTree.clear();
        this._loading = this.loadFiles();
        this.generateCheckArrays();
        int classSkillTreeCount = 0;
        for (ClassId classId : _classSkillTrees.keySet()) {
            classSkillTreeCount += ((FastMap)_classSkillTrees.get((Object)classId)).size();
        }
        int trasferSkillTreeCount = 0;
        for (ClassId classId : _transferSkillTrees.keySet()) {
            trasferSkillTreeCount += ((FastMap)_transferSkillTrees.get((Object)classId)).size();
        }
        int fishingDwarvenSkillCount = 0;
        for (L2SkillLearn fishSkill : _fishingSkillTree.values()) {
            if (fishSkill.getRaces() == null || !Util.contains(fishSkill.getRaces(), 4)) continue;
            ++fishingDwarvenSkillCount;
        }
        int residentialSkillCount = 0;
        for (L2SkillLearn pledgeSkill : _pledgeSkillTree.values()) {
            if (!pledgeSkill.isResidencialSkill()) continue;
            ++residentialSkillCount;
        }
        _log.info(this.getClass().getSimpleName() + ": Loaded " + classSkillTreeCount + "  Class Skills for " + _classSkillTrees.size() + " Class Skill Trees.");
        _log.info(this.getClass().getSimpleName() + ": Loaded " + _subClassSkillTree.size() + " Sub-Class Skills.");
        _log.info(this.getClass().getSimpleName() + ": Loaded " + trasferSkillTreeCount + " Transfer Skills for " + _transferSkillTrees.size() + " Transfer Skill Trees.");
        _log.info(this.getClass().getSimpleName() + ": Loaded " + _fishingSkillTree.size() + " Fishing Skills, " + fishingDwarvenSkillCount + " Dwarven only Fishing Skills.");
        _log.info(this.getClass().getSimpleName() + ": Loaded " + _collectSkillTree.size() + " Collect Skills.");
        _log.info(this.getClass().getSimpleName() + ": Loaded " + _pledgeSkillTree.size() + " Pledge Skills, " + (_pledgeSkillTree.size() - residentialSkillCount) + " for Pledge and " + residentialSkillCount + " Residential.");
        _log.info(this.getClass().getSimpleName() + ": Loaded " + _subPledgeSkillTree.size() + " Sub-Pledge Skills.");
        _log.info(this.getClass().getSimpleName() + ": Loaded " + _transformSkillTree.size() + " Transform Skills.");
        int commonSkills = _commonSkillTree.size();
        if (commonSkills > 0) {
            _log.info(this.getClass().getSimpleName() + ": Loaded " + commonSkills + " Common Skills to all classes.");
        }
    }

    private boolean loadFiles() {
        File[] listOfFiles;
        File folder = new File(Config.DATAPACK_ROOT, "data/skillTrees/");
        for (File f : listOfFiles = folder.listFiles()) {
            if (!f.getName().endsWith(".xml")) continue;
            this.loadSkillTree(f);
        }
        return false;
    }

    private void loadSkillTree(File file) {
        if (!file.exists()) {
            _log.warning(this.getClass().getSimpleName() + ": Could not parse " + file.getName() + " file doesn't exist");
            return;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setIgnoringComments(true);
        Document doc = null;
        try {
            doc = dbf.newDocumentBuilder().parse(file);
        }
        catch (Exception e) {
            _log.warning(this.getClass().getSimpleName() + ": Could not parse " + file.getName() + " file: " + e.getMessage());
            return;
        }
        String type = null;
        int cId = -1;
        int parentClassId = -1;
        ClassId classId = null;
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                Node attribute;
                FastMap trasferSkillTree;
                FastMap classSkillTree;
                block40: {
                    block39: {
                        classSkillTree = new FastMap();
                        trasferSkillTree = new FastMap();
                        if (!"skillTree".equalsIgnoreCase(d.getNodeName())) continue;
                        attribute = d.getAttributes().getNamedItem("type");
                        if (attribute == null) {
                            _log.warning(this.getClass().getSimpleName() + ": Skill Tree without type!");
                            continue;
                        }
                        type = attribute.getNodeValue();
                        attribute = d.getAttributes().getNamedItem("classId");
                        if (attribute != null) {
                            try {
                                cId = Integer.parseInt(attribute.getNodeValue());
                                if (cId == -1) break block39;
                                classId = ClassId.values()[cId];
                            }
                            catch (Exception e) {
                                _log.warning(this.getClass().getSimpleName() + ": Invalid class Id " + attribute.getNodeValue() + " for Skill Tree type: " + type + "!");
                                continue;
                            }
                        }
                    }
                    if ((attribute = d.getAttributes().getNamedItem("parentClassId")) != null) {
                        try {
                            parentClassId = Integer.parseInt(attribute.getNodeValue());
                            if (cId <= -1 || cId == parentClassId || parentClassId <= -1) break block40;
                            _parentClassMap.putIfAbsent((Object)classId, (Object)ClassId.values()[parentClassId]);
                        }
                        catch (Exception e) {
                            _log.warning(this.getClass().getSimpleName() + ": Invalid parent class Id " + attribute.getNodeValue() + " for Skill Tree type: " + type + "!");
                            continue;
                        }
                    }
                }
                for (Node c = d.getFirstChild(); c != null; c = c.getNextSibling()) {
                    int skillLvl;
                    int skillId;
                    if (!"skill".equalsIgnoreCase(c.getNodeName())) continue;
                    StatsSet learnSkillSet = new StatsSet();
                    NamedNodeMap attributes = c.getAttributes();
                    attribute = attributes.getNamedItem("skillName");
                    if (attribute == null) {
                        _log.severe(this.getClass().getSimpleName() + ": Missing skillName, skipping!");
                        continue;
                    }
                    learnSkillSet.set("skillName", attribute.getNodeValue());
                    attribute = attributes.getNamedItem("skillIdLvl");
                    if (attribute == null) {
                        _log.severe(this.getClass().getSimpleName() + ": Missing skillIdLvl, skipping!");
                        continue;
                    }
                    try {
                        skillId = Integer.parseInt(attribute.getNodeValue().split(",")[0]);
                        skillLvl = Integer.parseInt(attribute.getNodeValue().split(",")[1]);
                        learnSkillSet.set("skillId", skillId);
                        learnSkillSet.set("skillLvl", skillLvl);
                    }
                    catch (Exception e) {
                        _log.severe(this.getClass().getSimpleName() + ": Malformed skillIdLvl, skipping!");
                        continue;
                    }
                    attribute = attributes.getNamedItem("getLevel");
                    if (attribute != null) {
                        learnSkillSet.set("getLevel", attribute.getNodeValue());
                    }
                    if ((attribute = attributes.getNamedItem("autoGet")) != null) {
                        learnSkillSet.set("autoGet", attribute.getNodeValue());
                    }
                    if ((attribute = attributes.getNamedItem("levelUpSp")) != null) {
                        learnSkillSet.set("levelUpSp", attribute.getNodeValue());
                    }
                    if ((attribute = attributes.getNamedItem("itemsIdCount")) != null) {
                        learnSkillSet.set("itemsIdCount", attribute.getNodeValue());
                    }
                    if ((attribute = attributes.getNamedItem("race")) != null) {
                        learnSkillSet.set("race", attribute.getNodeValue());
                    }
                    if ((attribute = attributes.getNamedItem("preReqSkillIdLvl")) != null) {
                        learnSkillSet.set("preReqSkillIdLvl", attribute.getNodeValue());
                    }
                    if ((attribute = attributes.getNamedItem("socialClass")) != null) {
                        learnSkillSet.set("socialClass", attribute.getNodeValue());
                    }
                    if ((attribute = attributes.getNamedItem("subClassLvlNumber")) != null) {
                        learnSkillSet.set("subClassLvlNumber", attribute.getNodeValue());
                    }
                    if ((attribute = attributes.getNamedItem("residenceSkill")) != null) {
                        learnSkillSet.set("residenceSkill", attribute.getNodeValue());
                    }
                    if ((attribute = attributes.getNamedItem("residenceIds")) != null) {
                        learnSkillSet.set("residenceIds", attribute.getNodeValue());
                    }
                    if ((attribute = attributes.getNamedItem("learnedByNpc")) != null) {
                        learnSkillSet.set("learnedByNpc", attribute.getNodeValue());
                    }
                    if ((attribute = attributes.getNamedItem("learnedByFS")) != null) {
                        learnSkillSet.set("learnedByFS", attribute.getNodeValue());
                    }
                    L2SkillLearn skillLearn = new L2SkillLearn(learnSkillSet);
                    int skillHashCode = SkillTable.getSkillHashCode(skillId, skillLvl);
                    if (type.equals("classSkillTree")) {
                        if (cId != -1) {
                            classSkillTree.put((Object)skillHashCode, (Object)skillLearn);
                            continue;
                        }
                        _commonSkillTree.put((Object)skillHashCode, (Object)skillLearn);
                        continue;
                    }
                    if (type.equals("transferSkillTree")) {
                        trasferSkillTree.put((Object)skillHashCode, (Object)skillLearn);
                        continue;
                    }
                    if (type.equals("collectSkillTree")) {
                        _collectSkillTree.put((Object)skillHashCode, (Object)skillLearn);
                        continue;
                    }
                    if (type.equals("fishingSkillTree")) {
                        _fishingSkillTree.put((Object)skillHashCode, (Object)skillLearn);
                        continue;
                    }
                    if (type.equals("pledgeSkillTree")) {
                        _pledgeSkillTree.put((Object)skillHashCode, (Object)skillLearn);
                        continue;
                    }
                    if (type.equals("subClassSkillTree")) {
                        _subClassSkillTree.put((Object)skillHashCode, (Object)skillLearn);
                        continue;
                    }
                    if (type.equals("subPledgeSkillTree")) {
                        _subPledgeSkillTree.put((Object)skillHashCode, (Object)skillLearn);
                        continue;
                    }
                    if (!type.equals("transformSkillTree")) continue;
                    _transformSkillTree.put((Object)skillHashCode, (Object)skillLearn);
                }
                if (type.equals("classSkillTree")) {
                    if (cId == -1) continue;
                    if (_classSkillTrees.get((Object)classId) == null) {
                        _classSkillTrees.put((Object)classId, (Object)classSkillTree);
                        continue;
                    }
                    ((FastMap)_classSkillTrees.get((Object)classId)).putAll((Map)classSkillTree);
                    continue;
                }
                if (!type.equals("transferSkillTree")) continue;
                _transferSkillTrees.put((Object)classId, (Object)trasferSkillTree);
            }
        }
    }

    private FastMap<ClassId, FastMap<Integer, L2SkillLearn>> getClassSkillTrees() {
        return _classSkillTrees;
    }

    public FastMap<Integer, L2SkillLearn> getCompleteClassSkillTree(ClassId classId) {
        FastMap skillTree = new FastMap();
        skillTree.putAll(_commonSkillTree);
        while (classId != null && this.getClassSkillTrees().get((Object)classId) != null) {
            skillTree.putAll((Map)this.getClassSkillTrees().get((Object)classId));
            classId = (ClassId)((Object)_parentClassMap.get((Object)classId));
        }
        return skillTree;
    }

    public FastMap<Integer, L2SkillLearn> getTransferSkillTree(ClassId classId) {
        if (classId.level() >= 3) {
            classId = classId.getParent();
            return this.getTransferSkillTree(classId);
        }
        return (FastMap)_transferSkillTrees.get((Object)classId);
    }

    public FastMap<Integer, L2SkillLearn> getCommonSkillTree() {
        return _commonSkillTree;
    }

    public FastMap<Integer, L2SkillLearn> getCollectSkillTree() {
        return _collectSkillTree;
    }

    public FastMap<Integer, L2SkillLearn> getFishingSkillTree() {
        return _fishingSkillTree;
    }

    public FastMap<Integer, L2SkillLearn> getPledgeSkillTree() {
        return _pledgeSkillTree;
    }

    public FastMap<Integer, L2SkillLearn> getSubClassSkillTree() {
        return _subClassSkillTree;
    }

    public FastMap<Integer, L2SkillLearn> getSubPledgeSkillTree() {
        return _subPledgeSkillTree;
    }

    public FastMap<Integer, L2SkillLearn> getTransformSkillTree() {
        return _transformSkillTree;
    }

    public FastList<L2SkillLearn> getAvailableSkills(L2PcInstance player, ClassId classId, boolean includeByFs, boolean includeAutoGet) {
        FastList result = new FastList();
        FastMap<Integer, L2SkillLearn> skills = this.getCompleteClassSkillTree(classId);
        if (skills.isEmpty()) {
            _log.warning(this.getClass().getSimpleName() + ": Skilltree for class " + (Object)((Object)classId) + " is not defined!");
            return result;
        }
        L2Skill[] oldSkills = player.getAllSkills();
        for (L2SkillLearn temp : skills.values()) {
            if ((!includeAutoGet || !temp.isAutoGet()) && !temp.isLearnedByNpc() && (!includeByFs || !temp.isLearnedByFS()) || player.getLevel() < temp.getGetLevel()) continue;
            boolean knownSkill = false;
            for (int j = 0; j < oldSkills.length && !knownSkill; ++j) {
                if (oldSkills[j].getId() != temp.getSkillId()) continue;
                if (oldSkills[j].getLevel() == temp.getSkillLevel() - 1) {
                    result.add((Object)temp);
                }
                knownSkill = true;
            }
            if (knownSkill || temp.getSkillLevel() != 1) continue;
            result.add((Object)temp);
        }
        return result;
    }

    public FastList<L2SkillLearn> getAvailableAutoGetSkills(L2PcInstance player) {
        FastList result = new FastList();
        FastMap<Integer, L2SkillLearn> skills = this.getCompleteClassSkillTree(player.getClassId());
        if (skills.size() < 1) {
            _log.warning(this.getClass().getSimpleName() + ": Skill Tree for this classId(" + (Object)((Object)player.getClassId()) + ") is not defined!");
            return result;
        }
        L2Skill[] oldSkills = player.getAllSkills();
        for (L2SkillLearn temp : skills.values()) {
            if (temp.getRaces() != null && Util.contains(temp.getRaces(), 4) && !player.hasDwarvenCraft() || !temp.isAutoGet() || player.getLevel() < temp.getGetLevel()) continue;
            boolean knownSkill = false;
            for (int j = 0; j < oldSkills.length && !knownSkill; ++j) {
                if (oldSkills[j].getId() != temp.getSkillId()) continue;
                if (oldSkills[j].getLevel() < temp.getSkillLevel()) {
                    result.add((Object)temp);
                }
                knownSkill = true;
            }
            if (knownSkill) continue;
            result.add((Object)temp);
        }
        return result;
    }

    public FastList<L2SkillLearn> getAvailableFishingSkills(L2PcInstance player) {
        FastList result = new FastList();
        FastMap skills = new FastMap();
        skills.putAll(_fishingSkillTree);
        if (skills.size() < 1) {
            _log.warning(this.getClass().getSimpleName() + ": Skilltree for fishing is not defined !");
            return result;
        }
        L2Skill[] oldSkills = player.getAllSkills();
        for (L2SkillLearn temp : skills.values()) {
            if (temp.getRaces() != null && Util.contains(temp.getRaces(), 4) && !player.hasDwarvenCraft() || !temp.isLearnedByNpc() || player.getLevel() < temp.getGetLevel()) continue;
            boolean knownSkill = false;
            for (int j = 0; j < oldSkills.length && !knownSkill; ++j) {
                if (oldSkills[j].getId() != temp.getSkillId()) continue;
                if (oldSkills[j].getLevel() == temp.getSkillLevel() - 1) {
                    result.add((Object)temp);
                }
                knownSkill = true;
            }
            if (knownSkill || temp.getSkillLevel() != 1) continue;
            result.add((Object)temp);
        }
        return result;
    }

    public FastList<L2SkillLearn> getAvailableCollectSkills(L2PcInstance player) {
        FastList result = new FastList();
        FastMap skills = new FastMap();
        skills.putAll(_collectSkillTree);
        if (skills.size() < 1) {
            _log.warning(this.getClass().getSimpleName() + ": Skilltree for collecting skills is not defined !");
            return result;
        }
        L2Skill[] oldSkills = player.getAllSkills();
        for (L2SkillLearn temp : skills.values()) {
            boolean knownSkill = false;
            for (int j = 0; j < oldSkills.length && !knownSkill; ++j) {
                if (oldSkills[j].getId() != temp.getSkillId()) continue;
                if (oldSkills[j].getLevel() == temp.getSkillLevel() - 1) {
                    result.add((Object)temp);
                }
                knownSkill = true;
            }
            if (knownSkill || temp.getSkillLevel() != 1) continue;
            result.add((Object)temp);
        }
        return result;
    }

    public FastList<L2SkillLearn> getAvailableTransferSkills(L2PcInstance player) {
        FastList result = new FastList();
        ClassId classId = player.getClassId();
        if (classId.level() == 3) {
            classId = classId.getParent();
        }
        if (_transferSkillTrees.get((Object)classId) == null) {
            return result;
        }
        for (L2SkillLearn temp : ((FastMap)_transferSkillTrees.get((Object)classId)).values()) {
            if (player.getKnownSkill(temp.getSkillId()) != null) continue;
            result.add((Object)temp);
        }
        return result;
    }

    public FastList<L2SkillLearn> getAvailableTransformSkills(L2PcInstance player) {
        FastList result = new FastList();
        FastMap<Integer, L2SkillLearn> skills = _transformSkillTree;
        if (skills == null) {
            _log.warning(this.getClass().getSimpleName() + ": No Transform skills defined!");
            return result;
        }
        L2Skill[] oldSkills = player.getAllSkills();
        for (L2SkillLearn temp : skills.values()) {
            if (player.getLevel() < temp.getGetLevel() || temp.getRaces() != null && !Util.contains(temp.getRaces(), player.getRace().ordinal())) continue;
            boolean knownSkill = false;
            for (int j = 0; j < oldSkills.length && !knownSkill; ++j) {
                if (oldSkills[j].getId() != temp.getSkillId()) continue;
                if (oldSkills[j].getLevel() == temp.getSkillLevel() - 1) {
                    result.add((Object)temp);
                }
                knownSkill = true;
            }
            if (knownSkill || temp.getSkillLevel() != 1) continue;
            result.add((Object)temp);
        }
        return result;
    }

    public FastList<L2SkillLearn> getAvailablePledgeSkills(L2Clan clan) {
        FastList result = new FastList();
        FastMap<Integer, L2SkillLearn> skills = _pledgeSkillTree;
        if (skills == null) {
            _log.warning(this.getClass().getSimpleName() + ": No clan skills defined!");
            return result;
        }
        L2Skill[] oldSkills = clan.getAllSkills();
        for (L2SkillLearn temp : skills.values()) {
            if (temp.isResidencialSkill() || clan.getLevel() < temp.getGetLevel()) continue;
            boolean knownSkill = false;
            for (int j = 0; j < oldSkills.length && !knownSkill; ++j) {
                if (oldSkills[j].getId() != temp.getSkillId()) continue;
                if (oldSkills[j].getLevel() == temp.getSkillLevel() - 1) {
                    result.add((Object)temp);
                }
                knownSkill = true;
            }
            if (knownSkill || temp.getSkillLevel() != 1) continue;
            result.add((Object)temp);
        }
        return result;
    }

    public FastList<L2SkillLearn> getAvailableSubPledgeSkills(L2Clan clan) {
        FastList result = new FastList();
        FastMap<Integer, L2SkillLearn> skills = _subPledgeSkillTree;
        if (skills == null) {
            _log.warning(this.getClass().getSimpleName() + ": No sub-clan skills defined!");
            return result;
        }
        for (L2SkillLearn temp : skills.values()) {
            if (clan.getLevel() < temp.getGetLevel() || !clan.isLearnableSubSkill(temp.getSkillId(), temp.getSkillLevel())) continue;
            result.add((Object)temp);
        }
        return result;
    }

    public FastList<L2SkillLearn> getAvailableSubClassSkills(L2PcInstance player) {
        FastList result = new FastList();
        FastMap<Integer, L2SkillLearn> skills = _subClassSkillTree;
        if (skills == null) {
            _log.warning(this.getClass().getSimpleName() + ": No Sub-Class skills defined!");
            return result;
        }
        L2Skill[] oldSkills = player.getAllSkills();
        for (L2SkillLearn temp : skills.values()) {
            if (player.getLevel() < temp.getGetLevel()) continue;
            int[][] subClassConds = null;
            for (SubClass subClass : player.getSubClasses().values()) {
                subClassConds = temp.getSubClassConditions();
                if (subClassConds == null || subClass.getClassIndex() > subClassConds.length || subClass.getClassIndex() != subClassConds[subClass.getClassIndex() - 1][1] || subClassConds[subClass.getClassIndex() - 1][0] > subClass.getLevel()) continue;
                boolean knownSkill = false;
                for (int j = 0; j < oldSkills.length && !knownSkill; ++j) {
                    if (oldSkills[j].getId() != temp.getSkillId()) continue;
                    if (oldSkills[j].getLevel() == temp.getSkillLevel() - 1) {
                        result.add((Object)temp);
                    }
                    knownSkill = true;
                }
                if (knownSkill || temp.getSkillLevel() != 1) continue;
                result.add((Object)temp);
            }
        }
        return result;
    }

    public FastList<L2SkillLearn> getAvailableResidentialSkills(int residenceId) {
        FastList result = new FastList();
        FastMap<Integer, L2SkillLearn> skills = _pledgeSkillTree;
        if (skills == null) {
            _log.warning(this.getClass().getSimpleName() + ": No residential skills defined!");
            return result;
        }
        for (L2SkillLearn temp : skills.values()) {
            if (!temp.isResidencialSkill() || temp.getRecidenceIds() == null || !Util.contains(temp.getRecidenceIds(), residenceId)) continue;
            result.add((Object)temp);
        }
        return result;
    }

    public L2SkillLearn getTransformSkill(int id, int lvl) {
        return (L2SkillLearn)_transformSkillTree.get((Object)SkillTable.getSkillHashCode(id, lvl));
    }

    public L2SkillLearn getClassSkill(int id, int lvl, ClassId classId) {
        FastMap<Integer, L2SkillLearn> skills = this.getCompleteClassSkillTree(classId);
        return (L2SkillLearn)skills.get((Object)SkillTable.getSkillHashCode(id, lvl));
    }

    public L2SkillLearn getFishingSkill(int id, int lvl) {
        return (L2SkillLearn)_fishingSkillTree.get((Object)SkillTable.getSkillHashCode(id, lvl));
    }

    public L2SkillLearn getPledgeSkill(int id, int lvl) {
        return (L2SkillLearn)_pledgeSkillTree.get((Object)SkillTable.getSkillHashCode(id, lvl));
    }

    public L2SkillLearn getSubPledgeSkill(int id, int lvl) {
        return (L2SkillLearn)_subPledgeSkillTree.get((Object)SkillTable.getSkillHashCode(id, lvl));
    }

    public L2SkillLearn getTransferSkill(int id, int lvl, ClassId classId) {
        ClassId parentId;
        if (classId.getParent() != null && _transferSkillTrees.get((Object)(parentId = classId.getParent())) != null) {
            return (L2SkillLearn)((FastMap)_transferSkillTrees.get((Object)parentId)).get((Object)SkillTable.getSkillHashCode(id, lvl));
        }
        return null;
    }

    public L2SkillLearn getSubClassSkill(int id, int lvl) {
        return (L2SkillLearn)_subClassSkillTree.get((Object)SkillTable.getSkillHashCode(id, lvl));
    }

    public L2SkillLearn getCommonSkill(int id, int lvl) {
        return (L2SkillLearn)_commonSkillTree.get((Object)SkillTable.getSkillHashCode(id, lvl));
    }

    public L2SkillLearn getCollectSkill(int id, int lvl) {
        return (L2SkillLearn)_collectSkillTree.get((Object)SkillTable.getSkillHashCode(id, lvl));
    }

    public int getMinLevelForNewSkill(L2PcInstance player, FastMap<Integer, L2SkillLearn> skillTree) {
        int minLevel = 0;
        if (skillTree.isEmpty()) {
            _log.warning(this.getClass().getSimpleName() + ": SkillTree is not defined for getMinLevelForNewSkill!");
        } else {
            for (L2SkillLearn s : skillTree.values()) {
                if (!s.isLearnedByNpc() || player.getLevel() >= s.getGetLevel() || minLevel != 0 && minLevel <= s.getGetLevel()) continue;
                minLevel = s.getGetLevel();
            }
        }
        return minLevel;
    }

    private void generateCheckArrays() {
        int[] array;
        int i;
        Set keySet = this.getClassSkillTrees().keySet();
        this._skillsByClassIdHashCodes = new TIntObjectHashMap(keySet.size());
        for (ClassId cls : keySet) {
            i = 0;
            FastMap<Integer, L2SkillLearn> tempMap = this.getCompleteClassSkillTree(cls);
            array = new int[tempMap.size()];
            Iterator i$ = tempMap.keySet().iterator();
            while (i$.hasNext()) {
                int h = (Integer)i$.next();
                array[i++] = h;
            }
            tempMap.clear();
            Arrays.sort(array);
            this._skillsByClassIdHashCodes.put(cls.ordinal(), (Object)array);
        }
        FastList list = new FastList();
        this._skillsByRaceHashCodes = new TIntObjectHashMap(Race.values().length);
        for (Race r : Race.values()) {
            for (L2SkillLearn s : _fishingSkillTree.values()) {
                if (s.getRaces() == null || !Util.contains(s.getRaces(), r.ordinal())) continue;
                list.add((Object)SkillTable.getSkillHashCode(s.getSkillId(), s.getSkillLevel()));
            }
            for (L2SkillLearn s : _transformSkillTree.values()) {
                if (s.getRaces() == null || !Util.contains(s.getRaces(), r.ordinal())) continue;
                list.add((Object)SkillTable.getSkillHashCode(s.getSkillId(), s.getSkillLevel()));
            }
            i = 0;
            array = new int[list.size()];
            Iterator i$ = list.iterator();
            while (i$.hasNext()) {
                int s = (Integer)i$.next();
                array[i++] = s;
            }
            Arrays.sort(array);
            this._skillsByRaceHashCodes.put(r.ordinal(), (Object)array);
            list.clear();
        }
        for (L2SkillLearn s : _commonSkillTree.values()) {
            if (s.getRaces() != null) continue;
            list.add((Object)SkillTable.getSkillHashCode(s.getSkillId(), s.getSkillLevel()));
        }
        for (L2SkillLearn s : _fishingSkillTree.values()) {
            if (s.getRaces() != null) continue;
            list.add((Object)SkillTable.getSkillHashCode(s.getSkillId(), s.getSkillLevel()));
        }
        for (L2SkillLearn s : _transformSkillTree.values()) {
            if (s.getRaces() != null) continue;
            list.add((Object)SkillTable.getSkillHashCode(s.getSkillId(), s.getSkillLevel()));
        }
        for (L2SkillLearn s : _collectSkillTree.values()) {
            list.add((Object)SkillTable.getSkillHashCode(s.getSkillId(), s.getSkillLevel()));
        }
        this._allSkillsHashCodes = new int[list.size()];
        int j = 0;
        Iterator i$ = list.iterator();
        while (i$.hasNext()) {
            int hashcode = (Integer)i$.next();
            this._allSkillsHashCodes[j++] = hashcode;
        }
        Arrays.sort(this._allSkillsHashCodes);
    }

    public boolean isSkillAllowed(L2PcInstance player, L2Skill skill) {
        if (skill.isExcludedFromCheck()) {
            return true;
        }
        if (player.isGM() && skill.isGMSkill()) {
            return true;
        }
        if (this._loading) {
            return true;
        }
        int maxLvl = SkillTable.getInstance().getMaxLevel(skill.getId());
        int hashCode = SkillTable.getSkillHashCode(skill.getId(), Math.min(skill.getLevel(), maxLvl));
        if (Arrays.binarySearch((int[])this._skillsByClassIdHashCodes.get(player.getClassId().ordinal()), hashCode) >= 0) {
            return true;
        }
        if (Arrays.binarySearch((int[])this._skillsByRaceHashCodes.get(player.getRace().ordinal()), hashCode) >= 0) {
            return true;
        }
        if (Arrays.binarySearch(this._allSkillsHashCodes, hashCode) >= 0) {
            return true;
        }
        return this.getTransferSkill(skill.getId(), skill.getLevel(), player.getClassId()) != null;
    }

    public static SkillTreesData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final SkillTreesData _instance = new SkillTreesData();

        private SingletonHolder() {
        }
    }
}

