/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.cache.CrestCache;
import com.l2jserver.gameserver.communitybbs.BB.Forum;
import com.l2jserver.gameserver.communitybbs.Manager.ForumsBBSManager;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.BlockList;
import com.l2jserver.gameserver.model.ClanWarehouse;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.communityserver.CommunityServerThread;
import com.l2jserver.gameserver.network.communityserver.writepackets.WorldInfo;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.ExSubPledgeSkillAdd;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.PledgeReceiveSubPledgeCreated;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowInfoUpdate;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListAll;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListDeleteAll;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListUpdate;
import com.l2jserver.gameserver.network.serverpackets.PledgeSkillList;
import com.l2jserver.gameserver.network.serverpackets.PledgeSkillListAdd;
import com.l2jserver.gameserver.network.serverpackets.SkillCoolTime;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class L2Clan {
    private static final Logger _log = Logger.getLogger(L2Clan.class.getName());
    private String _name;
    private int _clanId;
    private L2ClanMember _leader;
    private Map<Integer, L2ClanMember> _members = new FastMap();
    private String _allyName;
    private int _allyId;
    private int _level;
    private int _hasCastle;
    private int _hasFort;
    private int _hasHideout;
    private int _hiredGuards;
    private int _crestId;
    private int _crestLargeId;
    private int _allyCrestId;
    private int _auctionBiddedAt = 0;
    private long _allyPenaltyExpiryTime;
    private int _allyPenaltyType;
    private long _charPenaltyExpiryTime;
    private long _dissolvingExpiryTime;
    public static final int PENALTY_TYPE_CLAN_LEAVED = 1;
    public static final int PENALTY_TYPE_CLAN_DISMISSED = 2;
    public static final int PENALTY_TYPE_DISMISS_CLAN = 3;
    public static final int PENALTY_TYPE_DISSOLVE_ALLY = 4;
    private ItemContainer _warehouse = new ClanWarehouse(this);
    private List<Integer> _atWarWith = new FastList();
    private List<Integer> _atWarAttackers = new FastList();
    private Forum _forum;
    public static final int CP_NOTHING = 0;
    public static final int CP_CL_JOIN_CLAN = 2;
    public static final int CP_CL_GIVE_TITLE = 4;
    public static final int CP_CL_VIEW_WAREHOUSE = 8;
    public static final int CP_CL_MANAGE_RANKS = 16;
    public static final int CP_CL_PLEDGE_WAR = 32;
    public static final int CP_CL_DISMISS = 64;
    public static final int CP_CL_REGISTER_CREST = 128;
    public static final int CP_CL_APPRENTICE = 256;
    public static final int CP_CL_TROOPS_FAME = 512;
    public static final int CP_CL_SUMMON_AIRSHIP = 1024;
    public static final int CP_CH_OPEN_DOOR = 2048;
    public static final int CP_CH_OTHER_RIGHTS = 4096;
    public static final int CP_CH_AUCTION = 8192;
    public static final int CP_CH_DISMISS = 16384;
    public static final int CP_CH_SET_FUNCTIONS = 32768;
    public static final int CP_CS_OPEN_DOOR = 65536;
    public static final int CP_CS_MANOR_ADMIN = 131072;
    public static final int CP_CS_MANAGE_SIEGE = 262144;
    public static final int CP_CS_USE_FUNCTIONS = 524288;
    public static final int CP_CS_DISMISS = 0x100000;
    public static final int CP_CS_TAXES = 0x200000;
    public static final int CP_CS_MERCENARIES = 0x400000;
    public static final int CP_CS_SET_FUNCTIONS = 0x800000;
    public static final int CP_ALL = 0xFFFFFE;
    public static final int SUBUNIT_ACADEMY = -1;
    public static final int SUBUNIT_ROYAL1 = 100;
    public static final int SUBUNIT_ROYAL2 = 200;
    public static final int SUBUNIT_KNIGHT1 = 1001;
    public static final int SUBUNIT_KNIGHT2 = 1002;
    public static final int SUBUNIT_KNIGHT3 = 2001;
    public static final int SUBUNIT_KNIGHT4 = 2002;
    private final Map<Integer, L2Skill> _skills = new FastMap();
    private final Map<Integer, RankPrivs> _privs = new FastMap();
    private final Map<Integer, SubPledge> _subPledges = new FastMap();
    private final Map<Integer, L2Skill> _subPledgeSkills = new FastMap();
    private int _reputationScore = 0;
    private int _rank = 0;
    private String _notice;
    private boolean _noticeEnabled = false;
    private static final int MAX_NOTICE_LENGTH = 8192;

    public L2Clan(int clanId) {
        this._clanId = clanId;
        this.initializePrivs();
        this.restore();
        this.getWarehouse().restore();
    }

    public L2Clan(int clanId, String clanName) {
        this._clanId = clanId;
        this._name = clanName;
        this.initializePrivs();
    }

    public int getClanId() {
        return this._clanId;
    }

    public void setClanId(int clanId) {
        this._clanId = clanId;
    }

    public int getLeaderId() {
        return this._leader != null ? this._leader.getObjectId() : 0;
    }

    public L2ClanMember getLeader() {
        return this._leader;
    }

    public void setLeader(L2ClanMember leader) {
        this._leader = leader;
        this._members.put(leader.getObjectId(), leader);
    }

    public void setNewLeader(L2ClanMember member) {
        if (!this.getLeader().isOnline()) {
            return;
        }
        if (member == null) {
            return;
        }
        if (!member.isOnline()) {
            return;
        }
        L2PcInstance exLeader = this.getLeader().getPlayerInstance();
        SiegeManager.getInstance().removeSiegeSkills(exLeader);
        exLeader.setClan(this);
        exLeader.setClanPrivileges(0);
        exLeader.broadcastUserInfo();
        this.setLeader(member);
        this.updateClanInDB();
        exLeader.setPledgeClass(exLeader.getClan().getClanMember(exLeader.getObjectId()).calculatePledgeClass(exLeader));
        exLeader.broadcastUserInfo();
        exLeader.checkItemRestriction();
        L2PcInstance newLeader = member.getPlayerInstance();
        newLeader.setClan(this);
        newLeader.setPledgeClass(member.calculatePledgeClass(newLeader));
        newLeader.setClanPrivileges(0xFFFFFE);
        if (this.getLevel() >= SiegeManager.getInstance().getSiegeClanMinLevel()) {
            SiegeManager.getInstance().addSiegeSkills(newLeader);
            if (!exLeader.getReuseTimeStamp().isEmpty()) {
                for (L2Skill sk : SkillTable.getInstance().getSiegeSkills(newLeader.isNoble(), this.getHasCastle() > 0)) {
                    if (!exLeader.getReuseTimeStamp().containsKey((Object)sk.getReuseHashCode())) continue;
                    L2PcInstance.TimeStamp t = (L2PcInstance.TimeStamp)exLeader.getReuseTimeStamp().get((Object)sk.getReuseHashCode());
                    newLeader.addTimeStamp(sk, t.getReuse(), t.getStamp());
                }
                newLeader.sendPacket(new SkillCoolTime(newLeader));
            }
        }
        newLeader.broadcastUserInfo();
        this.broadcastClanStatus();
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.CLAN_LEADER_PRIVILEGES_HAVE_BEEN_TRANSFERRED_TO_C1);
        sm.addString(newLeader.getName());
        this.broadcastToOnlineMembers(sm);
        sm = null;
        CommunityServerThread.getInstance().sendPacket(new WorldInfo(null, this, 3));
    }

    public String getLeaderName() {
        return this._members.get(this._leader.getObjectId()).getName();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    private void addClanMember(L2ClanMember member) {
        this._members.put(member.getObjectId(), member);
    }

    public void addClanMember(L2PcInstance player) {
        L2ClanMember member = new L2ClanMember(this, player);
        this.addClanMember(member);
        member.setPlayerInstance(player);
        player.setClan(this);
        player.setPledgeClass(member.calculatePledgeClass(player));
        player.sendPacket(new PledgeShowMemberListUpdate(player));
        player.sendPacket(new PledgeSkillList(this));
        this.addSkillEffects(player);
        CommunityServerThread.getInstance().sendPacket(new WorldInfo(null, this, 3));
    }

    public void updateClanMember(L2PcInstance player) {
        L2ClanMember member = new L2ClanMember(player);
        if (player.isClanLeader()) {
            this.setLeader(member);
        }
        this.addClanMember(member);
        CommunityServerThread.getInstance().sendPacket(new WorldInfo(null, this, 3));
    }

    public L2ClanMember getClanMember(String name) {
        for (L2ClanMember temp : this._members.values()) {
            if (!temp.getName().equals(name)) continue;
            return temp;
        }
        return null;
    }

    public L2ClanMember getClanMember(int objectID) {
        return this._members.get(objectID);
    }

    public void removeClanMember(int objectId, long clanJoinExpiryTime) {
        L2ClanMember sponsor;
        L2ClanMember apprentice;
        L2ClanMember exMember = this._members.remove(objectId);
        if (exMember == null) {
            _log.warning("Member Object ID: " + objectId + " not found in clan while trying to remove");
            return;
        }
        int leadssubpledge = this.getLeaderSubPledge(objectId);
        if (leadssubpledge != 0) {
            this.getSubPledge(leadssubpledge).setLeaderId(0);
            this.updateSubPledgeInDB(leadssubpledge);
        }
        if (exMember.getApprentice() != 0 && (apprentice = this.getClanMember(exMember.getApprentice())) != null) {
            if (apprentice.getPlayerInstance() != null) {
                apprentice.getPlayerInstance().setSponsor(0);
            } else {
                apprentice.initApprenticeAndSponsor(0, 0);
            }
            apprentice.saveApprenticeAndSponsor(0, 0);
        }
        if (exMember.getSponsor() != 0 && (sponsor = this.getClanMember(exMember.getSponsor())) != null) {
            if (sponsor.getPlayerInstance() != null) {
                sponsor.getPlayerInstance().setApprentice(0);
            } else {
                sponsor.initApprenticeAndSponsor(0, 0);
            }
            sponsor.saveApprenticeAndSponsor(0, 0);
        }
        exMember.saveApprenticeAndSponsor(0, 0);
        if (Config.REMOVE_CASTLE_CIRCLETS) {
            CastleManager.getInstance().removeCirclet(exMember, this.getHasCastle());
        }
        if (exMember.isOnline()) {
            L2PcInstance player = exMember.getPlayerInstance();
            player.setTitle("");
            player.setApprentice(0);
            player.setSponsor(0);
            if (player.isClanLeader()) {
                SiegeManager.getInstance().removeSiegeSkills(player);
                player.setClanCreateExpiryTime(System.currentTimeMillis() + (long)Config.ALT_CLAN_CREATE_DAYS * 86400000L);
            }
            this.removeSkillEffects(player);
            if (player.getClan().getHasCastle() > 0) {
                CastleManager.getInstance().getCastleByOwner(player.getClan()).removeResidentialSkills(player);
            }
            if (player.getClan().getHasFort() > 0) {
                FortManager.getInstance().getFortByOwner(player.getClan()).removeResidentialSkills(player);
            }
            player.sendSkillList();
            player.setClan(null);
            if (exMember.getPledgeType() != -1) {
                player.setClanJoinExpiryTime(clanJoinExpiryTime);
            }
            player.setPledgeClass(exMember.calculatePledgeClass(player));
            player.broadcastUserInfo();
            player.sendPacket(new PledgeShowMemberListDeleteAll());
        } else {
            this.removeMemberInDatabase(exMember, clanJoinExpiryTime, this.getLeaderId() == objectId ? System.currentTimeMillis() + (long)Config.ALT_CLAN_CREATE_DAYS * 86400000L : 0L);
        }
        CommunityServerThread.getInstance().sendPacket(new WorldInfo(null, this, 3));
    }

    public L2ClanMember[] getMembers() {
        return this._members.values().toArray(new L2ClanMember[this._members.size()]);
    }

    public int getMembersCount() {
        return this._members.size();
    }

    public int getSubPledgeMembersCount(int subpl) {
        int result = 0;
        for (L2ClanMember temp : this._members.values()) {
            if (temp.getPledgeType() != subpl) continue;
            ++result;
        }
        return result;
    }

    public int getMaxNrOfMembers(int pledgetype) {
        int limit = 0;
        block0 : switch (pledgetype) {
            case 0: {
                switch (this.getLevel()) {
                    case 3: {
                        limit = 30;
                        break block0;
                    }
                    case 2: {
                        limit = 20;
                        break block0;
                    }
                    case 1: {
                        limit = 15;
                        break block0;
                    }
                    case 0: {
                        limit = 10;
                        break block0;
                    }
                }
                limit = 40;
                break;
            }
            case -1: {
                limit = 20;
                break;
            }
            case 100: 
            case 200: {
                switch (this.getLevel()) {
                    case 11: {
                        limit = 30;
                        break block0;
                    }
                }
                limit = 20;
                break;
            }
            case 1001: 
            case 1002: 
            case 2001: 
            case 2002: {
                switch (this.getLevel()) {
                    case 9: 
                    case 10: 
                    case 11: {
                        limit = 25;
                        break block0;
                    }
                }
                limit = 10;
                break;
            }
        }
        return limit;
    }

    public L2PcInstance[] getOnlineMembers(int exclude) {
        FastList list = FastList.newInstance();
        for (L2ClanMember temp : this._members.values()) {
            if (temp == null || !temp.isOnline() || temp.getObjectId() == exclude) continue;
            list.add((Object)temp.getPlayerInstance());
        }
        L2PcInstance[] result = (L2PcInstance[])list.toArray((Object[])new L2PcInstance[list.size()]);
        FastList.recycle((FastList)list);
        return result;
    }

    public int getOnlineMembersCount() {
        int count = 0;
        for (L2ClanMember temp : this._members.values()) {
            if (temp == null || !temp.isOnline()) continue;
            ++count;
        }
        return count;
    }

    public int getAllyId() {
        return this._allyId;
    }

    public String getAllyName() {
        return this._allyName;
    }

    public void setAllyCrestId(int allyCrestId) {
        this._allyCrestId = allyCrestId;
    }

    public int getAllyCrestId() {
        return this._allyCrestId;
    }

    public int getLevel() {
        return this._level;
    }

    public int getHasCastle() {
        return this._hasCastle;
    }

    public int getHasFort() {
        return this._hasFort;
    }

    public int getHasHideout() {
        return this._hasHideout;
    }

    public void setCrestId(int crestId) {
        this._crestId = crestId;
    }

    public int getCrestId() {
        return this._crestId;
    }

    public void setCrestLargeId(int crestLargeId) {
        this._crestLargeId = crestLargeId;
    }

    public int getCrestLargeId() {
        return this._crestLargeId;
    }

    public void setAllyId(int allyId) {
        this._allyId = allyId;
    }

    public void setAllyName(String allyName) {
        this._allyName = allyName;
    }

    public void setHasCastle(int hasCastle) {
        this._hasCastle = hasCastle;
    }

    public void setHasFort(int hasFort) {
        this._hasFort = hasFort;
    }

    public void setHasHideout(int hasHideout) {
        this._hasHideout = hasHideout;
    }

    public void setLevel(int level) {
        Forum forum;
        this._level = level;
        if (this._level >= 2 && this._forum == null && Config.COMMUNITY_TYPE > 0 && (forum = ForumsBBSManager.getInstance().getForumByName("ClanRoot")) != null) {
            this._forum = forum.getChildByName(this._name);
            if (this._forum == null) {
                this._forum = ForumsBBSManager.getInstance().createNewForum(this._name, ForumsBBSManager.getInstance().getForumByName("ClanRoot"), 2, 2, this.getClanId());
            }
        }
    }

    public boolean isMember(int id) {
        return id == 0 ? false : this._members.containsKey(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClanScoreInDB() {
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("UPDATE clan_data SET reputation_score=? WHERE clan_id=?");
            statement.setInt(1, this.getReputationScore());
            statement.setInt(2, this.getClanId());
            statement.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on updateClanScoreInDb(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClanInDB() {
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("UPDATE clan_data SET leader_id=?,ally_id=?,ally_name=?,reputation_score=?,ally_penalty_expiry_time=?,ally_penalty_type=?,char_penalty_expiry_time=?,dissolving_expiry_time=? WHERE clan_id=?");
            statement.setInt(1, this.getLeaderId());
            statement.setInt(2, this.getAllyId());
            statement.setString(3, this.getAllyName());
            statement.setInt(4, this.getReputationScore());
            statement.setLong(5, this.getAllyPenaltyExpiryTime());
            statement.setInt(6, this.getAllyPenaltyType());
            statement.setLong(7, this.getCharPenaltyExpiryTime());
            statement.setLong(8, this.getDissolvingExpiryTime());
            statement.setInt(9, this.getClanId());
            statement.execute();
            if (Config.DEBUG) {
                _log.fine("New clan leader saved in db: " + this.getClanId());
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error saving clan: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("INSERT INTO clan_data (clan_id,clan_name,clan_level,hasCastle,ally_id,ally_name,leader_id,crest_id,crest_large_id,ally_crest_id) values (?,?,?,?,?,?,?,?,?,?)");
            statement.setInt(1, this.getClanId());
            statement.setString(2, this.getName());
            statement.setInt(3, this.getLevel());
            statement.setInt(4, this.getHasCastle());
            statement.setInt(5, this.getAllyId());
            statement.setString(6, this.getAllyName());
            statement.setInt(7, this.getLeaderId());
            statement.setInt(8, this.getCrestId());
            statement.setInt(9, this.getCrestLargeId());
            statement.setInt(10, this.getAllyCrestId());
            statement.execute();
            statement.close();
            if (Config.DEBUG) {
                _log.fine("New clan saved in db: " + this.getClanId());
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error saving new clan: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMemberInDatabase(L2ClanMember member, long clanJoinExpiryTime, long clanCreateExpiryTime) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE characters SET clanid=0, title=?, clan_join_expiry_time=?, clan_create_expiry_time=?, clan_privs=0, wantspeace=0, subpledge=0, lvl_joined_academy=0, apprentice=0, sponsor=0 WHERE charId=?");
            statement.setString(1, "");
            statement.setLong(2, clanJoinExpiryTime);
            statement.setLong(3, clanCreateExpiryTime);
            statement.setInt(4, member.getObjectId());
            statement.execute();
            statement.close();
            if (Config.DEBUG) {
                _log.fine("clan member removed in db: " + this.getClanId());
            }
            statement = con.prepareStatement("UPDATE characters SET apprentice=0 WHERE apprentice=?");
            statement.setInt(1, member.getObjectId());
            statement.execute();
            statement.close();
            statement = con.prepareStatement("UPDATE characters SET sponsor=0 WHERE sponsor=?");
            statement.setInt(1, member.getObjectId());
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error removing clan member: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWarsInDB() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE clan_wars SET wantspeace1=? WHERE clan1=?");
            statement.setInt(1, 0);
            statement.setInt(2, 0);
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error updating clan wars data: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restore() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT clan_name,clan_level,hasCastle,ally_id,ally_name,leader_id,crest_id,crest_large_id,ally_crest_id,reputation_score,auction_bid_at,ally_penalty_expiry_time,ally_penalty_type,char_penalty_expiry_time,dissolving_expiry_time FROM clan_data where clan_id=?");
            statement.setInt(1, this.getClanId());
            ResultSet clanData = statement.executeQuery();
            if (clanData.next()) {
                this.setName(clanData.getString("clan_name"));
                this.setLevel(clanData.getInt("clan_level"));
                this.setHasCastle(clanData.getInt("hasCastle"));
                this.setAllyId(clanData.getInt("ally_id"));
                this.setAllyName(clanData.getString("ally_name"));
                this.setAllyPenaltyExpiryTime(clanData.getLong("ally_penalty_expiry_time"), clanData.getInt("ally_penalty_type"));
                if (this.getAllyPenaltyExpiryTime() < System.currentTimeMillis()) {
                    this.setAllyPenaltyExpiryTime(0L, 0);
                }
                this.setCharPenaltyExpiryTime(clanData.getLong("char_penalty_expiry_time"));
                if (this.getCharPenaltyExpiryTime() + (long)Config.ALT_CLAN_JOIN_DAYS * 86400000L < System.currentTimeMillis()) {
                    this.setCharPenaltyExpiryTime(0L);
                }
                this.setDissolvingExpiryTime(clanData.getLong("dissolving_expiry_time"));
                this.setCrestId(clanData.getInt("crest_id"));
                this.setCrestLargeId(clanData.getInt("crest_large_id"));
                this.setAllyCrestId(clanData.getInt("ally_crest_id"));
                this.setReputationScore(clanData.getInt("reputation_score"), false);
                this.setAuctionBiddedAt(clanData.getInt("auction_bid_at"), false);
                int leaderId = clanData.getInt("leader_id");
                PreparedStatement statement2 = con.prepareStatement("SELECT char_name,level,classid,charId,title,power_grade,subpledge,apprentice,sponsor,sex,race FROM characters WHERE clanid=?");
                statement2.setInt(1, this.getClanId());
                ResultSet clanMembers = statement2.executeQuery();
                while (clanMembers.next()) {
                    L2ClanMember member = new L2ClanMember(this, clanMembers.getString("char_name"), clanMembers.getInt("level"), clanMembers.getInt("classid"), clanMembers.getInt("charId"), clanMembers.getInt("subpledge"), clanMembers.getInt("power_grade"), clanMembers.getString("title"), clanMembers.getInt("sex") != 0, clanMembers.getInt("race"));
                    if (member.getObjectId() == leaderId) {
                        this.setLeader(member);
                    } else {
                        this.addClanMember(member);
                    }
                    member.initApprenticeAndSponsor(clanMembers.getInt("apprentice"), clanMembers.getInt("sponsor"));
                }
                clanMembers.close();
                statement2.close();
            }
            clanData.close();
            statement.close();
            if (Config.DEBUG && this.getName() != null) {
                _log.info("Restored clan data for \"" + this.getName() + "\" from database.");
            }
            this.restoreSubPledges();
            this.restoreRankPrivs();
            this.restoreSkills();
            this.restoreNotice();
            this.checkCrests();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error restoring clan data: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreNotice() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT enabled,notice FROM clan_notices WHERE clan_id=?");
            statement.setInt(1, this.getClanId());
            ResultSet noticeData = statement.executeQuery();
            while (noticeData.next()) {
                this._noticeEnabled = noticeData.getBoolean("enabled");
                this._notice = noticeData.getString("notice");
            }
            noticeData.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error restoring clan notice: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeNotice(String notice, boolean enabled) {
        if (notice == null) {
            notice = "";
        }
        if (notice.length() > 8192) {
            notice = notice.substring(0, 8191);
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("INSERT INTO clan_notices (clan_id,notice,enabled) values (?,?,?) ON DUPLICATE KEY UPDATE notice=?,enabled=?");
            statement.setInt(1, this.getClanId());
            statement.setString(2, notice);
            if (enabled) {
                statement.setString(3, "true");
            } else {
                statement.setString(3, "false");
            }
            statement.setString(4, notice);
            if (enabled) {
                statement.setString(5, "true");
            } else {
                statement.setString(5, "false");
            }
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error could not store clan notice: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        this._notice = notice;
        this._noticeEnabled = enabled;
    }

    public void setNoticeEnabled(boolean enabled) {
        this.storeNotice(this._notice, enabled);
    }

    public void setNotice(String notice) {
        this.storeNotice(notice, this._noticeEnabled);
    }

    public boolean isNoticeEnabled() {
        return this._noticeEnabled;
    }

    public String getNotice() {
        if (this._notice == null) {
            return "";
        }
        return this._notice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreSkills() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT skill_id,skill_level,sub_pledge_id FROM clan_skills WHERE clan_id=?");
            statement.setInt(1, this.getClanId());
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                int id = rset.getInt("skill_id");
                int level = rset.getInt("skill_level");
                L2Skill skill = SkillTable.getInstance().getInfo(id, level);
                int subType = rset.getInt("sub_pledge_id");
                if (subType == -2) {
                    this._skills.put(skill.getId(), skill);
                    continue;
                }
                if (subType == 0) {
                    this._subPledgeSkills.put(skill.getId(), skill);
                    continue;
                }
                SubPledge subunit = this._subPledges.get(subType);
                if (subunit != null) {
                    subunit.addNewSkill(skill);
                    continue;
                }
                _log.info("Missing subpledge " + subType + " for clan " + this + ", skill skipped.");
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error restoring clan skills: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public final L2Skill[] getAllSkills() {
        if (this._skills == null) {
            return new L2Skill[0];
        }
        return this._skills.values().toArray(new L2Skill[this._skills.values().size()]);
    }

    public L2Skill addSkill(L2Skill newSkill) {
        L2Skill oldSkill = null;
        if (newSkill != null) {
            oldSkill = this._skills.put(newSkill.getId(), newSkill);
        }
        return oldSkill;
    }

    public L2Skill addNewSkill(L2Skill newSkill) {
        return this.addNewSkill(newSkill, -2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2Skill addNewSkill(L2Skill newSkill, int subType) {
        L2Skill oldSkill = null;
        Connection con = null;
        if (newSkill != null) {
            if (subType == -2) {
                oldSkill = this._skills.put(newSkill.getId(), newSkill);
            } else if (subType == 0) {
                oldSkill = this._subPledgeSkills.put(newSkill.getId(), newSkill);
            } else {
                SubPledge subunit = this.getSubPledge(subType);
                if (subunit != null) {
                    oldSkill = subunit.addNewSkill(newSkill);
                } else {
                    _log.log(Level.WARNING, "Subpledge " + subType + " does not exist for clan " + this);
                    return oldSkill;
                }
            }
            try {
                PreparedStatement statement;
                con = L2DatabaseFactory.getInstance().getConnection();
                if (oldSkill != null) {
                    statement = con.prepareStatement("UPDATE clan_skills SET skill_level=? WHERE skill_id=? AND clan_id=?");
                    statement.setInt(1, newSkill.getLevel());
                    statement.setInt(2, oldSkill.getId());
                    statement.setInt(3, this.getClanId());
                    statement.execute();
                    statement.close();
                } else {
                    statement = con.prepareStatement("INSERT INTO clan_skills (clan_id,skill_id,skill_level,skill_name,sub_pledge_id) VALUES (?,?,?,?,?)");
                    statement.setInt(1, this.getClanId());
                    statement.setInt(2, newSkill.getId());
                    statement.setInt(3, newSkill.getLevel());
                    statement.setString(4, newSkill.getName());
                    statement.setInt(5, subType);
                    statement.execute();
                    statement.close();
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Error could not store clan skills: " + e.getMessage(), e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.CLAN_SKILL_S1_ADDED);
            sm.addSkillName(newSkill.getId());
            for (L2ClanMember temp : this._members.values()) {
                if (temp == null || temp.getPlayerInstance() == null || !temp.isOnline()) continue;
                if (subType == -2) {
                    if (newSkill.getMinPledgeClass() > temp.getPlayerInstance().getPledgeClass()) continue;
                    temp.getPlayerInstance().addSkill(newSkill, false);
                    temp.getPlayerInstance().sendPacket(new PledgeSkillListAdd(newSkill.getId(), newSkill.getLevel()));
                    temp.getPlayerInstance().sendPacket(sm);
                    temp.getPlayerInstance().sendSkillList();
                    continue;
                }
                if (temp.getPledgeType() != subType) continue;
                temp.getPlayerInstance().addSkill(newSkill, false);
                temp.getPlayerInstance().sendPacket(new ExSubPledgeSkillAdd(subType, newSkill.getId(), newSkill.getLevel()));
                temp.getPlayerInstance().sendPacket(sm);
                temp.getPlayerInstance().sendSkillList();
            }
        }
        return oldSkill;
    }

    public void addSkillEffects() {
        for (L2Skill skill : this._skills.values()) {
            for (L2ClanMember temp : this._members.values()) {
                try {
                    if (temp == null || !temp.isOnline() || skill.getMinPledgeClass() > temp.getPlayerInstance().getPledgeClass()) continue;
                    temp.getPlayerInstance().addSkill(skill, false);
                }
                catch (NullPointerException e) {
                    _log.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
    }

    public void addSkillEffects(L2PcInstance player) {
        if (player == null || this._reputationScore < 0) {
            return;
        }
        for (L2Skill skill : this._skills.values()) {
            if (skill.getMinPledgeClass() > player.getPledgeClass()) continue;
            player.addSkill(skill, false);
        }
        if (player.getPledgeType() == 0) {
            for (L2Skill skill : this._subPledgeSkills.values()) {
                player.addSkill(skill, false);
            }
        } else {
            SubPledge subunit = this.getSubPledge(player.getPledgeType());
            if (subunit == null) {
                return;
            }
            for (L2Skill skill : subunit.getSkills()) {
                player.addSkill(skill, false);
            }
        }
    }

    public void removeSkillEffects(L2PcInstance player) {
        if (player == null) {
            return;
        }
        for (L2Skill skill : this._skills.values()) {
            player.removeSkill(skill, false);
        }
        if (player.getPledgeType() == 0) {
            for (L2Skill skill : this._subPledgeSkills.values()) {
                player.removeSkill(skill, false);
            }
        } else {
            SubPledge subunit = this.getSubPledge(player.getPledgeType());
            if (subunit == null) {
                return;
            }
            for (L2Skill skill : subunit.getSkills()) {
                player.removeSkill(skill, false);
            }
        }
    }

    public void broadcastToOnlineAllyMembers(L2GameServerPacket packet) {
        if (this.getAllyId() == 0) {
            return;
        }
        for (L2Clan clan : ClanTable.getInstance().getClans()) {
            if (clan.getAllyId() != this.getAllyId()) continue;
            clan.broadcastToOnlineMembers(packet);
        }
    }

    public void broadcastToOnlineMembers(L2GameServerPacket packet) {
        for (L2ClanMember member : this._members.values()) {
            if (member == null || !member.isOnline()) continue;
            member.getPlayerInstance().sendPacket(packet);
        }
    }

    public void broadcastCSToOnlineMembers(CreatureSay packet, L2PcInstance broadcaster) {
        for (L2ClanMember member : this._members.values()) {
            if (member == null || !member.isOnline() || BlockList.isBlocked(member.getPlayerInstance(), broadcaster)) continue;
            member.getPlayerInstance().sendPacket(packet);
        }
    }

    public void broadcastToOtherOnlineMembers(L2GameServerPacket packet, L2PcInstance player) {
        for (L2ClanMember member : this._members.values()) {
            if (member == null || !member.isOnline() || member.getPlayerInstance() == player) continue;
            member.getPlayerInstance().sendPacket(packet);
        }
    }

    public String toString() {
        return this.getName() + "[" + this.getClanId() + "]";
    }

    public ItemContainer getWarehouse() {
        return this._warehouse;
    }

    public boolean isAtWarWith(Integer id) {
        return !this._atWarWith.isEmpty() && this._atWarWith.contains(id);
    }

    public boolean isAtWarWith(L2Clan clan) {
        if (clan == null) {
            return false;
        }
        return !this._atWarWith.isEmpty() && this._atWarWith.contains(clan.getClanId());
    }

    public boolean isAtWarAttacker(Integer id) {
        return this._atWarAttackers != null && !this._atWarAttackers.isEmpty() && this._atWarAttackers.contains(id);
    }

    public void setEnemyClan(L2Clan clan) {
        Integer id = clan.getClanId();
        this._atWarWith.add(id);
    }

    public void setEnemyClan(Integer clan) {
        this._atWarWith.add(clan);
    }

    public void setAttackerClan(L2Clan clan) {
        Integer id = clan.getClanId();
        this._atWarAttackers.add(id);
    }

    public void setAttackerClan(Integer clan) {
        this._atWarAttackers.add(clan);
    }

    public void deleteEnemyClan(L2Clan clan) {
        Integer id = clan.getClanId();
        this._atWarWith.remove(id);
    }

    public void deleteAttackerClan(L2Clan clan) {
        Integer id = clan.getClanId();
        this._atWarAttackers.remove(id);
    }

    public int getHiredGuards() {
        return this._hiredGuards;
    }

    public void incrementHiredGuards() {
        ++this._hiredGuards;
    }

    public boolean isAtWar() {
        return this._atWarWith != null && !this._atWarWith.isEmpty();
    }

    public List<Integer> getWarList() {
        return this._atWarWith;
    }

    public List<Integer> getAttackerList() {
        return this._atWarAttackers;
    }

    public void broadcastClanStatus() {
        for (L2PcInstance member : this.getOnlineMembers(0)) {
            member.sendPacket(new PledgeShowMemberListDeleteAll());
            member.sendPacket(new PledgeShowMemberListAll(this, member));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreSubPledges() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT sub_pledge_id,name,leader_id FROM clan_subpledges WHERE clan_id=?");
            statement.setInt(1, this.getClanId());
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                int id = rset.getInt("sub_pledge_id");
                String name = rset.getString("name");
                int leaderId = rset.getInt("leader_id");
                SubPledge pledge = new SubPledge(id, name, leaderId);
                this._subPledges.put(id, pledge);
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not restore clan sub-units: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public final SubPledge getSubPledge(int pledgeType) {
        if (this._subPledges == null) {
            return null;
        }
        return this._subPledges.get(pledgeType);
    }

    public final SubPledge getSubPledge(String pledgeName) {
        if (this._subPledges == null) {
            return null;
        }
        for (SubPledge sp : this._subPledges.values()) {
            if (!sp.getName().equalsIgnoreCase(pledgeName)) continue;
            return sp;
        }
        return null;
    }

    public final SubPledge[] getAllSubPledges() {
        if (this._subPledges == null) {
            return new SubPledge[0];
        }
        return this._subPledges.values().toArray(new SubPledge[this._subPledges.values().size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubPledge createSubPledge(L2PcInstance player, int pledgeType, int leaderId, String subPledgeName) {
        SubPledge subPledge = null;
        if ((pledgeType = this.getAvailablePledgeTypes(pledgeType)) == 0) {
            if (pledgeType == -1) {
                player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CLAN_HAS_ALREADY_ESTABLISHED_A_CLAN_ACADEMY));
            } else {
                player.sendMessage("You can't create any more sub-units of this type");
            }
            return null;
        }
        if (this._leader.getObjectId() == leaderId) {
            player.sendMessage("Leader is not correct");
            return null;
        }
        if (pledgeType != -1 && (this.getReputationScore() < 5000 && pledgeType < 1001 || this.getReputationScore() < 10000 && pledgeType > 200)) {
            SystemMessage sp = SystemMessage.getSystemMessage(SystemMessageId.THE_CLAN_REPUTATION_SCORE_IS_TOO_LOW);
            player.sendPacket(sp);
            return null;
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("INSERT INTO clan_subpledges (clan_id,sub_pledge_id,name,leader_id) values (?,?,?,?)");
            statement.setInt(1, this.getClanId());
            statement.setInt(2, pledgeType);
            statement.setString(3, subPledgeName);
            if (pledgeType != -1) {
                statement.setInt(4, leaderId);
            } else {
                statement.setInt(4, 0);
            }
            statement.execute();
            statement.close();
            subPledge = new SubPledge(pledgeType, subPledgeName, leaderId);
            this._subPledges.put(pledgeType, subPledge);
            if (pledgeType != -1) {
                if (pledgeType < 1001) {
                    this.setReputationScore(this.getReputationScore() - Config.ROYAL_GUARD_COST, true);
                } else {
                    this.setReputationScore(this.getReputationScore() - Config.KNIGHT_UNIT_COST, true);
                }
            }
            if (Config.DEBUG) {
                _log.fine("New sub_clan saved in db: " + this.getClanId() + "; " + pledgeType);
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error saving sub clan data: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        this.broadcastToOnlineMembers(new PledgeShowInfoUpdate(this._leader.getClan()));
        this.broadcastToOnlineMembers(new PledgeReceiveSubPledgeCreated(subPledge, this._leader.getClan()));
        return subPledge;
    }

    public int getAvailablePledgeTypes(int pledgeType) {
        if (this._subPledges.get(pledgeType) != null) {
            switch (pledgeType) {
                case -1: {
                    return 0;
                }
                case 100: {
                    pledgeType = this.getAvailablePledgeTypes(200);
                    break;
                }
                case 200: {
                    return 0;
                }
                case 1001: {
                    pledgeType = this.getAvailablePledgeTypes(1002);
                    break;
                }
                case 1002: {
                    pledgeType = this.getAvailablePledgeTypes(2001);
                    break;
                }
                case 2001: {
                    pledgeType = this.getAvailablePledgeTypes(2002);
                    break;
                }
                case 2002: {
                    return 0;
                }
            }
        }
        return pledgeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSubPledgeInDB(int pledgeType) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE clan_subpledges SET leader_id=?, name=? WHERE clan_id=? AND sub_pledge_id=?");
            statement.setInt(1, this.getSubPledge(pledgeType).getLeaderId());
            statement.setString(2, this.getSubPledge(pledgeType).getName());
            statement.setInt(3, this.getClanId());
            statement.setInt(4, pledgeType);
            statement.execute();
            statement.close();
            if (Config.DEBUG) {
                _log.fine("Subpledge updated in db: " + this.getClanId());
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error updating subpledge: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreRankPrivs() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT privs,rank,party FROM clan_privs WHERE clan_id=?");
            statement.setInt(1, this.getClanId());
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                int rank = rset.getInt("rank");
                int privileges = rset.getInt("privs");
                if (rank == -1) continue;
                this._privs.get(rank).setPrivs(privileges);
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error restoring clan privs by rank: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public void initializePrivs() {
        for (int i = 1; i < 10; ++i) {
            RankPrivs privs = new RankPrivs(i, 0, 0);
            this._privs.put(i, privs);
        }
    }

    public int getRankPrivs(int rank) {
        if (this._privs.get(rank) != null) {
            return this._privs.get(rank).getPrivs();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRankPrivs(int rank, int privs) {
        if (this._privs.get(rank) != null) {
            this._privs.get(rank).setPrivs(privs);
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("INSERT INTO clan_privs (clan_id,rank,party,privs) VALUES (?,?,?,?) ON DUPLICATE KEY UPDATE privs = ?");
                statement.setInt(1, this.getClanId());
                statement.setInt(2, rank);
                statement.setInt(3, 0);
                statement.setInt(4, privs);
                statement.setInt(5, privs);
                statement.execute();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Could not store clan privs for rank: " + e.getMessage(), e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
            for (L2ClanMember cm : this.getMembers()) {
                if (!cm.isOnline() || cm.getPowerGrade() != rank || cm.getPlayerInstance() == null) continue;
                cm.getPlayerInstance().setClanPrivileges(privs);
                cm.getPlayerInstance().sendPacket(new UserInfo(cm.getPlayerInstance()));
                cm.getPlayerInstance().sendPacket(new ExBrExtraUserInfo(cm.getPlayerInstance()));
            }
            this.broadcastClanStatus();
        } else {
            this._privs.put(rank, new RankPrivs(rank, 0, privs));
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("INSERT INTO clan_privs (clan_id,rank,party,privs) VALUES (?,?,?,?)");
                statement.setInt(1, this.getClanId());
                statement.setInt(2, rank);
                statement.setInt(3, 0);
                statement.setInt(4, privs);
                statement.execute();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Could not create new rank and store clan privs for rank: " + e.getMessage(), e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
        }
    }

    public final RankPrivs[] getAllRankPrivs() {
        if (this._privs == null) {
            return new RankPrivs[0];
        }
        return this._privs.values().toArray(new RankPrivs[this._privs.values().size()]);
    }

    public int getLeaderSubPledge(int leaderId) {
        int id = 0;
        for (SubPledge sp : this._subPledges.values()) {
            if (sp.getLeaderId() == 0 || sp.getLeaderId() != leaderId) continue;
            id = sp.getId();
        }
        return id;
    }

    public synchronized void addReputationScore(int value, boolean save) {
        this.setReputationScore(this.getReputationScore() + value, save);
    }

    public synchronized void takeReputationScore(int value, boolean save) {
        this.setReputationScore(this.getReputationScore() - value, save);
    }

    private void setReputationScore(int value, boolean save) {
        if (this._reputationScore >= 0 && value < 0) {
            this.broadcastToOnlineMembers(SystemMessage.getSystemMessage(SystemMessageId.REPUTATION_POINTS_0_OR_LOWER_CLAN_SKILLS_DEACTIVATED));
            for (L2ClanMember member : this._members.values()) {
                if (!member.isOnline() || member.getPlayerInstance() == null) continue;
                this.removeSkillEffects(member.getPlayerInstance());
            }
        } else if (this._reputationScore < 0 && value >= 0) {
            this.broadcastToOnlineMembers(SystemMessage.getSystemMessage(SystemMessageId.CLAN_SKILLS_WILL_BE_ACTIVATED_SINCE_REPUTATION_IS_0_OR_HIGHER));
            for (L2ClanMember member : this._members.values()) {
                if (!member.isOnline() || member.getPlayerInstance() == null) continue;
                this.addSkillEffects(member.getPlayerInstance());
            }
        }
        this._reputationScore = value;
        if (this._reputationScore > 100000000) {
            this._reputationScore = 100000000;
        }
        if (this._reputationScore < -100000000) {
            this._reputationScore = -100000000;
        }
        this.broadcastToOnlineMembers(new PledgeShowInfoUpdate(this));
        if (save) {
            this.updateClanScoreInDB();
        }
    }

    public int getReputationScore() {
        return this._reputationScore;
    }

    public void setRank(int rank) {
        this._rank = rank;
    }

    public int getRank() {
        return this._rank;
    }

    public int getAuctionBiddedAt() {
        return this._auctionBiddedAt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuctionBiddedAt(int id, boolean storeInDb) {
        this._auctionBiddedAt = id;
        if (storeInDb) {
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("UPDATE clan_data SET auction_bid_at=? WHERE clan_id=?");
                statement.setInt(1, id);
                statement.setInt(2, this.getClanId());
                statement.execute();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Could not store auction for clan: " + e.getMessage(), e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
        }
    }

    public boolean checkClanJoinCondition(L2PcInstance activeChar, L2PcInstance target, int pledgeType) {
        if (activeChar == null) {
            return false;
        }
        if ((activeChar.getClanPrivileges() & 2) != 2) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT));
            return false;
        }
        if (target == null) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_INVITED_THE_WRONG_TARGET));
            return false;
        }
        if (activeChar.getObjectId() == target.getObjectId()) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_INVITE_YOURSELF));
            return false;
        }
        if (this.getCharPenaltyExpiryTime() > System.currentTimeMillis()) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_MUST_WAIT_BEFORE_ACCEPTING_A_NEW_MEMBER));
            return false;
        }
        if (target.getClanId() != 0) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_WORKING_WITH_ANOTHER_CLAN);
            sm.addString(target.getName());
            activeChar.sendPacket(sm);
            sm = null;
            return false;
        }
        if (target.getClanJoinExpiryTime() > System.currentTimeMillis()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_MUST_WAIT_BEFORE_JOINING_ANOTHER_CLAN);
            sm.addString(target.getName());
            activeChar.sendPacket(sm);
            sm = null;
            return false;
        }
        if ((target.getLevel() > 40 || target.getClassId().level() >= 2) && pledgeType == -1) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DOESNOT_MEET_REQUIREMENTS_TO_JOIN_ACADEMY);
            sm.addString(target.getName());
            activeChar.sendPacket(sm);
            sm = null;
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ACADEMY_REQUIREMENTS));
            return false;
        }
        if (this.getSubPledgeMembersCount(pledgeType) >= this.getMaxNrOfMembers(pledgeType)) {
            if (pledgeType == 0) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CLAN_IS_FULL);
                sm.addString(this.getName());
                activeChar.sendPacket(sm);
                sm = null;
            } else {
                activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.SUBCLAN_IS_FULL));
            }
            return false;
        }
        return true;
    }

    public boolean checkAllyJoinCondition(L2PcInstance activeChar, L2PcInstance target) {
        if (activeChar == null) {
            return false;
        }
        if (activeChar.getAllyId() == 0 || !activeChar.isClanLeader() || activeChar.getClanId() != activeChar.getAllyId()) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.FEATURE_ONLY_FOR_ALLIANCE_LEADER));
            return false;
        }
        L2Clan leaderClan = activeChar.getClan();
        if (leaderClan.getAllyPenaltyExpiryTime() > System.currentTimeMillis() && leaderClan.getAllyPenaltyType() == 3) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANT_INVITE_CLAN_WITHIN_1_DAY));
            return false;
        }
        if (target == null) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_INVITED_THE_WRONG_TARGET));
            return false;
        }
        if (activeChar.getObjectId() == target.getObjectId()) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_INVITE_YOURSELF));
            return false;
        }
        if (target.getClan() == null) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.TARGET_MUST_BE_IN_CLAN));
            return false;
        }
        if (!target.isClanLeader()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_IS_NOT_A_CLAN_LEADER);
            sm.addString(target.getName());
            activeChar.sendPacket(sm);
            sm = null;
            return false;
        }
        L2Clan targetClan = target.getClan();
        if (target.getAllyId() != 0) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CLAN_ALREADY_MEMBER_OF_S2_ALLIANCE);
            sm.addString(targetClan.getName());
            sm.addString(targetClan.getAllyName());
            activeChar.sendPacket(sm);
            sm = null;
            return false;
        }
        if (targetClan.getAllyPenaltyExpiryTime() > System.currentTimeMillis()) {
            if (targetClan.getAllyPenaltyType() == 1) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANT_ENTER_ALLIANCE_WITHIN_1_DAY);
                sm.addString(target.getClan().getName());
                sm.addString(target.getClan().getAllyName());
                activeChar.sendPacket(sm);
                sm = null;
                return false;
            }
            if (targetClan.getAllyPenaltyType() == 2) {
                activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANT_ENTER_ALLIANCE_WITHIN_1_DAY));
                return false;
            }
        }
        if (activeChar.isInsideZone((byte)2) && target.isInsideZone((byte)2)) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.OPPOSING_CLAN_IS_PARTICIPATING_IN_SIEGE));
            return false;
        }
        if (leaderClan.isAtWarWith(targetClan.getClanId())) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.MAY_NOT_ALLY_CLAN_BATTLE));
            return false;
        }
        int numOfClansInAlly = 0;
        for (L2Clan clan : ClanTable.getInstance().getClans()) {
            if (clan.getAllyId() != activeChar.getAllyId()) continue;
            ++numOfClansInAlly;
        }
        if (numOfClansInAlly >= Config.ALT_MAX_NUM_OF_CLANS_IN_ALLY) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_EXCEEDED_THE_LIMIT));
            return false;
        }
        return true;
    }

    public long getAllyPenaltyExpiryTime() {
        return this._allyPenaltyExpiryTime;
    }

    public int getAllyPenaltyType() {
        return this._allyPenaltyType;
    }

    public void setAllyPenaltyExpiryTime(long expiryTime, int penaltyType) {
        this._allyPenaltyExpiryTime = expiryTime;
        this._allyPenaltyType = penaltyType;
    }

    public long getCharPenaltyExpiryTime() {
        return this._charPenaltyExpiryTime;
    }

    public void setCharPenaltyExpiryTime(long time) {
        this._charPenaltyExpiryTime = time;
    }

    public long getDissolvingExpiryTime() {
        return this._dissolvingExpiryTime;
    }

    public void setDissolvingExpiryTime(long time) {
        this._dissolvingExpiryTime = time;
    }

    public void createAlly(L2PcInstance player, String allyName) {
        if (null == player) {
            return;
        }
        if (Config.DEBUG) {
            _log.fine(player.getObjectId() + "(" + player.getName() + ") requested ally creation from ");
        }
        if (!player.isClanLeader()) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ONLY_CLAN_LEADER_CREATE_ALLIANCE));
            return;
        }
        if (this.getAllyId() != 0) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ALREADY_JOINED_ALLIANCE));
            return;
        }
        if (this.getLevel() < 5) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.TO_CREATE_AN_ALLY_YOU_CLAN_MUST_BE_LEVEL_5_OR_HIGHER));
            return;
        }
        if (this.getAllyPenaltyExpiryTime() > System.currentTimeMillis() && this.getAllyPenaltyType() == 4) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANT_CREATE_ALLIANCE_10_DAYS_DISOLUTION));
            return;
        }
        if (this.getDissolvingExpiryTime() > System.currentTimeMillis()) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_MAY_NOT_CREATE_ALLY_WHILE_DISSOLVING));
            return;
        }
        if (!Util.isAlphaNumeric(allyName)) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.INCORRECT_ALLIANCE_NAME));
            return;
        }
        if (allyName.length() > 16 || allyName.length() < 2) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.INCORRECT_ALLIANCE_NAME_LENGTH));
            return;
        }
        if (ClanTable.getInstance().isAllyExists(allyName)) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ALLIANCE_ALREADY_EXISTS));
            return;
        }
        this.setAllyId(this.getClanId());
        this.setAllyName(allyName.trim());
        this.setAllyPenaltyExpiryTime(0L, 0);
        this.updateClanInDB();
        player.sendPacket(new UserInfo(player));
        player.sendPacket(new ExBrExtraUserInfo(player));
        player.sendMessage("Alliance " + allyName + " has been created.");
        CommunityServerThread.getInstance().sendPacket(new WorldInfo(null, this, 3));
    }

    public void dissolveAlly(L2PcInstance player) {
        if (this.getAllyId() == 0) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.NO_CURRENT_ALLIANCES));
            return;
        }
        if (!player.isClanLeader() || this.getClanId() != this.getAllyId()) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.FEATURE_ONLY_FOR_ALLIANCE_LEADER));
            return;
        }
        if (player.isInsideZone((byte)2)) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_DISSOLVE_ALLY_WHILE_IN_SIEGE));
            return;
        }
        this.broadcastToOnlineAllyMembers(SystemMessage.getSystemMessage(SystemMessageId.ALLIANCE_DISOLVED));
        long currentTime = System.currentTimeMillis();
        for (L2Clan clan : ClanTable.getInstance().getClans()) {
            if (clan.getAllyId() != this.getAllyId() || clan.getClanId() == this.getClanId()) continue;
            clan.setAllyId(0);
            clan.setAllyName(null);
            clan.setAllyPenaltyExpiryTime(0L, 0);
            clan.updateClanInDB();
            CommunityServerThread.getInstance().sendPacket(new WorldInfo(null, clan, 3));
        }
        this.setAllyId(0);
        this.setAllyName(null);
        this.changeAllyCrest(0, false);
        this.setAllyPenaltyExpiryTime(currentTime + (long)Config.ALT_CREATE_ALLY_DAYS_WHEN_DISSOLVED * 86400000L, 4);
        this.updateClanInDB();
        player.deathPenalty(false, false, false);
        CommunityServerThread.getInstance().sendPacket(new WorldInfo(null, this, 3));
    }

    public boolean levelUpClan(L2PcInstance player) {
        if (!player.isClanLeader()) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT));
            return false;
        }
        if (System.currentTimeMillis() < this.getDissolvingExpiryTime()) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_RISE_LEVEL_WHILE_DISSOLUTION_IN_PROGRESS));
            return false;
        }
        boolean increaseClanLevel = false;
        switch (this.getLevel()) {
            case 0: {
                if (player.getSp() < 20000 || player.getAdena() < 650000L || !player.reduceAdena("ClanLvl", 650000L, player.getTarget(), true)) break;
                player.setSp(player.getSp() - 20000);
                SystemMessage sp = SystemMessage.getSystemMessage(SystemMessageId.SP_DECREASED_S1);
                sp.addNumber(20000);
                player.sendPacket(sp);
                sp = null;
                increaseClanLevel = true;
                break;
            }
            case 1: {
                if (player.getSp() < 100000 || player.getAdena() < 2500000L || !player.reduceAdena("ClanLvl", 2500000L, player.getTarget(), true)) break;
                player.setSp(player.getSp() - 100000);
                SystemMessage sp = SystemMessage.getSystemMessage(SystemMessageId.SP_DECREASED_S1);
                sp.addNumber(100000);
                player.sendPacket(sp);
                sp = null;
                increaseClanLevel = true;
                break;
            }
            case 2: {
                if (player.getSp() < 350000 || player.getInventory().getItemByItemId(1419) == null || !player.destroyItemByItemId("ClanLvl", 1419, 1L, player.getTarget(), false)) break;
                player.setSp(player.getSp() - 350000);
                SystemMessage sp = SystemMessage.getSystemMessage(SystemMessageId.SP_DECREASED_S1);
                sp.addNumber(350000);
                player.sendPacket(sp);
                sp = null;
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
                sm.addItemName(1419);
                player.sendPacket(sm);
                sm = null;
                increaseClanLevel = true;
                break;
            }
            case 3: {
                if (player.getSp() < 1000000 || player.getInventory().getItemByItemId(3874) == null || !player.destroyItemByItemId("ClanLvl", 3874, 1L, player.getTarget(), false)) break;
                player.setSp(player.getSp() - 1000000);
                SystemMessage sp = SystemMessage.getSystemMessage(SystemMessageId.SP_DECREASED_S1);
                sp.addNumber(1000000);
                player.sendPacket(sp);
                sp = null;
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
                sm.addItemName(3874);
                player.sendPacket(sm);
                sm = null;
                increaseClanLevel = true;
                break;
            }
            case 4: {
                if (player.getSp() < 2500000 || player.getInventory().getItemByItemId(3870) == null || !player.destroyItemByItemId("ClanLvl", 3870, 1L, player.getTarget(), false)) break;
                player.setSp(player.getSp() - 2500000);
                SystemMessage sp = SystemMessage.getSystemMessage(SystemMessageId.SP_DECREASED_S1);
                sp.addNumber(2500000);
                player.sendPacket(sp);
                sp = null;
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
                sm.addItemName(3870);
                player.sendPacket(sm);
                sm = null;
                increaseClanLevel = true;
                break;
            }
            case 5: {
                if (this.getReputationScore() < Config.CLAN_LEVEL_6_COST || this.getMembersCount() < Config.CLAN_LEVEL_6_REQUIREMENT) break;
                this.setReputationScore(this.getReputationScore() - Config.CLAN_LEVEL_6_COST, true);
                SystemMessage cr = SystemMessage.getSystemMessage(SystemMessageId.S1_DEDUCTED_FROM_CLAN_REP);
                cr.addNumber(Config.CLAN_LEVEL_6_COST);
                player.sendPacket(cr);
                cr = null;
                increaseClanLevel = true;
                break;
            }
            case 6: {
                if (this.getReputationScore() < Config.CLAN_LEVEL_7_COST || this.getMembersCount() < Config.CLAN_LEVEL_7_REQUIREMENT) break;
                this.setReputationScore(this.getReputationScore() - Config.CLAN_LEVEL_7_COST, true);
                SystemMessage cr = SystemMessage.getSystemMessage(SystemMessageId.S1_DEDUCTED_FROM_CLAN_REP);
                cr.addNumber(Config.CLAN_LEVEL_7_COST);
                player.sendPacket(cr);
                cr = null;
                increaseClanLevel = true;
                break;
            }
            case 7: {
                if (this.getReputationScore() < Config.CLAN_LEVEL_8_COST || this.getMembersCount() < Config.CLAN_LEVEL_8_REQUIREMENT) break;
                this.setReputationScore(this.getReputationScore() - Config.CLAN_LEVEL_8_COST, true);
                SystemMessage cr = SystemMessage.getSystemMessage(SystemMessageId.S1_DEDUCTED_FROM_CLAN_REP);
                cr.addNumber(Config.CLAN_LEVEL_8_COST);
                player.sendPacket(cr);
                cr = null;
                increaseClanLevel = true;
                break;
            }
            case 8: {
                if (this.getReputationScore() < Config.CLAN_LEVEL_9_COST || player.getInventory().getItemByItemId(9910) == null || this.getMembersCount() < Config.CLAN_LEVEL_9_REQUIREMENT || !player.destroyItemByItemId("ClanLvl", 9910, 150L, player.getTarget(), false)) break;
                this.setReputationScore(this.getReputationScore() - Config.CLAN_LEVEL_9_COST, true);
                SystemMessage cr = SystemMessage.getSystemMessage(SystemMessageId.S1_DEDUCTED_FROM_CLAN_REP);
                cr.addNumber(Config.CLAN_LEVEL_9_COST);
                player.sendPacket(cr);
                cr = null;
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                sm.addItemName(9910);
                sm.addItemNumber(150L);
                player.sendPacket(sm);
                increaseClanLevel = true;
                break;
            }
            case 9: {
                if (this.getReputationScore() < Config.CLAN_LEVEL_10_COST || player.getInventory().getItemByItemId(9911) == null || this.getMembersCount() < Config.CLAN_LEVEL_10_REQUIREMENT || !player.destroyItemByItemId("ClanLvl", 9911, 5L, player.getTarget(), false)) break;
                this.setReputationScore(this.getReputationScore() - Config.CLAN_LEVEL_10_COST, true);
                SystemMessage cr = SystemMessage.getSystemMessage(SystemMessageId.S1_DEDUCTED_FROM_CLAN_REP);
                cr.addNumber(Config.CLAN_LEVEL_10_COST);
                player.sendPacket(cr);
                cr = null;
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                sm.addItemName(9911);
                sm.addItemNumber(5L);
                player.sendPacket(sm);
                increaseClanLevel = true;
                break;
            }
            case 10: {
                boolean hasTerritory = false;
                for (TerritoryWarManager.Territory terr : TerritoryWarManager.getInstance().getAllTerritories()) {
                    if (terr.getOwnerClan().getClanId() != this.getClanId()) continue;
                    hasTerritory = true;
                    break;
                }
                if (!hasTerritory || this.getReputationScore() < Config.CLAN_LEVEL_11_COST || this.getMembersCount() < Config.CLAN_LEVEL_11_REQUIREMENT) break;
                this.setReputationScore(this.getReputationScore() - Config.CLAN_LEVEL_11_COST, true);
                SystemMessage cr = SystemMessage.getSystemMessage(SystemMessageId.S1_DEDUCTED_FROM_CLAN_REP);
                cr.addNumber(Config.CLAN_LEVEL_11_COST);
                player.sendPacket(cr);
                cr = null;
                increaseClanLevel = true;
                break;
            }
            default: {
                return false;
            }
        }
        if (!increaseClanLevel) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_INCREASE_CLAN_LEVEL);
            player.sendPacket(sm);
            return false;
        }
        StatusUpdate su = new StatusUpdate(player);
        su.addAttribute(13, player.getSp());
        player.sendPacket(su);
        ItemList il = new ItemList(player, false);
        player.sendPacket(il);
        this.changeLevel(this.getLevel() + 1);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeLevel(int level) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE clan_data SET clan_level = ? WHERE clan_id = ?");
            statement.setInt(1, level);
            statement.setInt(2, this.getClanId());
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not increase clan level:" + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        this.setLevel(level);
        if (this.getLeader().isOnline()) {
            L2PcInstance leader = this.getLeader().getPlayerInstance();
            if (4 < level) {
                SiegeManager.getInstance().addSiegeSkills(leader);
                leader.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CLAN_CAN_ACCUMULATE_CLAN_REPUTATION_POINTS));
            } else if (5 > level) {
                SiegeManager.getInstance().removeSiegeSkills(leader);
            }
        }
        this.broadcastToOnlineMembers(SystemMessage.getSystemMessage(SystemMessageId.CLAN_LEVEL_INCREASED));
        this.broadcastToOnlineMembers(new PledgeShowInfoUpdate(this));
        CommunityServerThread.getInstance().sendPacket(new WorldInfo(null, this, 3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeClanCrest(int crestId) {
        if (this.getCrestId() != 0) {
            CrestCache.getInstance().removePledgeCrest(this.getCrestId());
        }
        this.setCrestId(crestId);
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE clan_data SET crest_id = ? WHERE clan_id = ?");
            statement.setInt(1, crestId);
            statement.setInt(2, this.getClanId());
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "Could not update crest for clan " + this.getName() + " [" + this.getClanId() + "] : " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        for (L2PcInstance member : this.getOnlineMembers(0)) {
            member.broadcastUserInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeAllyCrest(int crestId, boolean onlyThisClan) {
        String sqlStatement = "UPDATE clan_data SET ally_crest_id = ? WHERE clan_id = ?";
        int allyId = this.getClanId();
        if (!onlyThisClan) {
            if (this.getAllyCrestId() != 0) {
                CrestCache.getInstance().removeAllyCrest(this.getAllyCrestId());
            }
            sqlStatement = "UPDATE clan_data SET ally_crest_id = ? WHERE ally_id = ?";
            allyId = this.getAllyId();
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(sqlStatement);
            statement.setInt(1, crestId);
            statement.setInt(2, allyId);
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "Could not update ally crest for ally/clan id " + allyId + " : " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        if (onlyThisClan) {
            this.setAllyCrestId(crestId);
            for (L2PcInstance member : this.getOnlineMembers(0)) {
                member.broadcastUserInfo();
            }
        } else {
            for (L2Clan clan : ClanTable.getInstance().getClans()) {
                if (clan.getAllyId() != this.getAllyId()) continue;
                clan.setAllyCrestId(crestId);
                for (L2PcInstance member : clan.getOnlineMembers(0)) {
                    member.broadcastUserInfo();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeLargeCrest(int crestId) {
        if (this.getCrestLargeId() != 0) {
            CrestCache.getInstance().removePledgeCrestLarge(this.getCrestLargeId());
        }
        this.setCrestLargeId(crestId);
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE clan_data SET crest_large_id = ? WHERE clan_id = ?");
            statement.setInt(1, crestId);
            statement.setInt(2, this.getClanId());
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "Could not update large crest for clan " + this.getName() + " [" + this.getClanId() + "] : " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        for (L2PcInstance member : this.getOnlineMembers(0)) {
            member.broadcastUserInfo();
        }
    }

    public boolean isLearnableSubSkill(int skillId, int skillLevel) {
        L2Skill current = this._subPledgeSkills.get(skillId);
        if (current != null && current.getLevel() + 1 == skillLevel) {
            return true;
        }
        if (current == null && skillLevel == 1) {
            return true;
        }
        for (SubPledge subunit : this._subPledges.values()) {
            if (subunit._id == -1) continue;
            current = (L2Skill)subunit._subPledgeSkills.get(skillId);
            if (current != null && current.getLevel() + 1 == skillLevel) {
                return true;
            }
            if (current != null || skillLevel != 1) continue;
            return true;
        }
        return false;
    }

    public boolean isLearnableSubPledgeSkill(L2Skill skill, int subType) {
        if (subType == -1) {
            return false;
        }
        int id = skill.getId();
        L2Skill current = subType == 0 ? this._subPledgeSkills.get(id) : (L2Skill)this._subPledges.get(subType)._subPledgeSkills.get(id);
        if (current != null && current.getLevel() + 1 == skill.getLevel()) {
            return true;
        }
        return current == null && skill.getLevel() == 1;
    }

    public PledgeSkillList.SubPledgeSkill[] getAllSubSkills() {
        FastList list = FastList.newInstance();
        for (L2Skill skill : this._subPledgeSkills.values()) {
            list.add((Object)new PledgeSkillList.SubPledgeSkill(0, skill.getId(), skill.getLevel()));
        }
        for (SubPledge subunit : this._subPledges.values()) {
            for (L2Skill skill : subunit.getSkills()) {
                list.add((Object)new PledgeSkillList.SubPledgeSkill(subunit._id, skill.getId(), skill.getLevel()));
            }
        }
        PledgeSkillList.SubPledgeSkill[] result = (PledgeSkillList.SubPledgeSkill[])list.toArray((Object[])new PledgeSkillList.SubPledgeSkill[list.size()]);
        FastList.recycle((FastList)list);
        return result;
    }

    private void checkCrests() {
        if (this.getCrestId() != 0 && CrestCache.getInstance().getPledgeCrest(this.getCrestId()) == null) {
            _log.log(Level.INFO, "Removing non-existent crest for clan " + this.getName() + " [" + this.getClanId() + "], crestId:" + this.getCrestId());
            this.setCrestId(0);
            this.changeClanCrest(0);
        }
        if (this.getCrestLargeId() != 0 && CrestCache.getInstance().getPledgeCrestLarge(this.getCrestLargeId()) == null) {
            _log.log(Level.INFO, "Removing non-existent large crest for clan " + this.getName() + " [" + this.getClanId() + "], crestLargeId:" + this.getCrestLargeId());
            this.setCrestLargeId(0);
            this.changeLargeCrest(0);
        }
        if (this.getAllyCrestId() != 0 && CrestCache.getInstance().getAllyCrest(this.getAllyCrestId()) == null) {
            _log.log(Level.INFO, "Removing non-existent ally crest for clan " + this.getName() + " [" + this.getClanId() + "], allyCrestId:" + this.getAllyCrestId());
            this.setAllyCrestId(0);
            this.changeAllyCrest(0, true);
        }
    }

    public static class RankPrivs {
        private int _rankId;
        private int _party;
        private int _rankPrivs;

        public RankPrivs(int rank, int party, int privs) {
            this._rankId = rank;
            this._party = party;
            this._rankPrivs = privs;
        }

        public int getRank() {
            return this._rankId;
        }

        public int getParty() {
            return this._party;
        }

        public int getPrivs() {
            return this._rankPrivs;
        }

        public void setPrivs(int privs) {
            this._rankPrivs = privs;
        }
    }

    public static class SubPledge {
        private int _id;
        private String _subPledgeName;
        private int _leaderId;
        private final Map<Integer, L2Skill> _subPledgeSkills = new FastMap();

        public SubPledge(int id, String name, int leaderId) {
            this._id = id;
            this._subPledgeName = name;
            this._leaderId = leaderId;
        }

        public int getId() {
            return this._id;
        }

        public String getName() {
            return this._subPledgeName;
        }

        public void setName(String name) {
            this._subPledgeName = name;
        }

        public int getLeaderId() {
            return this._leaderId;
        }

        public void setLeaderId(int leaderId) {
            this._leaderId = leaderId;
        }

        public L2Skill addNewSkill(L2Skill skill) {
            return this._subPledgeSkills.put(skill.getId(), skill);
        }

        public Collection<L2Skill> getSkills() {
            return this._subPledgeSkills.values();
        }
    }
}

