/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SkillTreesData;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TrainerInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AcquireSkillList;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.util.Collection;
import javolution.util.FastList;

public final class L2TrainerHealersInstance
extends L2TrainerInstance {
    public L2TrainerHealersInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2TrainerHealersInstance);
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        return this.getHtmlPath("data/html/trainer/skilltransfer/", npcId, val);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        if (command.equals("SkillTransfer_Learn")) {
            if (!this.getTemplate().canTeach(player.getClassId())) {
                this.showNoTeachHtml(player);
                return;
            }
            if (player.getLevel() < 76 || player.getClassId().level() < 3) {
                html.setFile(player.getHtmlPrefix(), "data/html/trainer/skilltransfer/learn-lowlevel.htm");
                player.sendPacket(html);
                return;
            }
            L2TrainerHealersInstance.showTransferSkillList(player);
        } else if (command.equals("SkillTransfer_Cleanse")) {
            if (!this.getTemplate().canTeach(player.getClassId())) {
                this.showNoTeachHtml(player);
                return;
            }
            if (player.getLevel() < 76 || player.getClassId().level() < 3) {
                html.setFile(player.getHtmlPrefix(), "data/html/trainer/skilltransfer/cleanse-no.htm");
                player.sendPacket(html);
                return;
            }
            if (player.getAdena() < (long)Config.FEE_DELETE_TRANSFER_SKILLS) {
                player.sendPacket(SystemMessageId.CANNOT_RESET_SKILL_LINK_BECAUSE_NOT_ENOUGH_ADENA);
                return;
            }
            boolean hasSkills = false;
            if (!this.hasTransferSkillItems(player)) {
                Collection skills = SkillTreesData.getInstance().getTransferSkillTree(player.getClassId()).values();
                for (L2SkillLearn s : skills) {
                    L2Skill sk = player.getKnownSkill(s.getSkillId());
                    if (sk == null) continue;
                    player.removeSkill(sk);
                    if (s.getItemsIdCount() != null) {
                        player.addItem("Cleanse", s.getItemsIdCount()[0][0], s.getItemsIdCount()[0][1], this, true);
                    } else {
                        _log.warning(this.getClass().getSimpleName() + ": Transfer skill Id: " + s.getSkillId() + " doesn't have required items defined!");
                    }
                    hasSkills = true;
                }
                if (hasSkills) {
                    player.reduceAdena("Cleanse", Config.FEE_DELETE_TRANSFER_SKILLS, this, true);
                }
            } else {
                html.setFile(player.getHtmlPrefix(), "data/html/trainer/skilltransfer/cleanse-no_skills.htm");
                player.sendPacket(html);
            }
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    public static void showTransferSkillList(L2PcInstance player) {
        FastList<L2SkillLearn> skills = SkillTreesData.getInstance().getAvailableTransferSkills(player);
        AcquireSkillList asl = new AcquireSkillList(AcquireSkillList.SkillType.Transfer);
        int count = 0;
        for (L2SkillLearn s : skills) {
            if (SkillTable.getInstance().getInfo(s.getSkillId(), s.getSkillLevel()) == null) continue;
            ++count;
            asl.addSkill(s.getSkillId(), s.getSkillLevel(), s.getSkillLevel(), s.getLevelUpSp(), 0);
        }
        if (count > 0) {
            player.sendPacket(asl);
        } else {
            player.sendPacket(SystemMessageId.NO_MORE_SKILLS_TO_LEARN);
        }
    }

    private boolean hasTransferSkillItems(L2PcInstance player) {
        int itemId;
        switch (player.getClassId()) {
            case cardinal: {
                itemId = 15307;
                break;
            }
            case evaSaint: {
                itemId = 15308;
                break;
            }
            case shillienSaint: {
                itemId = 15309;
                break;
            }
            default: {
                itemId = -1;
            }
        }
        return player.getInventory().getInventoryItemCount(itemId, -1) > 0L;
    }
}

