/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SiegeSummonInstance;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.FortSiege;
import com.l2jserver.gameserver.model.entity.Siegable;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import javolution.util.FastList;

public class L2SiegeZone
extends L2ZoneType {
    private int _siegableId = -1;
    private Siegable _siege = null;
    private boolean _isActiveSiege = false;
    private static final int DISMOUNT_DELAY = 5;

    public L2SiegeZone(int id) {
        super(id);
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equals("castleId")) {
            if (this._siegableId != -1) {
                throw new IllegalArgumentException("Siege object already defined!");
            }
            this._siegableId = Integer.parseInt(value);
        } else if (name.equals("fortId")) {
            if (this._siegableId != -1) {
                throw new IllegalArgumentException("Siege object already defined!");
            }
            this._siegableId = Integer.parseInt(value);
        } else if (name.equals("clanHallId")) {
            if (this._siegableId != -1) {
                throw new IllegalArgumentException("Siege object already defined!");
            }
            this._siegableId = Integer.parseInt(value);
        } else {
            super.setParameter(name, value);
        }
    }

    @Override
    protected void onEnter(L2Character character) {
        if (this._isActiveSiege) {
            character.setInsideZone((byte)0, true);
            character.setInsideZone((byte)2, true);
            character.setInsideZone((byte)12, true);
            if (character instanceof L2PcInstance) {
                if (((L2PcInstance)character).isRegisteredOnThisSiegeField(this._siegableId)) {
                    ((L2PcInstance)character).setIsInSiege(true);
                    if (this._siege.giveFame()) {
                        ((L2PcInstance)character).startFameTask(this._siege.getFameFrequency() * 1000, this._siege.getFameAmount());
                    }
                }
                ((L2PcInstance)character).sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ENTERED_COMBAT_ZONE));
                if (!Config.ALLOW_WYVERN_DURING_SIEGE && ((L2PcInstance)character).getMountType() == 2) {
                    character.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.AREA_CANNOT_BE_ENTERED_WHILE_MOUNTED_WYVERN));
                    ((L2PcInstance)character).enteredNoLanding(5);
                }
            }
        }
    }

    @Override
    protected void onExit(L2Character character) {
        character.setInsideZone((byte)0, false);
        character.setInsideZone((byte)2, false);
        character.setInsideZone((byte)12, false);
        if (this._isActiveSiege && character instanceof L2PcInstance) {
            ((L2PcInstance)character).sendPacket(SystemMessage.getSystemMessage(SystemMessageId.LEFT_COMBAT_ZONE));
            if (((L2PcInstance)character).getMountType() == 2) {
                ((L2PcInstance)character).exitedNoLanding();
            }
            if (((L2PcInstance)character).getPvpFlag() == 0) {
                ((L2PcInstance)character).startPvPFlag();
            }
        }
        if (character instanceof L2PcInstance) {
            L2PcInstance activeChar = (L2PcInstance)character;
            activeChar.stopFameTask();
            activeChar.setIsInSiege(false);
            if (this._siege instanceof FortSiege && activeChar.getInventory().getItemByItemId(9819) != null) {
                Fort fort = FortManager.getInstance().getFortById(this._siegableId);
                if (fort != null) {
                    FortSiegeManager.getInstance().dropCombatFlag(activeChar, fort.getFortId());
                } else {
                    int slot = activeChar.getInventory().getSlotFromItem(activeChar.getInventory().getItemByItemId(9819));
                    activeChar.getInventory().unEquipItemInBodySlot(slot);
                    activeChar.destroyItem("CombatFlag", activeChar.getInventory().getItemByItemId(9819), null, true);
                }
            }
        }
        if (character instanceof L2SiegeSummonInstance) {
            ((L2SiegeSummonInstance)character).unSummon(((L2SiegeSummonInstance)character).getOwner());
        }
    }

    @Override
    public void onDieInside(L2Character character) {
        if (this._isActiveSiege && character instanceof L2PcInstance && ((L2PcInstance)character).isRegisteredOnThisSiegeField(this._siegableId)) {
            L2Skill skill;
            int lvl = 1;
            L2Effect e = character.getFirstEffect(5660);
            if (e != null) {
                lvl = Math.min(lvl + e.getLevel(), 5);
            }
            if ((skill = SkillTable.getInstance().getInfo(5660, lvl)) != null) {
                skill.getEffects(character, character);
            }
        }
    }

    @Override
    public void onReviveInside(L2Character character) {
    }

    public void updateZoneStatusForCharactersInside() {
        if (this._isActiveSiege) {
            for (L2Character character : this._characterList.values()) {
                if (character == null) continue;
                this.onEnter(character);
            }
        } else {
            for (L2Character character : this._characterList.values()) {
                if (character == null) continue;
                character.setInsideZone((byte)0, false);
                character.setInsideZone((byte)2, false);
                character.setInsideZone((byte)12, false);
                if (character instanceof L2PcInstance) {
                    ((L2PcInstance)character).sendPacket(SystemMessage.getSystemMessage(SystemMessageId.LEFT_COMBAT_ZONE));
                    ((L2PcInstance)character).stopFameTask();
                    if (((L2PcInstance)character).getMountType() == 2) {
                        ((L2PcInstance)character).exitedNoLanding();
                    }
                }
                if (!(character instanceof L2SiegeSummonInstance)) continue;
                ((L2SiegeSummonInstance)character).unSummon(((L2SiegeSummonInstance)character).getOwner());
            }
        }
    }

    public void announceToPlayers(String message) {
        for (L2Character temp : this._characterList.values()) {
            if (!(temp instanceof L2PcInstance)) continue;
            ((L2PcInstance)temp).sendMessage(message);
        }
    }

    public FastList<L2PcInstance> getAllPlayers() {
        FastList players = new FastList();
        for (L2Character temp : this._characterList.values()) {
            if (!(temp instanceof L2PcInstance)) continue;
            players.add((Object)((L2PcInstance)temp));
        }
        return players;
    }

    public int getSiegeObjectId() {
        return this._siegableId;
    }

    public boolean isActive() {
        return this._isActiveSiege;
    }

    public void setIsActive(boolean val) {
        this._isActiveSiege = val;
    }

    public void setSiegeInstance(Siegable siege) {
        this._siege = siege;
    }

    public void banishForeigners(L2Clan owningClan) {
        for (L2Character temp : this._characterList.values()) {
            if (!(temp instanceof L2PcInstance) || ((L2PcInstance)temp).getClan() == owningClan || ((L2PcInstance)temp).isGM()) continue;
            ((L2PcInstance)temp).teleToLocation(MapRegionTable.TeleportWhereType.Town);
        }
    }
}

