/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.TaskPriority;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.instancemanager.AirShipManager;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.VehiclePathPoint;
import com.l2jserver.gameserver.model.actor.instance.L2AirShipInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public class MoveToLocationAirShip
extends L2GameClientPacket {
    public static final int MIN_Z = -895;
    public static final int MAX_Z = 6105;
    public static final int STEP = 300;
    private static final String _C__D0_38_MOVETOLOCATIONAIRSHIP = "[C] D0:38 MoveToLocationAirShip";
    private int _command;
    private int _param1;
    private int _param2 = 0;

    public TaskPriority getPriority() {
        return TaskPriority.PR_HIGH;
    }

    @Override
    protected void readImpl() {
        this._command = this.readD();
        this._param1 = this.readD();
        if (this._buf.remaining() > 0) {
            this._param2 = this.readD();
        }
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (!activeChar.isInAirShip()) {
            return;
        }
        L2AirShipInstance ship = activeChar.getAirShip();
        if (!ship.isCaptain(activeChar)) {
            return;
        }
        int z = ship.getZ();
        switch (this._command) {
            case 0: {
                if (!ship.canBeControlled()) {
                    return;
                }
                if (this._param1 >= -166168) break;
                ship.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(this._param1, this._param2, z, 0));
                break;
            }
            case 1: {
                if (!ship.canBeControlled()) {
                    return;
                }
                ship.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                break;
            }
            case 2: {
                if (!ship.canBeControlled()) {
                    return;
                }
                if (z >= 6105) break;
                z = Math.min(z + 300, 6105);
                ship.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(ship.getX(), ship.getY(), z, 0));
                break;
            }
            case 3: {
                if (!ship.canBeControlled()) {
                    return;
                }
                if (z <= -895) break;
                z = Math.max(z - 300, -895);
                ship.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(ship.getX(), ship.getY(), z, 0));
                break;
            }
            case 4: {
                if (!ship.isInDock() || ship.isMoving()) {
                    return;
                }
                VehiclePathPoint[] dst = AirShipManager.getInstance().getTeleportDestination(ship.getDockId(), this._param1);
                if (dst == null) {
                    return;
                }
                int fuelConsumption = AirShipManager.getInstance().getFuelConsumption(ship.getDockId(), this._param1);
                if (fuelConsumption > 0) {
                    if (fuelConsumption > ship.getFuel()) {
                        activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.THE_AIRSHIP_CANNOT_TELEPORT));
                        return;
                    }
                    ship.setFuel(ship.getFuel() - fuelConsumption);
                }
                ship.executePath(dst);
            }
        }
    }

    @Override
    public String getType() {
        return _C__D0_38_MOVETOLOCATIONAIRSHIP;
    }
}

