/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.clientpackets.RequestJoinPledge;
import com.l2jserver.gameserver.network.serverpackets.JoinPledge;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowInfoUpdate;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListAdd;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListAll;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public final class RequestAnswerJoinPledge
extends L2GameClientPacket {
    private static final String _C__25_REQUESTANSWERJOINPLEDGE = "[C] 25 RequestAnswerJoinPledge";
    private int _answer;

    @Override
    protected void readImpl() {
        this._answer = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2PcInstance requestor = activeChar.getRequest().getPartner();
        if (requestor == null) {
            return;
        }
        if (this._answer == 0) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_DID_NOT_RESPOND_TO_S1_CLAN_INVITATION);
            sm.addString(requestor.getName());
            activeChar.sendPacket(sm);
            sm = null;
            sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DID_NOT_RESPOND_TO_CLAN_INVITATION);
            sm.addString(activeChar.getName());
            requestor.sendPacket(sm);
            sm = null;
        } else {
            if (!(requestor.getRequest().getRequestPacket() instanceof RequestJoinPledge)) {
                return;
            }
            RequestJoinPledge requestPacket = (RequestJoinPledge)requestor.getRequest().getRequestPacket();
            L2Clan clan = requestor.getClan();
            if (clan.checkClanJoinCondition(requestor, activeChar, requestPacket.getPledgeType())) {
                activeChar.sendPacket(new JoinPledge(requestor.getClanId()));
                activeChar.setPledgeType(requestPacket.getPledgeType());
                if (requestPacket.getPledgeType() == -1) {
                    activeChar.setPowerGrade(9);
                    activeChar.setLvlJoinedAcademy(activeChar.getLevel());
                } else {
                    activeChar.setPowerGrade(5);
                }
                clan.addClanMember(activeChar);
                activeChar.setClanPrivileges(activeChar.getClan().getRankPrivs(activeChar.getPowerGrade()));
                activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ENTERED_THE_CLAN));
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_HAS_JOINED_CLAN);
                sm.addString(activeChar.getName());
                clan.broadcastToOnlineMembers(sm);
                sm = null;
                if (activeChar.getClan().getHasCastle() > 0) {
                    CastleManager.getInstance().getCastleByOwner(activeChar.getClan()).giveResidentialSkills(activeChar);
                }
                if (activeChar.getClan().getHasFort() > 0) {
                    FortManager.getInstance().getFortByOwner(activeChar.getClan()).giveResidentialSkills(activeChar);
                }
                activeChar.sendSkillList();
                clan.broadcastToOtherOnlineMembers(new PledgeShowMemberListAdd(activeChar), activeChar);
                clan.broadcastToOnlineMembers(new PledgeShowInfoUpdate(clan));
                activeChar.sendPacket(new PledgeShowMemberListAll(clan, activeChar));
                activeChar.setClanJoinExpiryTime(0L);
                activeChar.broadcastUserInfo();
            }
        }
        activeChar.getRequest().onRequestResponse();
    }

    @Override
    public String getType() {
        return _C__25_REQUESTANSWERJOINPLEDGE;
    }
}

