/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.effects;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.DeleteObject;
import com.l2jserver.gameserver.skills.AbnormalEffect;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;

public class EffectHide
extends L2Effect {
    public EffectHide(Env env, EffectTemplate template) {
        super(env, template);
    }

    public EffectHide(Env env, L2Effect effect) {
        super(env, effect);
    }

    @Override
    public L2EffectType getEffectType() {
        return L2EffectType.HIDE;
    }

    @Override
    public boolean onStart() {
        if (this.getEffected() instanceof L2PcInstance) {
            L2PcInstance activeChar = (L2PcInstance)this.getEffected();
            activeChar.getAppearance().setInvisible();
            activeChar.startAbnormalEffect(AbnormalEffect.STEALTH);
            if (activeChar.getAI().getNextIntention() != null && activeChar.getAI().getNextIntention().getCtrlIntention() == CtrlIntention.AI_INTENTION_ATTACK) {
                activeChar.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
            }
            DeleteObject del = new DeleteObject(activeChar);
            for (L2Character target : activeChar.getKnownList().getKnownCharacters()) {
                try {
                    if (target.getTarget() == activeChar) {
                        target.setTarget(null);
                        target.abortAttack();
                        target.abortCast();
                        target.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                    }
                    if (!(target instanceof L2PcInstance)) continue;
                    target.sendPacket(del);
                }
                catch (NullPointerException e) {}
            }
        }
        return true;
    }

    @Override
    public void onExit() {
        if (this.getEffected() instanceof L2PcInstance) {
            L2PcInstance activeChar = (L2PcInstance)this.getEffected();
            if (!activeChar.inObserverMode()) {
                activeChar.getAppearance().setVisible();
            }
            activeChar.stopAbnormalEffect(AbnormalEffect.STEALTH);
        }
    }

    @Override
    public boolean onActionTime() {
        return false;
    }
}

