/*
 * Decompiled with CFR 0.152.
 */
package org.netcon;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public abstract class BaseWritePacket {
    private final ByteArrayOutputStream _bao = new ByteArrayOutputStream();

    protected BaseWritePacket() {
    }

    protected final void writeC(int value) {
        this._bao.write(value & 0xFF);
    }

    protected final void writeH(int value) {
        this._bao.write(value & 0xFF);
        this._bao.write(value >> 8 & 0xFF);
    }

    protected final void writeD(int value) {
        this._bao.write(value & 0xFF);
        this._bao.write(value >> 8 & 0xFF);
        this._bao.write(value >> 16 & 0xFF);
        this._bao.write(value >> 24 & 0xFF);
    }

    protected final void writeF(double value) {
        this.writeQ(Double.doubleToRawLongBits(value));
    }

    protected final void writeQ(long value) {
        this._bao.write((byte)(value & 0xFFL));
        this._bao.write((byte)(value >> 8 & 0xFFL));
        this._bao.write((byte)(value >> 16 & 0xFFL));
        this._bao.write((byte)(value >> 24 & 0xFFL));
        this._bao.write((byte)(value >> 32 & 0xFFL));
        this._bao.write((byte)(value >> 40 & 0xFFL));
        this._bao.write((byte)(value >> 48 & 0xFFL));
        this._bao.write((byte)(value >> 56 & 0xFFL));
    }

    protected final void writeS(String text) {
        try {
            if (text != null) {
                this._bao.write(text.getBytes("UTF-16LE"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._bao.write(0);
        this._bao.write(0);
    }

    protected final void writeB(byte[] array) {
        try {
            this._bao.write(array);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final byte[] getContent() throws IOException {
        this.writeD(0);
        int padding = this._bao.size() % 8;
        if (padding != 0) {
            for (int i = padding; i < 8; ++i) {
                this.writeC(0);
            }
        }
        return this._bao.toByteArray();
    }
}

