/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.log;

import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.util.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class DamageFormatter
extends Formatter {
    private static final String CRLF = "\r\n";
    private SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    @Override
    public String format(LogRecord record) {
        Object[] params = record.getParameters();
        StringBuilder output = StringUtil.startAppend(30 + record.getMessage().length() + (params == null ? 0 : params.length * 10), "[", this.dateFmt.format(new Date(record.getMillis())), "] '---': ", record.getMessage());
        for (Object p : params) {
            if (p == null) continue;
            if (p instanceof L2Character) {
                L2PcInstance owner;
                if (p instanceof L2Attackable && ((L2Attackable)p).isRaid()) {
                    StringUtil.append(output, "RaidBoss ");
                }
                StringUtil.append(output, ((L2Character)p).getName(), "(", String.valueOf(((L2Character)p).getObjectId()), ") ");
                StringUtil.append(output, String.valueOf(((L2Character)p).getLevel()), " lvl");
                if (!(p instanceof L2Summon) || (owner = ((L2Summon)p).getOwner()) == null) continue;
                StringUtil.append(output, " Owner:", owner.getName(), "(", String.valueOf(owner.getObjectId()), ")");
                continue;
            }
            if (p instanceof L2Skill) {
                StringUtil.append(output, " with skill ", ((L2Skill)p).getName(), "(", String.valueOf(((L2Skill)p).getId()), ")");
                continue;
            }
            StringUtil.append(output, p.toString());
        }
        output.append(CRLF);
        return output.toString();
    }
}

