/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.operations;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.operations.UpdateOperation;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class ReplaceOperation
extends UpdateOperation {
    private final SVNRevision revision;
    private IResource[] resourcesToUpdate;

    public ReplaceOperation(IWorkbenchPart part, IResource[] resources, SVNRevision revision) {
        super(part, resources, revision);
        this.revision = revision;
    }

    public ReplaceOperation(IWorkbenchPart part, IResource resource, SVNRevision revision) {
        super(part, resource, revision);
        this.revision = revision;
    }

    protected String getTaskName() {
        return Policy.bind("ReplaceOperation.taskName");
    }

    protected String getTaskName(SVNTeamProvider provider) {
        return Policy.bind("ReplaceOperation.0", provider.getProject().getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(SVNTeamProvider provider, IResource[] resources, IProgressMonitor monitor) throws SVNException, InterruptedException {
        monitor.beginTask(null, 100);
        try {
            block13: {
                try {
                    boolean removeUnAdded = SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_remove_unadded_resources_on_replace");
                    int i = 0;
                    while (i < resources.length) {
                        IResource resource = resources[i];
                        ISVNLocalResource localResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                        if (!localResource.isManaged() && removeUnAdded) {
                            try {
                                resource.delete(true, monitor);
                            }
                            catch (CoreException ex) {
                                throw SVNException.wrapException((CoreException)ex);
                            }
                        } else if (localResource.isDirty()) {
                            localResource.revert();
                        }
                        if (!this.revision.equals((Object)SVNRevision.BASE)) {
                            IResource[] updateResources = new IResource[]{resource};
                            super.execute(provider, updateResources, monitor);
                        }
                        ++i;
                    }
                }
                catch (SVNException e) {
                    if (e.operationInterrupted()) {
                        this.showCancelledMessage();
                        break block13;
                    }
                    this.collectStatus(e.getStatus());
                }
            }
            Object var9_13 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    public void setResourcesToUpdate(IResource[] resourcesToUpdate) {
        this.resourcesToUpdate = resourcesToUpdate;
    }
}

