/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.operations;

import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.commands.GetAnnotationsCommand;
import org.tigris.subversion.subclipse.core.commands.GetLogsCommand;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.history.LogEntry;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.annotations.AnnotateBlock;
import org.tigris.subversion.subclipse.ui.annotations.AnnotateBlocks;
import org.tigris.subversion.subclipse.ui.annotations.AnnotateView;
import org.tigris.subversion.subclipse.ui.operations.CommitterColors;
import org.tigris.subversion.subclipse.ui.operations.SVNOperation;
import org.tigris.subversion.subclipse.ui.operations.ShowAnnotationOperation;
import org.tigris.subversion.subclipse.ui.operations.SourceViewerInformationControl;
import org.tigris.subversion.svnclientadapter.ISVNAnnotations;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class ShowAnnotationOperation
extends SVNOperation {
    private final SVNRevision fromRevision;
    private final SVNRevision toRevision;
    private final ISVNRemoteFile remoteFile;
    private final boolean includeMergedRevisions;
    private final boolean ignoreMimeType;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public ShowAnnotationOperation(IWorkbenchPart part, ISVNRemoteFile remoteFile, SVNRevision fromRevision, boolean includeMergedRevisions, boolean ignoreMimeType) {
        super(part);
        this.remoteFile = remoteFile;
        this.fromRevision = fromRevision;
        this.toRevision = remoteFile.getLastChangedRevision();
        this.includeMergedRevisions = includeMergedRevisions;
        this.ignoreMimeType = ignoreMimeType;
    }

    public ShowAnnotationOperation(IWorkbenchPart part, ISVNRemoteFile remoteFile, SVNRevision fromRevision, SVNRevision toRevision, boolean includeMergedRevisions, boolean ignoreMimeType) {
        super(part);
        this.remoteFile = remoteFile;
        this.fromRevision = fromRevision;
        this.toRevision = toRevision;
        this.includeMergedRevisions = includeMergedRevisions;
        this.ignoreMimeType = ignoreMimeType;
    }

    public ShowAnnotationOperation(IWorkbenchPart part, ISVNRemoteFile remoteFile, boolean includeMergedRevisions, boolean ignoreMimeType) {
        this(part, remoteFile, SVNRevision.START, includeMergedRevisions, ignoreMimeType);
    }

    protected String getTaskName(SVNTeamProvider provider) {
        return Policy.bind("AnnotateOperation.0", provider.getProject().getName());
    }

    protected String getTaskName() {
        return Policy.bind("AnnotateOperation.taskName");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(final IProgressMonitor monitor) throws SVNException, InterruptedException {
        monitor.beginTask(null, 100);
        try {
            block6: {
                try {
                    GetAnnotationsCommand command = new GetAnnotationsCommand(this.remoteFile, this.fromRevision, this.toRevision, this.includeMergedRevisions, this.ignoreMimeType);
                    command.run((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    final ISVNAnnotations annotations = command.getAnnotations();
                    final AnnotateBlocks annotateBlocks = new AnnotateBlocks(annotations);
                    this.getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            AbstractDecoratedTextEditor editor = ShowAnnotationOperation.this.getEditor();
                            if (editor != null && ShowAnnotationOperation.this.promptForQuickDiffAnnotate()) {
                                RevisionInformation information = ShowAnnotationOperation.this.createRevisionInformation(annotateBlocks, Policy.subMonitorFor(monitor, 20));
                                editor.showRevisionInformation(information, "org.tigris.subversion.subclipse.quickdiff.providers.SVNReferenceProvider");
                            } else {
                                try {
                                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                    if (window != null) {
                                        try {
                                            PlatformUI.getWorkbench().showPerspective("org.tigris.subversion.subclipse.ui.svnPerspective", window);
                                        }
                                        catch (WorkbenchException workbenchException) {}
                                    }
                                    AnnotateView view = AnnotateView.openInActivePerspective();
                                    view.showAnnotations(ShowAnnotationOperation.this.remoteFile, annotateBlocks.getAnnotateBlocks(), annotations.getInputStream());
                                }
                                catch (PartInitException e1) {
                                    ShowAnnotationOperation.this.collectStatus(e1.getStatus());
                                }
                            }
                        }
                    });
                }
                catch (SVNException e) {
                    if (e.operationInterrupted()) {
                        this.showCancelledMessage();
                        break block6;
                    }
                    this.collectStatus(e.getStatus());
                }
            }
            Object var5_8 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    protected IAction getGotoAction() {
        return super.getGotoAction();
    }

    private AbstractDecoratedTextEditor getEditor() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IEditorReference[] references = window.getActivePage().getEditorReferences();
        IResource resource = this.remoteFile.getResource();
        if (resource == null) {
            return null;
        }
        int i = 0;
        while (i < references.length) {
            block16: {
                IEditorReference reference = references[i];
                try {
                    if (resource == null) break block16;
                    IEditorInput iEditorInput = reference.getEditorInput();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IFile");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (resource.equals(iEditorInput.getAdapter((Class)clazz))) {
                        IEditorPart editor = reference.getEditor(false);
                        if (editor instanceof AbstractDecoratedTextEditor) {
                            return (AbstractDecoratedTextEditor)editor;
                        }
                        IEditorPart part = this.getPart().getSite().getPage().openEditor((IEditorInput)new FileEditorInput((IFile)resource), "org.eclipse.ui.DefaultTextEditor", true, 0);
                        if (part != null && part instanceof AbstractDecoratedTextEditor) {
                            return (AbstractDecoratedTextEditor)part;
                        }
                    }
                }
                catch (PartInitException partInitException) {}
            }
            ++i;
        }
        if (resource instanceof IFile) {
            try {
                IEditorPart part;
                IEditorDescriptor descrptr = IDE.getEditorDescriptor((IFile)((IFile)resource));
                if (descrptr.isInternal()) {
                    part = IDE.openEditor((IWorkbenchPage)this.getPart().getSite().getPage(), (IFile)((IFile)resource));
                    if (part instanceof AbstractDecoratedTextEditor) {
                        return (AbstractDecoratedTextEditor)part;
                    }
                    this.getPart().getSite().getPage().closeEditor(part, false);
                }
                if ((part = IDE.openEditor((IWorkbenchPage)this.getPart().getSite().getPage(), (IFile)((IFile)resource), (String)"org.eclipse.ui.DefaultTextEditor")) != null && part instanceof AbstractDecoratedTextEditor) {
                    return (AbstractDecoratedTextEditor)part;
                }
            }
            catch (PartInitException partInitException) {}
        }
        return null;
    }

    private RevisionInformation createRevisionInformation(AnnotateBlocks annotateBlocks, IProgressMonitor monitor) {
        HashMap<Long, ILogEntry> logEntriesByRevision = new HashMap<Long, ILogEntry>();
        GetLogsCommand logCommand = new GetLogsCommand((ISVNRemoteResource)this.remoteFile, SVNRevision.HEAD, this.fromRevision, this.toRevision, false, 0L, null, false);
        try {
            logCommand.run(monitor);
            ILogEntry[] logEntries = logCommand.getLogEntries();
            int i = 0;
            while (i < logEntries.length) {
                ILogEntry logEntry = logEntries[i];
                logEntriesByRevision.put(new Long(logEntry.getRevision().getNumber()), logEntry);
                ++i;
            }
        }
        catch (SVNException e) {
            SVNUIPlugin.log((TeamException)((Object)e));
        }
        RevisionInformation info = new RevisionInformation();
        try {
            String tooltipAffordance = "Press F2 for focus.";
            try {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ui.editors.text.EditorsUI");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                tooltipAffordance = (String)clazz.getMethod("getTooltipAffordanceString", null).invoke(null, null);
            }
            catch (Exception exception) {}
            Class<?> infoClass = info.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.jface.text.IInformationControlCreator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class[] paramTypes = classArray;
            Method setHoverControlCreator = infoClass.getMethod("setHoverControlCreator", paramTypes);
            Method setInformationPresenterControlCreator = infoClass.getMethod("setInformationPresenterControlCreator", paramTypes);
            final class AnnotationControlCreator
            implements IInformationControlCreator {
                private final String statusFieldText;
                final /* synthetic */ ShowAnnotationOperation this$0;

                public AnnotationControlCreator(ShowAnnotationOperation showAnnotationOperation, String statusFieldText) {
                    this.this$0 = showAnnotationOperation;
                    this.statusFieldText = statusFieldText;
                }

                public IInformationControl createInformationControl(Shell parent) {
                    return new SourceViewerInformationControl(parent, 4, 0, "org.eclipse.jface.defaultfont", this.statusFieldText);
                }
            }
            setHoverControlCreator.invoke((Object)info, new AnnotationControlCreator(this, tooltipAffordance));
            setInformationPresenterControlCreator.invoke((Object)info, new AnnotationControlCreator(this, null));
        }
        catch (Exception exception) {}
        final CommitterColors colors = CommitterColors.getDefault();
        HashMap<String, Revision> sets = new HashMap<String, Revision>();
        Iterator blocks = annotateBlocks.getAnnotateBlocks().iterator();
        while (blocks.hasNext()) {
            final AnnotateBlock block = (AnnotateBlock)blocks.next();
            final String revisionString = Long.toString(block.getRevision());
            LogEntry logEntry = (LogEntry)logEntriesByRevision.get(new Long(block.getRevision()));
            final String logMessage = logEntry == null ? this.getSingleEntry(this.remoteFile, new Long(block.getRevision())) : logEntry.getComment();
            Revision revision = (Revision)sets.get(revisionString);
            if (revision == null) {
                revision = new Revision(){

                    public Object getHoverInfo() {
                        return String.valueOf(block.getUser()) + " " + revisionString + " " + DateFormat.getDateTimeInstance(2, 3).format(block.getDate()) + "\n\n" + (logMessage != null ? logMessage : "");
                    }

                    public String getAuthor() {
                        return block.getUser();
                    }

                    public String getId() {
                        return revisionString;
                    }

                    public Date getDate() {
                        return block.getDate();
                    }

                    public RGB getColor() {
                        return colors.getCommitterRGB(this.getAuthor());
                    }
                };
                sets.put(revisionString, revision);
                info.addRevision(revision);
            }
            revision.addRange((ILineRange)new LineRange(block.getStartLine(), block.getEndLine() - block.getStartLine() + 1));
        }
        return info;
    }

    private boolean promptForQuickDiffAnnotate() {
        IPreferenceStore store = SVNUIPlugin.getPlugin().getPreferenceStore();
        String option = store.getString("pref_use_quickdiffannotate");
        if (option.equals("always")) {
            return true;
        }
        if (option.equals("never")) {
            return false;
        }
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)Utils.getShell(null), (String)Policy.bind("AnnotateOperation_QDAnnotateTitle"), (String)Policy.bind("AnnotateOperation_QDAnnotateMessage"), (String)Policy.bind("AnnotateOperation_4"), (boolean)false, (IPreferenceStore)store, (String)"pref_use_quickdiffannotate");
        int result = dialog.getReturnCode();
        switch (result) {
            case 0: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    private String getSingleEntry(ISVNRemoteFile file, Long revLong) {
        try {
            ISVNClientAdapter client = file.getRepository().getSVNClient();
            SVNRevision revision = SVNRevision.getRevision((String)revLong.toString());
            ISVNLogMessage[] messages = client.getLogMessages(file.getRepository().getRepositoryRoot(), revision, revision, false);
            if (messages.length == 1) {
                return messages[0].getMessage();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

