/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.eclipse.editors;

import java.util.ArrayList;
import net.sf.colorer.eclipse.ColorerPlugin;
import net.sf.colorer.eclipse.jface.ColorerContentAssistProcessor;
import net.sf.colorer.eclipse.jface.TextColorer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class ColorerSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private TextColorer fTextColorer;
    private ColorerContentAssistProcessor fCAP;

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        ArrayList<String> list = new ArrayList<String>();
        int tabWidth = this.getTabWidth(sourceViewer);
        boolean useSpaces = ColorerPlugin.getDefault().getCombinedPreferenceStore().getBoolean("SPACES_FOR_TABS");
        for (int i = 0; i <= tabWidth; ++i) {
            int j;
            StringBuffer prefix = new StringBuffer();
            if (useSpaces) {
                j = 0;
                while (j + i < tabWidth) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != 0) {
                    prefix.append('\t');
                }
            } else {
                for (j = 0; j < i; ++j) {
                    prefix.append(' ');
                }
                if (i != tabWidth) {
                    prefix.append('\t');
                }
            }
            list.add(prefix.toString());
        }
        list.add("");
        return list.toArray(new String[list.size()]);
    }

    public ColorerSourceViewerConfiguration(TextColorer textColorer) {
        super(ColorerPlugin.getDefault().getCombinedPreferenceStore());
        this.fTextColorer = textColorer;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant ca = new ContentAssistant();
        this.fCAP = new ColorerContentAssistProcessor();
        ca.setContentAssistProcessor((IContentAssistProcessor)this.fCAP, "__dftl_partition_content_type");
        ca.enableAutoActivation(true);
        ca.setAutoActivationDelay(500);
        ca.setProposalPopupOrientation(10);
        return null;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        return this.fTextColorer.getPresentationReconciler();
    }
}

