/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.eclipse.jface;

import java.util.Iterator;
import net.sf.colorer.Region;
import net.sf.colorer.eclipse.jface.ColorerAnnotation;
import net.sf.colorer.eclipse.jface.IColorerEditorAdapter;
import net.sf.colorer.editor.BaseEditor;
import net.sf.colorer.editor.OutlineItem;
import net.sf.colorer.editor.OutlineListener;
import net.sf.colorer.editor.Outliner;
import net.sf.colorer.impl.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Display;

public class ColorerAnnotationProvider {
    static final int UPDATE_PERIOD = 1000;
    private volatile Outliner builder;
    private BaseEditor fBaseEditor;
    private IDocument fDocument;
    private IColorerEditorAdapter fEditor;
    private boolean fAnnotationsUpdated = false;
    OutlineListener outlineListener = new AnnotationOutlineListener();
    Region def_TODO;
    Region def_ErrorText;
    Region def_Debug;
    static /* synthetic */ Class class$org$eclipse$jface$text$source$ISourceViewer;
    static /* synthetic */ Class class$org$eclipse$jface$text$IDocument;

    void updateAnnotations() {
        if (this.fAnnotationsUpdated) {
            return;
        }
        IAnnotationModel model = this.getModel();
        if (model == null) {
            return;
        }
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Annotation ann = (Annotation)iter.next();
            if (!(ann instanceof ColorerAnnotation)) continue;
            model.removeAnnotation(ann);
        }
        if (!this.fEditor.getTextColorer().canProcess()) {
            return;
        }
        try {
            for (int idx = 0; idx < this.builder.itemCount(); ++idx) {
                OutlineItem item = this.builder.getItem(idx);
                int offset = this.fDocument.getLineOffset(item.lno) + item.pos;
                Position position = new Position(offset, item.token.length());
                String type = "org.eclipse.ui.workbench.texteditor.error";
                if (item.region.hasParent(this.def_TODO)) {
                    type = "org.eclipse.ui.workbench.texteditor.task";
                }
                if (item.region.hasParent(this.def_ErrorText)) {
                    type = "org.eclipse.ui.workbench.texteditor.warning";
                }
                if (item.region.hasParent(this.def_Debug)) {
                    type = "org.eclipse.ui.workbench.texteditor.info";
                }
                ColorerAnnotation annotation = new ColorerAnnotation(type, item.region.getDescription() + " : " + item.token);
                model.addAnnotation((Annotation)annotation, position);
            }
        }
        catch (Exception e) {
            Logger.error("ColorerAnnotationProvider", "updateAnnotations", e);
        }
        this.fAnnotationsUpdated = true;
    }

    IAnnotationModel getModel() {
        if (this.fEditor == null) {
            return null;
        }
        return ((ISourceViewer)this.fEditor.getAdapter(class$org$eclipse$jface$text$source$ISourceViewer == null ? (class$org$eclipse$jface$text$source$ISourceViewer = ColorerAnnotationProvider.class$("org.eclipse.jface.text.source.ISourceViewer")) : class$org$eclipse$jface$text$source$ISourceViewer)).getAnnotationModel();
    }

    public void install(IColorerEditorAdapter editor) {
        this.fEditor = editor;
        this.fDocument = (IDocument)this.fEditor.getAdapter(class$org$eclipse$jface$text$IDocument == null ? (class$org$eclipse$jface$text$IDocument = ColorerAnnotationProvider.class$("org.eclipse.jface.text.IDocument")) : class$org$eclipse$jface$text$IDocument);
        this.fBaseEditor = this.fEditor.getBaseEditor();
        Assert.isNotNull((Object)this.fBaseEditor);
        this.builder = new Outliner(this.fBaseEditor.getParserFactory().getHRCParser().getRegion("def:Error"));
        this.builder.attachOutliner(this.fBaseEditor);
        this.builder.addUpdateListener(this.outlineListener);
        this.def_TODO = this.fBaseEditor.getParserFactory().getHRCParser().getRegion("def:TODO");
        this.def_ErrorText = this.fBaseEditor.getParserFactory().getHRCParser().getRegion("def:ErrorText");
        this.def_Debug = this.fBaseEditor.getParserFactory().getHRCParser().getRegion("def:Debug");
        new Thread(new Runnable(){
            Display rootDisplay = Display.getCurrent();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (ColorerAnnotationProvider.this.builder != null && this.rootDisplay != null && !this.rootDisplay.isDisposed()) {
                    Outliner outliner = ColorerAnnotationProvider.this.builder;
                    synchronized (outliner) {
                        if (ColorerAnnotationProvider.this.builder != null) {
                            ColorerAnnotationProvider.this.updateAnnotations();
                        }
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }, "ColorerAnnotationProvider").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall() {
        Outliner outliner = this.builder;
        synchronized (outliner) {
            this.builder.detachOutliner(this.fBaseEditor);
            this.builder.removeUpdateListener(this.outlineListener);
            this.builder = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class AnnotationOutlineListener
    implements OutlineListener {
        AnnotationOutlineListener() {
        }

        public void notifyUpdate() {
            ColorerAnnotationProvider.this.fAnnotationsUpdated = false;
        }
    }
}

