/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Hashtable;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import net.sf.colorer.FileType;
import net.sf.colorer.LineSource;
import net.sf.colorer.ParserFactory;
import net.sf.colorer.editor.BaseEditor;
import net.sf.colorer.handlers.StyledRegion;
import net.sf.colorer.impl.BaseEditorNative;

public class JColoredTextArea
extends JTextArea {
    private static final long serialVersionUID = -1316654352760531864L;
    private Hashtable colorsHash = new Hashtable();
    private BaseEditor baseEditor;

    public JColoredTextArea() {
        LineSource lineSource = new LineSource(){

            public String getLine(int lno) {
                String line = null;
                try {
                    int start = JColoredTextArea.this.getLineStartOffset(lno);
                    int end = JColoredTextArea.this.getLineEndOffset(lno);
                    line = JColoredTextArea.this.getText(start, end - start);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                return line;
            }
        };
        ParserFactory pf = new ParserFactory();
        this.baseEditor = new BaseEditorNative(pf, lineSource);
        this.baseEditor.setRegionCompact(true);
        this.updateParameters();
    }

    void updateParameters() {
    }

    public void chooseFileType(String filename) {
        int count = this.getDocument().getLength();
        if (count > 300) {
            count = 300;
        }
        try {
            String fline = this.getText(0, count - 1);
            this.baseEditor.chooseFileType(filename);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void setFileType(FileType typename) {
        this.baseEditor.setFileType(typename);
    }

    public void setColoringStyle(String name) throws IllegalArgumentException {
        this.baseEditor.setRegionMapper("rgb", name);
        StyledRegion sr = (StyledRegion)this.baseEditor.getBackground();
        this.setForeground(this.getColor(sr.bfore, sr.fore));
        this.setBackground(this.getColor(sr.bback, sr.back));
    }

    public void paint(Graphics g) {
        boolean idx = false;
        super.paint(g);
    }

    private Color getColor(boolean has, int rgb) {
        if (!has) {
            return null;
        }
        Color color = (Color)this.colorsHash.get(new Integer(rgb));
        if (color == null) {
            color = new Color(rgb >> 16, rgb >> 8 & 0xFF, rgb & 0xFF);
            this.colorsHash.put(new Integer(rgb), color);
        }
        return color;
    }
}

