/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.swt;

import java.util.Vector;
import net.sf.colorer.FileType;
import net.sf.colorer.LineSource;
import net.sf.colorer.ParserFactory;
import net.sf.colorer.editor.BaseEditor;
import net.sf.colorer.editor.PairMatch;
import net.sf.colorer.handlers.LineRegion;
import net.sf.colorer.handlers.RegionDefine;
import net.sf.colorer.handlers.RegionMapper;
import net.sf.colorer.handlers.StyledRegion;
import net.sf.colorer.impl.BaseEditorNative;
import net.sf.colorer.swt.ColorManager;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;

public class TextColorer {
    public static final int HLS_NONE = 0;
    public static final int HLS_XOR = 1;
    public static final int HLS_OUTLINE = 2;
    public static final int HLS_OUTLINE2 = 3;
    private ColorManager cm;
    ParserFactory pf = null;
    BaseEditor baseEditor = null;
    StyledText text = null;
    boolean fullBackground = false;
    boolean vertCross = false;
    boolean horzCross = false;
    RegionDefine vertCrossColor = null;
    RegionDefine horzCrossColor = null;
    int highlightStyle = 1;
    PairMatch currentPair = null;
    int prevLine = 0;
    int visibleStart;
    int visibleEnd;
    boolean lineHighlighting = true;
    boolean pairsHighlighting = true;
    boolean backParserDelay = false;
    InternalHandler ml = new InternalHandler();

    public TextColorer(ParserFactory pf, ColorManager cm) {
        this.pf = pf;
        this.cm = cm;
        this.setFullBackground(false);
        this.setCross(false, false);
        this.baseEditor = new BaseEditorNative(pf, new LineSource(){

            public String getLine(int lno) {
                if (TextColorer.this.text.getContent().getLineCount() <= lno) {
                    return null;
                }
                String line = TextColorer.this.text.getContent().getLine(lno);
                return line;
            }
        });
        this.baseEditor.setRegionCompact(true);
    }

    public void attach(StyledText parent) {
        if (this.baseEditor == null) {
            throw new RuntimeException("Attach after detach");
        }
        this.text = parent;
        this.text.addDisposeListener((DisposeListener)this.ml);
        this.text.addLineStyleListener((LineStyleListener)this.ml);
        this.text.addLineBackgroundListener((LineBackgroundListener)this.ml);
        this.text.addPaintListener((PaintListener)this.ml);
        this.text.addVerifyListener((VerifyListener)this.ml);
        this.text.addControlListener((ControlListener)this.ml);
        this.text.addKeyListener((KeyListener)this.ml);
        this.text.addTraverseListener((TraverseListener)this.ml);
        this.text.addMouseListener((MouseListener)this.ml);
        this.text.addSelectionListener((SelectionListener)this.ml);
        this.text.getContent().addTextChangeListener((TextChangeListener)this.ml);
        ScrollBar sb = this.text.getVerticalBar();
        if (sb != null) {
            sb.addSelectionListener((SelectionListener)this.ml);
        }
        this.updateViewport();
        new Thread(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (TextColorer.this.baseEditor == null || TextColorer.this.text == null) break;
                    if (TextColorer.this.backParserDelay) {
                        TextColorer.this.backParserDelay = false;
                        try {
                            Thread.sleep(1500L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            if ((this).TextColorer.this.baseEditor == null || (this).TextColorer.this.text == null) {
                                return;
                            }
                            if ((this).TextColorer.this.text.isDisposed()) {
                                return;
                            }
                            (this).TextColorer.this.baseEditor.idleJob(80);
                        }
                    });
                }
            }
        }.start();
    }

    public void detach() {
        if (this.text == null) {
            return;
        }
        this.text.removeDisposeListener((DisposeListener)this.ml);
        this.text.removeLineStyleListener((LineStyleListener)this.ml);
        this.text.removeLineBackgroundListener((LineBackgroundListener)this.ml);
        this.text.removePaintListener((PaintListener)this.ml);
        this.text.removeVerifyListener((VerifyListener)this.ml);
        this.text.removeControlListener((ControlListener)this.ml);
        this.text.removeKeyListener((KeyListener)this.ml);
        this.text.removeTraverseListener((TraverseListener)this.ml);
        this.text.removeMouseListener((MouseListener)this.ml);
        this.text.removeSelectionListener((SelectionListener)this.ml);
        this.text.getContent().removeTextChangeListener((TextChangeListener)this.ml);
        ScrollBar sb = this.text.getVerticalBar();
        if (sb != null) {
            sb.removeSelectionListener((SelectionListener)this.ml);
        }
        this.baseEditor.dispose();
        this.baseEditor = null;
    }

    void checkActive() {
        if (this.text == null) {
            throw new RuntimeException("Object is not attached to StyledText");
        }
    }

    public FileType chooseFileType(String filename) {
        this.checkActive();
        return this.baseEditor.chooseFileType(filename);
    }

    public void setFileType(FileType typename) {
        this.checkActive();
        this.baseEditor.setFileType(typename);
    }

    public FileType getFileType() {
        this.checkActive();
        return this.baseEditor.getFileType();
    }

    public ParserFactory getParserFactory() {
        return this.pf;
    }

    public BaseEditor getBaseEditor() {
        return this.baseEditor;
    }

    public void setRegionMapper(RegionMapper regionMapper, boolean useBackground) {
        this.baseEditor.setRegionMapper(regionMapper);
        StyledRegion sr = (StyledRegion)this.baseEditor.getBackground();
        this.text.setForeground(null);
        this.text.setBackground(null);
        if (useBackground) {
            this.text.setForeground(this.cm.getColor(sr.bfore, sr.fore));
            this.text.setBackground(this.cm.getColor(sr.bback, sr.back));
        }
        this.setCross(this.vertCross, this.horzCross);
    }

    public void setRegionMapper(String hrdName, boolean useBackground) {
        this.baseEditor.setRegionMapper("rgb", hrdName);
        StyledRegion sr = (StyledRegion)this.baseEditor.getBackground();
        this.text.setForeground(null);
        this.text.setBackground(null);
        if (useBackground) {
            this.text.setForeground(this.cm.getColor(sr.bfore, sr.fore));
            this.text.setBackground(this.cm.getColor(sr.bback, sr.back));
        }
        this.setCross(this.vertCross, this.horzCross);
    }

    public void setFullBackground(boolean full) {
        this.fullBackground = full;
    }

    public void setCross(boolean horz, boolean vert) {
        this.horzCross = horz;
        this.vertCross = vert;
        this.vertCrossColor = null;
        this.horzCrossColor = null;
        if (this.horzCross) {
            this.horzCrossColor = this.baseEditor.getHorzCross();
        }
        if (this.vertCross) {
            this.vertCrossColor = this.baseEditor.getVertCross();
        }
    }

    public void setPairsPainter(boolean paint, int style) {
        this.highlightStyle = style;
        if (!paint) {
            this.highlightStyle = 0;
        }
    }

    public boolean pairAvailable() {
        return this.currentPair != null;
    }

    public boolean matchPair() {
        if (this.currentPair == null) {
            return false;
        }
        int caret = this.text.getCaretOffset();
        int lno = this.text.getLineAtOffset(caret);
        PairMatch cp = this.baseEditor.getPairMatch(lno, caret - this.text.getOffsetAtLine(lno));
        this.baseEditor.searchGlobalPair(cp);
        if (cp.end == null) {
            return false;
        }
        if (cp.topPosition) {
            this.text.setSelection(this.text.getOffsetAtLine(cp.eline) + cp.end.end);
        } else {
            this.text.setSelection(this.text.getOffsetAtLine(cp.eline) + cp.end.start);
        }
        return true;
    }

    public boolean selectPair() {
        if (this.currentPair == null) {
            return false;
        }
        int caret = this.text.getCaretOffset();
        int lno = this.text.getLineAtOffset(caret);
        PairMatch cp = this.baseEditor.getPairMatch(lno, caret - this.text.getOffsetAtLine(lno));
        this.baseEditor.searchGlobalPair(cp);
        if (cp.end == null) {
            return false;
        }
        if (cp.topPosition) {
            this.text.setSelection(this.text.getOffsetAtLine(cp.sline) + cp.start.start, this.text.getOffsetAtLine(cp.eline) + cp.end.end);
        } else {
            this.text.setSelection(this.text.getOffsetAtLine(cp.eline) + cp.end.start, this.text.getOffsetAtLine(cp.sline) + cp.start.end);
        }
        return true;
    }

    public boolean selectContentPair() {
        if (this.currentPair == null) {
            return false;
        }
        int caret = this.text.getCaretOffset();
        int lno = this.text.getLineAtOffset(caret);
        PairMatch cp = this.baseEditor.getPairMatch(lno, caret - this.text.getOffsetAtLine(lno));
        this.baseEditor.searchGlobalPair(cp);
        if (cp.end == null) {
            return false;
        }
        if (cp.topPosition) {
            this.text.setSelection(this.text.getOffsetAtLine(cp.sline) + cp.start.end, this.text.getOffsetAtLine(cp.eline) + cp.end.start);
        } else {
            this.text.setSelection(this.text.getOffsetAtLine(cp.eline) + cp.end.end, this.text.getOffsetAtLine(cp.sline) + cp.start.start);
        }
        return true;
    }

    public int getVisibleStart() {
        return this.visibleStart;
    }

    public int getVisibleEnd() {
        return this.visibleEnd;
    }

    public LineRegion getCaretRegion() {
        LineRegion caretRegion = null;
        int caret = this.text.getCaretOffset();
        int lno = this.text.getLineAtOffset(caret);
        int linepos = caret - this.text.getOffsetAtLine(lno);
        LineRegion[] arr = this.baseEditor.getLineRegions(lno);
        if (arr == null) {
            return null;
        }
        for (int idx = 0; idx < arr.length; ++idx) {
            if (arr[idx].start > linepos || arr[idx].end <= linepos || arr[idx].special) continue;
            caretRegion = arr[idx];
        }
        return caretRegion;
    }

    public void stateChanged() {
        this.backParserDelay = true;
        int curLine = this.text.getLineAtOffset(this.text.getCaretOffset());
        if (this.lineHighlighting && this.text.getSelectionRange().y != 0) {
            this.lineHighlighting = false;
            this.drawLine(this.prevLine);
            this.pairsHighlighting = false;
            this.pairsDraw(null, this.currentPair);
            return;
        }
        if (this.text.getSelectionRange().y != 0) {
            return;
        }
        if (curLine < this.visibleStart || curLine > this.visibleEnd) {
            return;
        }
        if (!this.lineHighlighting) {
            this.lineHighlighting = true;
            this.drawLine(curLine);
        } else if (curLine != this.prevLine) {
            this.drawLine(this.prevLine);
            this.drawLine(curLine);
            this.prevLine = curLine;
        }
        if (!this.pairsHighlighting) {
            this.pairsHighlighting = true;
            this.pairsDraw(null, this.currentPair);
        } else {
            int lineOffset = this.text.getOffsetAtLine(curLine);
            PairMatch newmatch = this.baseEditor.getPairMatch(curLine, this.text.getCaretOffset() - lineOffset);
            if (newmatch != null) {
                this.baseEditor.searchLocalPair(newmatch);
            }
            if (newmatch == null && this.currentPair != null || newmatch != null && !newmatch.equals(this.currentPair)) {
                this.pairsDraw(null, this.currentPair);
                this.pairsDraw(null, newmatch);
            }
            this.currentPair = newmatch;
        }
    }

    public void modifyEvent(int lno) {
        this.checkActive();
        this.updateViewport();
        this.baseEditor.modifyEvent(lno);
        this.redrawFrom(lno);
        this.stateChanged();
    }

    void updateViewport() {
        this.checkActive();
        this.baseEditor.lineCountEvent(this.text.getLineCount());
        this.visibleStart = 0;
        try {
            this.visibleStart = this.text.getTopIndex() - 1;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        if (this.visibleStart < 0) {
            this.visibleStart = 0;
        }
        this.visibleEnd = this.visibleStart + this.text.getClientArea().height / this.text.getLineHeight();
        int lc = this.text.getLineCount();
        if (this.visibleEnd > lc) {
            this.visibleEnd = lc;
        }
        this.baseEditor.visibleTextEvent(this.visibleStart, this.visibleEnd - this.visibleStart + 2);
    }

    void pairDraw(GC gc, StyledRegion sr, int start, int end) {
        if (start > this.text.getCharCount() || end > this.text.getCharCount()) {
            return;
        }
        if (gc != null) {
            Point left = this.text.getLocationAtOffset(start);
            Point right = this.text.getLocationAtOffset(end);
            if (sr != null) {
                if (this.highlightStyle == 1) {
                    int resultColor = sr.fore ^ this.cm.getColor(this.text.getBackground());
                    if (this.text.getLineAtOffset(this.text.getCaretOffset()) == this.text.getLineAtOffset(start) && this.horzCross && this.horzCrossColor != null && ((StyledRegion)this.horzCrossColor).bback) {
                        resultColor = sr.fore ^ ((StyledRegion)this.horzCrossColor).back;
                    }
                    Color color = this.cm.getColor(sr.bfore, resultColor);
                    gc.setBackground(color);
                    gc.setXORMode(true);
                    gc.fillRectangle(left.x, left.y, right.x - left.x, gc.getFontMetrics().getHeight());
                } else if (this.highlightStyle == 2) {
                    Color color = this.cm.getColor(sr.bfore, sr.fore);
                    gc.setForeground(color);
                    gc.drawRectangle(left.x, left.y, right.x - left.x - 1, gc.getFontMetrics().getHeight() - 1);
                } else if (this.highlightStyle == 3) {
                    Color color = this.cm.getColor(sr.bfore, sr.fore);
                    gc.setForeground(color);
                    gc.setLineWidth(2);
                    gc.drawRectangle(left.x + 1, left.y + 1, right.x - left.x - 2, gc.getFontMetrics().getHeight() - 2);
                }
            }
        } else {
            this.text.redrawRange(start, end - start, true);
        }
    }

    void pairsDraw(GC gc, PairMatch pm) {
        int lineOffset;
        if (pm == null) {
            return;
        }
        if (pm.start != null) {
            if (pm.sline < this.visibleStart || pm.sline > this.visibleEnd) {
                return;
            }
            lineOffset = this.text.getOffsetAtLine(pm.sline);
            this.pairDraw(gc, (StyledRegion)pm.start.rdef, pm.start.start + lineOffset, pm.start.end + lineOffset);
        }
        if (pm.end != null) {
            if (pm.eline < this.visibleStart || pm.eline > this.visibleEnd) {
                return;
            }
            lineOffset = this.text.getOffsetAtLine(pm.eline);
            this.pairDraw(gc, (StyledRegion)pm.end.rdef, pm.end.start + lineOffset, pm.end.end + lineOffset);
        }
    }

    void redrawFrom(int lno) {
        if (lno < 0 || lno >= this.text.getLineCount()) {
            return;
        }
        int y = this.text.getLocationAtOffset((int)this.text.getOffsetAtLine((int)lno)).y;
        int height = this.text.getClientArea().height - y;
        int width = this.text.getClientArea().width + this.text.getHorizontalPixel();
        this.text.redraw(0, y, width, height, false);
    }

    void drawLine(int lno) {
        if (lno < 0 || lno >= this.text.getLineCount()) {
            return;
        }
        int y = this.text.getLocationAtOffset((int)this.text.getOffsetAtLine((int)lno)).y;
        int height = 0;
        height = this.text.getLineCount() > lno + 1 ? this.text.getLocationAtOffset((int)this.text.getOffsetAtLine((int)(lno + 1))).y - y : this.text.getLocationAtOffset((int)this.text.getCharCount()).y + this.text.getLineHeight();
        int width = this.text.getClientArea().width + this.text.getHorizontalPixel();
        this.text.redraw(0, y, width, height, false);
    }

    class InternalHandler
    implements VerifyListener,
    ControlListener,
    TextChangeListener,
    SelectionListener,
    MouseListener,
    KeyListener,
    DisposeListener,
    LineStyleListener,
    LineBackgroundListener,
    PaintListener,
    TraverseListener {
        InternalHandler() {
        }

        public void widgetDisposed(DisposeEvent e) {
            TextColorer.this.detach();
        }

        public void lineGetStyle(LineStyleEvent e) {
            int lno = TextColorer.this.text.getLineAtOffset(e.lineOffset);
            TextColorer.this.updateViewport();
            if (lno < TextColorer.this.visibleStart || lno > TextColorer.this.visibleEnd + 1) {
                e.styles = new StyleRange[0];
                return;
            }
            LineRegion[] lrarr = TextColorer.this.baseEditor.getLineRegions(lno);
            Vector<StyleRange> styles = new Vector<StyleRange>();
            for (int idx = 0; idx < lrarr.length; ++idx) {
                LineRegion lr = lrarr[idx];
                StyledRegion rdef = (StyledRegion)lr.rdef;
                if (rdef == null || lr.special) continue;
                int start = lr.start;
                int end = lr.end;
                if (end == -1) {
                    end = TextColorer.this.text.getContent().getLine(lno).length();
                }
                end -= start;
                start = e.lineOffset + start;
                StyleRange sr = new StyleRange(start, end, TextColorer.this.cm.getColor(rdef.bfore, rdef.fore), TextColorer.this.cm.getColor(rdef.bback, rdef.back), rdef.style);
                styles.addElement(sr);
            }
            e.styles = styles.toArray(new StyleRange[0]);
        }

        public void lineGetBackground(LineBackgroundEvent e) {
            int lno = TextColorer.this.text.getLineAtOffset(e.lineOffset);
            int caret = TextColorer.this.text.getCaretOffset();
            int length = e.lineText.length();
            if (TextColorer.this.horzCrossColor != null && TextColorer.this.horzCross && TextColorer.this.lineHighlighting && e.lineOffset <= caret && caret <= e.lineOffset + length) {
                e.lineBackground = TextColorer.this.cm.getColor(((StyledRegion)TextColorer.this.horzCrossColor).bback, ((StyledRegion)TextColorer.this.horzCrossColor).back);
                return;
            }
            if (!TextColorer.this.fullBackground) {
                return;
            }
            LineRegion[] lr = TextColorer.this.baseEditor.getLineRegions(lno);
            for (int idx = 0; idx < lr.length; ++idx) {
                StyledRegion rdef = (StyledRegion)lr[idx].rdef;
                if (lr[idx].end != -1 || rdef == null) continue;
                e.lineBackground = TextColorer.this.cm.getColor(rdef.bback, rdef.back);
            }
        }

        public void paintControl(PaintEvent e) {
            TextColorer.this.stateChanged();
            if (!TextColorer.this.pairsHighlighting) {
                return;
            }
            TextColorer.this.pairsDraw(e.gc, TextColorer.this.currentPair);
        }

        public void verifyText(VerifyEvent e) {
            TextColorer.this.baseEditor.modifyEvent(TextColorer.this.text.getLineAtOffset(e.start));
        }

        public void textChanged(TextChangedEvent event) {
            TextColorer.this.modifyEvent(TextColorer.this.text.getLineAtOffset(TextColorer.this.text.getCaretOffset()));
        }

        public void textChanging(TextChangingEvent event) {
        }

        public void textSet(TextChangedEvent event) {
            TextColorer.this.modifyEvent(0);
        }

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            TextColorer.this.updateViewport();
        }

        public void widgetSelected(SelectionEvent e) {
            TextColorer.this.updateViewport();
            TextColorer.this.stateChanged();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            TextColorer.this.stateChanged();
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTraversed(TraverseEvent e) {
            TextColorer.this.updateViewport();
            TextColorer.this.stateChanged();
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            TextColorer.this.stateChanged();
        }

        public void mouseUp(MouseEvent e) {
        }
    }
}

