/*
 * Decompiled with CFR 0.152.
 */
package de.loskutov.bco.asm;

import de.loskutov.bco.BytecodeOutlinePlugin;
import de.loskutov.bco.asm.CommentedClassVisitor;
import de.loskutov.bco.asm.DecompilerOptions;
import de.loskutov.bco.asm.Index;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.SimpleVerifier;
import org.objectweb.asm.tree.analysis.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecompiledMethod {
    private final List<Object> text;
    private final List localVariables;
    private final Map<Integer, Integer> sourceLines;
    private final Map<Integer, Integer> decompiledLines;
    private final Map<Integer, Integer> insns;
    private final Map<Integer, Integer> opcodes;
    private final Map<Integer, Integer> insnLines;
    private int lineCount;
    private int firstSourceLine;
    private int lastSourceLine;
    MethodNode meth;
    private Frame[] frames;
    private String error;
    private int errorInsn;
    private final String owner;
    private final Map<Label, Integer> lineNumbers;
    private final DecompilerOptions options;
    private final int access;

    public DecompiledMethod(String owner, Map<Label, Integer> lineNumbers, MethodNode meth, DecompilerOptions options, int access) {
        this.meth = meth;
        this.owner = owner;
        this.lineNumbers = lineNumbers;
        this.options = options;
        this.access = access;
        this.text = new ArrayList<Object>();
        this.localVariables = meth.localVariables;
        this.sourceLines = new HashMap<Integer, Integer>();
        this.decompiledLines = new HashMap<Integer, Integer>();
        this.insns = new HashMap<Integer, Integer>();
        this.opcodes = new HashMap<Integer, Integer>();
        this.insnLines = new HashMap<Integer, Integer>();
    }

    void setText(List inputText) {
        this.formatText(inputText, new HashMap<Integer, String>(), new StringBuffer(), this.text);
        this.computeMaps(this.lineNumbers);
        if (this.options.modes.get(8) && (this.access & 0x400) == 0) {
            this.analyzeMethod(this.options.cl);
        }
    }

    void addLineNumber(Label start, Integer integer) {
        this.lineNumbers.put(start, integer);
    }

    public boolean isInit() {
        return "<init>".equals(this.meth.name) && "()V".equals(this.meth.desc) || "<clinit>".equals(this.meth.name);
    }

    public boolean hasSourceLinesInfo() {
        return !this.sourceLines.isEmpty();
    }

    public boolean hasLocalVariablesInfo() {
        return !this.localVariables.isEmpty();
    }

    public String getSignature() {
        return this.meth.name + this.meth.desc;
    }

    public boolean containsSource(int sourceLine) {
        return sourceLine >= this.getFirstSourceLine() && sourceLine <= this.getLastSourceLine();
    }

    public int getBestDecompiledLine(int sourceLine) {
        if (!this.containsSource(sourceLine)) {
            return -1;
        }
        Set<Integer> set = this.decompiledLines.keySet();
        if (set.size() == 0) {
            return -1;
        }
        int bestMatch = -1;
        for (int line : set) {
            int delta = sourceLine - line;
            if (delta < 0) continue;
            if (delta == 0) {
                return line;
            }
            if (bestMatch >= 0 && delta >= sourceLine - bestMatch) continue;
            bestMatch = line;
        }
        if (bestMatch < 0) {
            return -1;
        }
        return this.decompiledLines.get(bestMatch);
    }

    private void analyzeMethod(final ClassLoader cl) {
        Analyzer a = new Analyzer((Interpreter)new SimpleVerifier(){

            protected Class getClass(Type t) {
                try {
                    if (t.getSort() == 9) {
                        return Class.forName(t.getDescriptor().replace('/', '.'), true, cl);
                    }
                    return cl.loadClass(t.getClassName());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e.toString() + " " + cl, e);
                }
            }
        });
        try {
            a.analyze(this.owner, this.meth);
        }
        catch (AnalyzerException e) {
            this.error = e.getMessage();
            if (this.error.startsWith("Error at instruction ")) {
                this.error = this.error.substring("Error at instruction ".length());
                this.errorInsn = Integer.parseInt(this.error.substring(0, this.error.indexOf(58)));
                this.error = this.error.substring(this.error.indexOf(58) + 2);
            }
            BytecodeOutlinePlugin.log(e, 4);
            this.error = null;
        }
        this.frames = a.getFrames();
    }

    private void formatText(List input, Map<Integer, String> locals, StringBuffer line, List<Object> result) {
        for (int i = 0; i < input.size(); ++i) {
            int p;
            Object o = input.get(i);
            if (o instanceof List) {
                this.formatText((List)o, locals, line, result);
                continue;
            }
            if (o instanceof Index) {
                result.add(o);
                this.updateLocals((Index)o, locals);
                continue;
            }
            if (o instanceof Integer) {
                Index index;
                String localVariableName = locals.get(o);
                if (localVariableName == null && (index = DecompiledMethod.getNextIndex(input, i)) != null) {
                    this.updateLocals(index, locals);
                    localVariableName = locals.get(o);
                }
                if (localVariableName == null) continue;
                line.append(": ").append(localVariableName);
                continue;
            }
            String s = o.toString();
            do {
                if ((p = s.indexOf(10)) == -1) {
                    line.append(s);
                    continue;
                }
                result.add(line.toString() + s.substring(0, p + 1));
                s = s.substring(p + 1);
                line.setLength(0);
            } while (p != -1);
        }
    }

    private static Index getNextIndex(List input, int startOffset) {
        for (int i = startOffset + 1; i < input.size(); ++i) {
            Object object = input.get(i);
            if (!(object instanceof Index)) continue;
            return (Index)object;
        }
        return null;
    }

    private void updateLocals(Index index, Map<Integer, String> locals) {
        for (int i = 0; i < this.localVariables.size(); ++i) {
            LocalVariableNode lvNode = (LocalVariableNode)this.localVariables.get(i);
            if (lvNode.start == index.labelNode) {
                locals.put(lvNode.index, lvNode.name);
                continue;
            }
            if (lvNode.end != index.labelNode) continue;
            locals.remove(lvNode.index);
        }
    }

    private void computeMaps(Map<Label, Integer> lineNumbers1) {
        int currentDecompiledLine = 0;
        int firstLine = -1;
        int lastLine = -1;
        for (int i = 0; i < this.text.size(); ++i) {
            int currentOpcode = -1;
            int currentInsn1 = -1;
            int currentSourceLine = -1;
            Object o = this.text.get(i);
            if (o instanceof Index) {
                Index index = (Index)o;
                Integer sourceLine = null;
                if (index.labelNode != null) {
                    sourceLine = lineNumbers1.get(index.labelNode.getLabel());
                }
                if (sourceLine != null) {
                    currentSourceLine = sourceLine;
                    if (firstLine == -1 || currentSourceLine < firstLine) {
                        firstLine = currentSourceLine;
                    }
                    if (lastLine == -1 || currentSourceLine > lastLine) {
                        lastLine = currentSourceLine;
                    }
                }
                currentInsn1 = index.insn;
                currentOpcode = index.opcode;
            } else {
                ++currentDecompiledLine;
            }
            Integer cdl = currentDecompiledLine;
            Integer ci = currentInsn1;
            Integer co = currentOpcode;
            if (currentSourceLine >= 0) {
                Integer csl = currentSourceLine;
                this.sourceLines.put(cdl, csl);
                if (this.decompiledLines.get(csl) == null) {
                    this.decompiledLines.put(csl, cdl);
                }
            }
            this.insns.put(cdl, ci);
            this.opcodes.put(cdl, co);
            if (this.insnLines.get(ci) != null) continue;
            this.insnLines.put(ci, cdl);
        }
        this.lineCount = currentDecompiledLine;
        this.firstSourceLine = firstLine;
        this.lastSourceLine = lastLine;
    }

    public String getText() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.text.size(); ++i) {
            Object o = this.text.get(i);
            if (o instanceof Index) continue;
            buf.append((String)o);
        }
        return buf.toString();
    }

    public String[][] getTextTable() {
        Frame frame = null;
        String error1 = "";
        ArrayList<String[]> lines = new ArrayList<String[]>();
        String offsStr = null;
        for (int i = 0; i < this.text.size(); ++i) {
            Object o = this.text.get(i);
            if (o instanceof Index) {
                Index index = (Index)o;
                int insn = index.insn;
                offsStr = "" + insn;
                if (this.frames == null || insn >= this.frames.length) continue;
                frame = this.frames[insn];
                if (this.error == null || insn != this.errorInsn) continue;
                error1 = this.error;
                continue;
            }
            if (offsStr == null) {
                offsStr = "";
            }
            String locals = " ";
            String stack = " ";
            if (frame != null) {
                StringBuffer buf = new StringBuffer();
                DecompiledMethod.appendFrame(buf, frame);
                int p = buf.indexOf(" ");
                locals = buf.substring(0, p);
                if ("".equals(locals)) {
                    locals = " ";
                }
                if ("".equals(stack = buf.substring(p + 1))) {
                    stack = " ";
                }
            }
            lines.add(new String[]{offsStr, locals, stack, o.toString(), error1});
            frame = null;
            error1 = "";
            offsStr = null;
        }
        return (String[][])lines.toArray((T[])new String[lines.size()][]);
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public String getError() {
        return this.error;
    }

    public int getErrorLine() {
        if (this.error == null) {
            return -1;
        }
        Integer i = this.insnLines.get(this.errorInsn);
        return i == null ? -1 : i;
    }

    private static void appendFrame(StringBuffer buf, Frame f) {
        try {
            int i;
            for (i = 0; i < f.getLocals(); ++i) {
                DecompiledMethod.appendValue(buf, f.getLocal(i));
            }
            buf.append(' ');
            for (i = 0; i < f.getStackSize(); ++i) {
                DecompiledMethod.appendValue(buf, f.getStack(i));
            }
        }
        catch (IndexOutOfBoundsException e) {
            BytecodeOutlinePlugin.log(e, 4);
        }
    }

    private static void appendValue(StringBuffer buf, Value v) {
        if (((BasicValue)v).isReference()) {
            buf.append("R");
        } else {
            buf.append(v.toString());
        }
    }

    public int getFirstSourceLine() {
        return this.firstSourceLine;
    }

    public int getLastSourceLine() {
        return this.lastSourceLine;
    }

    public int getSourceLine(int decompiledLine) {
        Integer i = this.sourceLines.get(decompiledLine);
        return i == null ? -1 : i;
    }

    public String[] getFrame(int decompiledLine, boolean useQualifiedNames) {
        Integer insn = this.getBytecodeOffset(decompiledLine);
        if (this.error != null && insn != null && insn == this.errorInsn) {
            return new String[]{this.error, this.error};
        }
        if (this.frames != null && insn != null) {
            Frame f = this.frames[insn];
            if (f == null) {
                return null;
            }
            try {
                StringBuffer localsBuf = new StringBuffer();
                for (int i = 0; i < f.getLocals(); ++i) {
                    String s = f.getLocal(i).toString();
                    DecompiledMethod.appendTypeName(i, useQualifiedNames, localsBuf, s);
                    for (LocalVariableNode lvnode : this.localVariables) {
                        int n = lvnode.index;
                        if (n != i) continue;
                        localsBuf.append(" : ").append(lvnode.name);
                    }
                    localsBuf.append('\n');
                }
                StringBuffer stackBuf = new StringBuffer();
                for (int i = 0; i < f.getStackSize(); ++i) {
                    String s = f.getStack(i).toString();
                    DecompiledMethod.appendTypeName(i, useQualifiedNames, stackBuf, s);
                    stackBuf.append('\n');
                }
                return new String[]{localsBuf.toString(), stackBuf.toString()};
            }
            catch (IndexOutOfBoundsException e) {
                BytecodeOutlinePlugin.log(e, 4);
            }
        }
        return null;
    }

    public Integer getBytecodeOffset(int decompiledLine) {
        Integer insn = this.insns.get(decompiledLine);
        return insn;
    }

    public Integer getBytecodeInsn(int decompiledLine) {
        Integer insn = this.opcodes.get(decompiledLine);
        return insn;
    }

    public String[][][] getFrameTables(int decompiledLine, boolean useQualifiedNames) {
        Integer insn = this.getBytecodeOffset(decompiledLine);
        if (insn == null) {
            return null;
        }
        return this.getFrameTablesForInsn(insn, useQualifiedNames);
    }

    public String[][][] getFrameTablesForInsn(int insn, boolean useQualifiedNames) {
        if (this.error != null && insn == this.errorInsn) {
            return null;
        }
        if (this.frames != null && insn >= 0 && insn < this.frames.length) {
            Frame f = this.frames[insn];
            if (f == null) {
                return null;
            }
            try {
                ArrayList<String[]> locals = new ArrayList<String[]>();
                for (int i = 0; i < f.getLocals(); ++i) {
                    String varName = "";
                    for (LocalVariableNode lvnode : this.localVariables) {
                        int n = lvnode.index;
                        if (n != i) continue;
                        varName = lvnode.name;
                        break;
                    }
                    locals.add(new String[]{"" + i, DecompiledMethod.getTypeName(useQualifiedNames, f.getLocal(i).toString()), varName});
                }
                ArrayList<String[]> stack = new ArrayList<String[]>();
                for (int i = 0; i < f.getStackSize(); ++i) {
                    stack.add(new String[]{"" + i, DecompiledMethod.getTypeName(useQualifiedNames, f.getStack(i).toString())});
                }
                return new String[][][]{(String[][])locals.toArray((T[])new String[3][]), (String[][])stack.toArray((T[])new String[2][])};
            }
            catch (IndexOutOfBoundsException e) {
                BytecodeOutlinePlugin.log(e, 4);
            }
        }
        return null;
    }

    private static void appendTypeName(int n, boolean useQualifiedNames, StringBuffer buf, String s) {
        int idx;
        buf.append(n).append(" ");
        if (!useQualifiedNames && (idx = s.lastIndexOf(47)) > 0) {
            buf.append(s.substring(idx + 1, s.length() - 1));
            return;
        }
        if ("Lnull;".equals(s)) {
            buf.append("null");
        } else {
            buf.append(s);
        }
    }

    private static String getTypeName(boolean useQualifiedNames, String s) {
        if (!useQualifiedNames) {
            String arraySymbols = "";
            while (s.startsWith("[")) {
                arraySymbols = arraySymbols + "[";
                s = s.substring(1);
            }
            int idx = s.lastIndexOf(47);
            if (idx > 0) {
                return arraySymbols + s.substring(idx + 1, s.length() - 1);
            }
            if ("." == s) {
                return arraySymbols + s;
            }
            return arraySymbols + CommentedClassVisitor.getSimpleName(Type.getType((String)s));
        }
        return "Lnull;".equals(s) ? "null" : s;
    }

    public int getDecompiledLine(int sourceLine) {
        Integer i = this.decompiledLines.get(sourceLine);
        return i == null ? -1 : i;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DecompiledMethod)) {
            return false;
        }
        DecompiledMethod another = (DecompiledMethod)o;
        return this.getSignature().equals(another.getSignature()) && (this.owner == null || this.owner.equals(another.owner));
    }

    public int hashCode() {
        return this.getSignature().hashCode() + (this.owner != null ? this.owner.hashCode() : 0);
    }
}

