/*
 * Decompiled with CFR 0.152.
 */
package de.loskutov.bco.editors;

import de.loskutov.bco.BytecodeOutlinePlugin;
import de.loskutov.bco.editors.BytecodeClassFileEditor;
import de.loskutov.bco.editors.BytecodeSourceMapper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.BufferManager;
import org.eclipse.jdt.internal.ui.javaeditor.ClassFileDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class BytecodeDocumentProvider
extends ClassFileDocumentProvider {
    public BytecodeDocumentProvider(BytecodeClassFileEditor classFileEditor) {
    }

    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput, String encoding) throws CoreException {
        if (editorInput instanceof IClassFileEditorInput) {
            IBuffer buffer;
            IClassFile classFile = ((IClassFileEditorInput)editorInput).getClassFile();
            String source = null;
            try {
                source = classFile.getSource();
            }
            catch (JavaModelException e) {
                // empty catch block
            }
            if (source == null && (buffer = BufferManager.getDefaultBufferManager().getBuffer((IOpenable)classFile)) != null) {
                source = buffer.getContents();
            }
            document.set(source);
            return true;
        }
        return super.setDocumentContent(document, editorInput, encoding);
    }

    public IDocument getDocument(Object element) {
        IDocument document = super.getDocument(element);
        if (element instanceof IClassFileEditorInput && BytecodeDocumentProvider.isDebuggerCall()) {
            IClassFileEditorInput input = (IClassFileEditorInput)element;
            return new DocumentProxy4Debugger(document, input.getClassFile());
        }
        return document;
    }

    private static boolean isDebuggerCall() {
        Exception e = new Exception();
        StackTraceElement[] stackTrace = e.getStackTrace();
        boolean stackOk = true;
        for (int i = 2; i < stackTrace.length; ++i) {
            IEditorPart activeEditor;
            StackTraceElement elt = stackTrace[i];
            switch (i) {
                case 2: {
                    stackOk = "getLineInformation".equals(elt.getMethodName()) || "addAnnotation".equals(elt.getMethodName());
                    break;
                }
                case 3: {
                    stackOk = "positionEditor".equals(elt.getMethodName()) || "display".equals(elt.getMethodName());
                    break;
                }
            }
            if (!stackOk || i > 3) {
                return false;
            }
            if (!stackOk || i != 3 || !((activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()) instanceof BytecodeClassFileEditor)) continue;
            BytecodeClassFileEditor editor = (BytecodeClassFileEditor)activeEditor;
            return editor.isDecompiled();
        }
        return false;
    }

    public IRegion getDecompiledLineInfo(IEditorInput input, int decompiledLine) {
        IDocument document = this.getDocument(input);
        try {
            return document.getLineInformation(decompiledLine);
        }
        catch (BadLocationException e) {
            BytecodeOutlinePlugin.log(e, 4);
            return null;
        }
    }

    private static final class DocumentProxy4Debugger
    extends AbstractDocument {
        private final IDocument delegate;
        private final IClassFile cf;

        public DocumentProxy4Debugger(IDocument delegate, IClassFile cf) {
            this.delegate = delegate;
            this.cf = cf;
        }

        public IRegion getLineInformation(int line) throws BadLocationException {
            int decompiledLine;
            BytecodeSourceMapper mapper = BytecodeClassFileEditor.getSourceMapper();
            if (line < -1) {
                decompiledLine = mapper.mapDebuggerToDecompiled(this.cf);
            } else {
                decompiledLine = mapper.mapToDecompiled(line + 1, this.cf);
                if (decompiledLine == -1) {
                    return BytecodeClassFileEditor.checkForInnerClass(line, this.cf);
                }
            }
            return this.delegate.getLineInformation(decompiledLine + 1);
        }
    }
}

