/*
 * Decompiled with CFR 0.152.
 */
package de.loskutov.bco.ui.actions;

import de.loskutov.bco.BytecodeOutlinePlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class DefaultToggleAction
extends Action
implements IPropertyChangeListener {
    private static final String ACTION = "action";
    boolean avoidUpdate;
    private final IPreferenceStore store;

    public DefaultToggleAction(String id) {
        this(id, true);
    }

    public DefaultToggleAction(String id, boolean addPreferenceListener) {
        this.setId(id);
        this.init();
        IPreferenceStore prefStore = BytecodeOutlinePlugin.getDefault().getPreferenceStore();
        boolean isChecked = prefStore.getBoolean(id);
        this.setChecked(isChecked);
        if (addPreferenceListener) {
            this.store = prefStore;
            prefStore.addPropertyChangeListener((IPropertyChangeListener)this);
        } else {
            this.store = null;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.store == null) {
            return;
        }
        String id = this.getId();
        if (!id.equals(event.getProperty())) {
            return;
        }
        boolean isChecked = this.store.getBoolean(id);
        this.setChecked(isChecked);
        if (!this.avoidUpdate) {
            this.run(isChecked);
        }
    }

    public void dispose() {
        if (this.store != null) {
            this.store.removePropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    private void init() {
        String myId = this.getId();
        if (myId != null && myId.startsWith("diff_")) {
            myId = myId.substring("diff_".length());
        }
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)BytecodeOutlinePlugin.getDefault().getBundle().getSymbolicName(), (String)BytecodeOutlinePlugin.getResourceString("action." + myId + "." + "image")));
        this.setText(BytecodeOutlinePlugin.getResourceString("action." + myId + "." + "text"));
        this.setToolTipText(BytecodeOutlinePlugin.getResourceString("action." + myId + "." + "toolTipText"));
    }

    public final void run() {
        boolean isChecked = this.isChecked();
        this.avoidUpdate = true;
        BytecodeOutlinePlugin.getDefault().getPreferenceStore().setValue(this.getId(), isChecked);
        this.avoidUpdate = false;
        this.run(isChecked);
    }

    public abstract void run(boolean var1);
}

