/*
 * Decompiled with CFR 0.152.
 */
package de.loskutov.bco.views;

import de.loskutov.bco.BytecodeOutlinePlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;

class BCOViewSelectionProvider
implements IPostSelectionProvider {
    private IPostSelectionProvider realProvider;
    private final List<IPostSelectionProvider> selProviders = new ArrayList<IPostSelectionProvider>();
    private ISelection selection;

    public void setCurrentSelectionProvider(IPostSelectionProvider provider) {
        if (!this.selProviders.contains(provider)) {
            BytecodeOutlinePlugin.log(new Exception("Current selection provider is not registered yet"), 2);
            return;
        }
        this.realProvider = provider;
        if (this.selection != null) {
            this.realProvider.setSelection(this.selection);
        }
    }

    public void registerSelectionProvider(IPostSelectionProvider provider) {
        if (!this.selProviders.contains(provider)) {
            this.selProviders.add(provider);
        }
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        for (int i = 0; i < this.selProviders.size(); ++i) {
            IPostSelectionProvider provider = this.selProviders.get(i);
            provider.addPostSelectionChangedListener(listener);
        }
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        for (int i = 0; i < this.selProviders.size(); ++i) {
            IPostSelectionProvider provider = this.selProviders.get(i);
            provider.removePostSelectionChangedListener(listener);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        for (int i = 0; i < this.selProviders.size(); ++i) {
            IPostSelectionProvider provider = this.selProviders.get(i);
            provider.addSelectionChangedListener(listener);
        }
    }

    public ISelection getSelection() {
        return this.realProvider != null ? this.realProvider.getSelection() : null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        for (int i = 0; i < this.selProviders.size(); ++i) {
            IPostSelectionProvider provider = this.selProviders.get(i);
            provider.removeSelectionChangedListener(listener);
        }
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        if (this.realProvider != null) {
            this.realProvider.setSelection(selection);
        }
    }
}

