/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.problem;

import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.problem.IProblemRechecker;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.GuardPredicateDeclaration;

public class ProblemHandler {
    public static final String[] NoArgument = CharOperation.NO_STRINGS;
    public final IErrorHandlingPolicy policy;
    public final IProblemFactory problemFactory;
    public final CompilerOptions options;
    public IProblemRechecker rechecker;

    public ProblemHandler(IErrorHandlingPolicy policy, CompilerOptions options, IProblemFactory problemFactory) {
        this.policy = policy;
        this.problemFactory = problemFactory;
        this.options = options;
    }

    public int computeSeverity(int problemId) {
        return 1;
    }

    public CategorizedProblem createProblem(char[] fileName, int problemId, String[] problemArguments, String[] messageArguments, int severity, int problemStartPosition, int problemEndPosition, int lineNumber, int columnNumber) {
        return this.problemFactory.createProblem(fileName, problemId, problemArguments, messageArguments, severity, problemStartPosition, problemEndPosition, lineNumber, columnNumber);
    }

    public CategorizedProblem createProblem(char[] fileName, int problemId, String[] problemArguments, int elaborationId, String[] messageArguments, int severity, int problemStartPosition, int problemEndPosition, int lineNumber, int columnNumber) {
        return this.problemFactory.createProblem(fileName, problemId, problemArguments, elaborationId, messageArguments, severity, problemStartPosition, problemEndPosition, lineNumber, columnNumber);
    }

    public void handle(int problemId, String[] problemArguments, int elaborationId, String[] messageArguments, int severity, int problemStartPosition, int problemEndPosition, ReferenceContext referenceContext, CompilationResult unitResult) {
        try {
            this.protectedHandle(problemId, problemArguments, elaborationId, messageArguments, severity, problemStartPosition, problemEndPosition, referenceContext, unitResult);
        }
        finally {
            this.rechecker = null;
        }
    }

    private void protectedHandle(int problemId, String[] problemArguments, int elaborationId, String[] messageArguments, int severity, int problemStartPosition, int problemEndPosition, ReferenceContext referenceContext, CompilationResult unitResult) {
        int n;
        if (severity == 256) {
            return;
        }
        boolean requireRecheck = this.rechecker != null;
        boolean markGenerated = false;
        if (referenceContext instanceof AbstractMethodDeclaration) {
            ReferenceBinding clazz;
            AbstractMethodDeclaration method = (AbstractMethodDeclaration)referenceContext;
            if (method.isCopied || method.isGenerated && method.isMappingWrapper == AbstractMethodDeclaration.WrapperKind.NONE && !(method instanceof GuardPredicateDeclaration)) {
                boolean alreadyReported;
                boolean bl = alreadyReported = (severity & 1) != 0 ? method.compilationResult().hasErrors() : method.compilationResult().hasWarnings();
                if (alreadyReported && !requireRecheck) {
                    if ((severity & 0x80) != 0) {
                        referenceContext.tagAsHavingErrors();
                    }
                    return;
                }
            } else if (method.binding != null && (clazz = method.binding.declaringClass) != null && clazz.isRole() && !clazz.isRegularInterface() && unitResult.problemCount > 0 && unitResult.problems != null) {
                CategorizedProblem[] categorizedProblemArray = unitResult.problems;
                int n2 = unitResult.problems.length;
                int n3 = 0;
                while (n3 < n2) {
                    CategorizedProblem prob = categorizedProblemArray[n3];
                    if (prob != null && prob.getID() == problemId && prob.getSourceStart() == problemStartPosition && prob.getSourceEnd() == problemEndPosition) {
                        if ((severity & 1) != 0) {
                            method.tagAsHavingErrors();
                            return;
                        }
                        markGenerated = true;
                    }
                    ++n3;
                }
            }
        }
        if (referenceContext instanceof TypeDeclaration && ((TypeDeclaration)referenceContext).isPurelyCopied) {
            switch (problemId) {
                case 1103101: 
                case 1103102: 
                case 1103103: 
                case 1103202: 
                case 1104001: 
                case 1105001: 
                case 1105004: 
                case 1201001: 
                case 1201002: 
                case 1201003: 
                case 1201004: 
                case 1201202: 
                case 1203401: 
                case 1203402: 
                case 1205001: 
                case 1205002: {
                    break;
                }
                case 2100008: {
                    break;
                }
                default: {
                    return;
                }
            }
        }
        if (unitResult != null && problemStartPosition > unitResult.sourceEndPos) {
            problemStartPosition = 0;
            problemEndPosition = 0;
        }
        if (referenceContext == null) {
            if ((severity & 1) != 0) {
                CategorizedProblem problem = this.createProblem(null, problemId, problemArguments, elaborationId, messageArguments, severity, 0, 0, 0, 0);
                throw new AbortCompilation(null, problem);
            }
            return;
        }
        if (problemStartPosition >= 0) {
            int[] lineEnds = unitResult.getLineSeparatorPositions();
            n = Util.getLineNumber(problemStartPosition, lineEnds, 0, lineEnds.length - 1);
        } else {
            n = 0;
        }
        int lineNumber = n;
        int columnNumber = problemStartPosition >= 0 ? Util.searchColumnNumber(unitResult.getLineSeparatorPositions(), lineNumber, problemStartPosition) : 0;
        CategorizedProblem problem = this.createProblem(unitResult.getFileName(), problemId, problemArguments, elaborationId, messageArguments, severity, problemStartPosition, problemEndPosition, lineNumber, columnNumber);
        if (problem instanceof DefaultProblem) {
            DefaultProblem defaultProblem = (DefaultProblem)problem;
            defaultProblem.rechecker = this.rechecker;
            if (markGenerated) {
                defaultProblem.markGenerated();
            }
        }
        if (problem == null) {
            return;
        }
        switch (severity & 1) {
            case 1: {
                int abortLevel;
                this.record(problem, unitResult, referenceContext);
                if ((severity & 0x80) == 0) break;
                if (!requireRecheck) {
                    referenceContext.tagAsHavingErrors();
                }
                if ((abortLevel = this.policy.stopOnFirstError() ? 2 : severity & 0x1E) == 0) break;
                referenceContext.abort(abortLevel, problem);
                break;
            }
            case 0: {
                this.record(problem, unitResult, referenceContext);
            }
        }
    }

    public void handle(int problemId, String[] problemArguments, String[] messageArguments, int problemStartPosition, int problemEndPosition, ReferenceContext referenceContext, CompilationResult unitResult) {
        this.handle(problemId, problemArguments, 0, messageArguments, this.computeSeverity(problemId), problemStartPosition, problemEndPosition, referenceContext, unitResult);
    }

    public void record(CategorizedProblem problem, CompilationResult unitResult, ReferenceContext referenceContext) {
        unitResult.record(problem, referenceContext);
    }
}

