/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.control;

import java.util.Stack;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.ILogger;

public class Config {
    Object client;
    Parser parser;
    Parser plainParser;
    LookupEnvironment lookupEnvironment;
    public boolean verifyMethods;
    boolean analyzeCode;
    boolean generateCode;
    boolean buildFieldsAndMethods;
    boolean bundledCompleteTypeBindings = false;
    boolean strictDiet;
    public boolean ignoreMissingBytecode = false;
    ReferenceBinding castRequired = null;
    boolean loweringRequired = false;
    boolean loweringPossible = false;
    boolean sourceTypeRequired = false;
    private static final ThreadLocal<Stack<Config>> _configs = new ThreadLocal();
    private static ILogger logger = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConfig(Config config) {
        ThreadLocal<Stack<Config>> threadLocal = _configs;
        synchronized (threadLocal) {
            Stack<Config> configStack = _configs.get();
            if (configStack == null) {
                configStack = new Stack();
                _configs.set(configStack);
            } else assert (!configStack.empty());
            configStack.push(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Config createOrResetConfig(Object client) {
        ThreadLocal<Stack<Config>> threadLocal = _configs;
        synchronized (threadLocal) {
            Stack<Config> configStack;
            block5: {
                configStack = _configs.get();
                if (configStack != null) break block5;
                configStack = new Stack();
                _configs.set(configStack);
                Config config = new Config();
                config.client = client;
                configStack.push(config);
                return null;
            }
            assert (!configStack.empty());
            Config existing = configStack.peek();
            Config clone = new Config();
            clone.castRequired = existing.castRequired;
            clone.loweringRequired = existing.loweringRequired;
            clone.loweringPossible = existing.loweringPossible;
            existing.castRequired = null;
            existing.loweringRequired = false;
            existing.loweringPossible = false;
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restoreConfig(Config storedConfig) {
        ThreadLocal<Stack<Config>> threadLocal = _configs;
        synchronized (threadLocal) {
            Stack<Config> configStack = _configs.get();
            if (configStack != null) {
                Config config = configStack.peek();
                config.castRequired = storedConfig.castRequired;
                config.loweringRequired = storedConfig.loweringRequired;
                config.loweringPossible = storedConfig.loweringPossible;
            }
        }
    }

    public static void removeOrRestore(Config storedConfig, Object client) {
        if (storedConfig == null) {
            Config.removeConfig(client);
        } else {
            Config.restoreConfig(storedConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConfig(Object client) {
        ThreadLocal<Stack<Config>> threadLocal = _configs;
        synchronized (threadLocal) {
            Stack<Config> configStack = _configs.get();
            assert (configStack != null);
            if (configStack != null) {
                Config config = configStack.pop();
                assert (config != null);
                if (config.client != client && config.client != null) {
                    assert (false);
                    configStack.push(config);
                }
                if (configStack.empty()) {
                    _configs.set(null);
                }
            }
        }
    }

    public static Config getConfig() {
        return Config.getConfig(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Config getConfig(boolean logError) {
        if (_configs == null) {
            InternalCompilerError.log("Dependencies has no _configs");
            return null;
        }
        ThreadLocal<Stack<Config>> threadLocal = _configs;
        synchronized (threadLocal) {
            Stack<Config> configStack;
            block6: {
                configStack = _configs.get();
                if (configStack != null) break block6;
                if (logError) {
                    InternalCompilerError.log("Dependencies not configured");
                }
                return null;
            }
            return configStack.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Config safeGetConfig() {
        if (_configs == null) {
            return null;
        }
        ThreadLocal<Stack<Config>> threadLocal = _configs;
        synchronized (threadLocal) {
            Stack<Config> configStack;
            block5: {
                configStack = _configs.get();
                if (configStack != null) break block5;
                return null;
            }
            return configStack.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasConfig() {
        if (_configs == null) {
            return false;
        }
        ThreadLocal<Stack<Config>> threadLocal = _configs;
        synchronized (threadLocal) {
            return _configs.get() != null;
        }
    }

    static boolean getVerifyMethods() {
        return Config.getConfig().verifyMethods;
    }

    static boolean getAnalyzeCode() {
        return Config.getConfig().analyzeCode;
    }

    static boolean getGenerateCode() {
        return Config.getConfig().generateCode;
    }

    public static void setCastRequired(ReferenceBinding castType) {
        Config config = Config.getConfig();
        config.castRequired = config.castRequired != null && castType != null ? SourceTypeBinding.MultipleCasts : castType;
    }

    public static ReferenceBinding getCastRequired() {
        return Config.getConfig().castRequired;
    }

    public static void setLoweringRequired(boolean val) {
        Config.getConfig().loweringRequired = val;
    }

    public static boolean getLoweringRequired() {
        return Config.getConfig().loweringRequired;
    }

    public static void setLoweringPossible(boolean val) {
        Config.getConfig().loweringPossible = val;
    }

    public static boolean getLoweringPossible() {
        return Config.getConfig().loweringPossible;
    }

    public static boolean requireTypeAdjustment() {
        boolean result = Config.getCastRequired() != null || Config.getLoweringRequired();
        Config.setCastRequired(null);
        Config.setLoweringRequired(false);
        return result;
    }

    public static void setSourceTypeRequired(boolean val) {
        Config.getConfig().sourceTypeRequired = val;
    }

    public static boolean getSourceTypeRequired() {
        Config config = Config.getConfig(false);
        return config != null && config.sourceTypeRequired;
    }

    public static LookupEnvironment getLookupEnvironment() throws NotConfiguredException {
        Config current = Config.getConfig();
        if (current == null) {
            throw new NotConfiguredException("LookupEnvironment not configured");
        }
        return current.lookupEnvironment();
    }

    protected LookupEnvironment lookupEnvironment() {
        return this.lookupEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasLookupEnvironment() {
        if (_configs == null) {
            return false;
        }
        ThreadLocal<Stack<Config>> threadLocal = _configs;
        synchronized (threadLocal) {
            block5: {
                if (Config.hasConfig()) break block5;
                return false;
            }
            Config config = Config.getConfig();
            return config != null && config.lookupEnvironment != null;
        }
    }

    static boolean getBuildFieldsAndMethods() {
        return Config.getConfig().buildFieldsAndMethods;
    }

    public static void assertBuildFieldsAndMethods(boolean flag) {
        assert (flag == Config.getBuildFieldsAndMethods());
    }

    public static boolean getStrictDiet() {
        return Config.getConfig().strictDiet;
    }

    public static Parser getParser() {
        return Config.getConfig().parser();
    }

    protected Parser parser() {
        return this.parser;
    }

    public static void delegateGetMethodBodies(CompilationUnitDeclaration unit) {
        Config config = Config.getConfig();
        Parser parser = config.parser();
        if (config.client instanceof ITypeRequestor) {
            if (config.plainParser == null) {
                config.plainParser = ((ITypeRequestor)config.client).getPlainParser();
            }
            if (config.plainParser != null) {
                parser = config.plainParser;
            }
        }
        parser.getMethodBodies(unit);
    }

    public static boolean areStatementsAcceptable(ConstructorDeclaration cd, boolean hasExplicitConstructorCall, ProblemReporter problemReporter) {
        if (!cd.isGenerated) {
            throw new InternalCompilerError("generated statements in non-generated constructor " + cd.toString());
        }
        if (hasExplicitConstructorCall) {
            if (cd.scope != null) {
                problemReporter.explicitSuperInLiftConstructor(cd.scope.referenceType(), cd);
            }
            return false;
        }
        return true;
    }

    public static boolean clientIsCompiler() {
        Config config = Config.getConfig();
        return config != null && config.client instanceof Compiler;
    }

    public static boolean clientIsBatchCompiler() {
        Config config = Config.safeGetConfig();
        return config != null && config.client instanceof Compiler && ((Compiler)config.client).isBatchCompiler;
    }

    public boolean setBundledCompleteTypeBindingsMode(boolean mode) {
        boolean save = this.bundledCompleteTypeBindings;
        this.bundledCompleteTypeBindings = mode;
        return save;
    }

    public static boolean getBundledCompleteTypeBindingsMode() {
        Config config = Config.getConfig();
        return config.bundledCompleteTypeBindings;
    }

    public static synchronized void setLogger(ILogger aLogger) {
        logger = aLogger;
    }

    public static synchronized void logException(String message, Throwable exception) {
        if (logger != null) {
            logger.logException(message, exception);
        } else {
            System.err.println("OT/J: " + message);
        }
        exception.printStackTrace(System.err);
    }

    public static class NotConfiguredException
    extends RuntimeException {
        public NotConfiguredException(String string) {
            super(string);
        }

        public void logWarning(String msg) {
            try {
                JavaCore.getJavaCore().getLog().log((IStatus)new Status(2, "org.eclipse.jdt.core", msg, (Throwable)this));
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.err.println("Warning: " + msg);
                this.printStackTrace(System.err);
            }
        }
    }
}

