/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.TeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.RoleTypeCreator;

public class TThisBinding
extends FieldBinding {
    public TThisBinding(ReferenceBinding teamBinding) {
        super(IOTConstants.TTHIS, teamBinding, 16, teamBinding, Constant.NotAConstant);
    }

    protected TeamAnchor getClone() {
        return new TThisBinding((ReferenceBinding)this.type);
    }

    public static VariableBinding getTThisForRole(ReferenceBinding role) {
        if (role == null) {
            return null;
        }
        if (role.isDirectRole()) {
            return role.enclosingType().getTeamModel().getTThis();
        }
        return null;
    }

    public static VariableBinding getTThisForRole(ReferenceBinding role, ReferenceBinding site) {
        role = RoleTypeCreator.findExactRole(role, site);
        return TThisBinding.getTThisForRole(role);
    }

    public String toString() {
        return new String(this.readableName());
    }

    public char[] readableName() {
        if (this.name != IOTConstants.TTHIS) {
            return this.name;
        }
        char[] tmp = CharOperation.concat(this.name, this.type.sourceName(), '[');
        return CharOperation.append(tmp, ']');
    }

    public ITeamAnchor setPathPrefix(ITeamAnchor prefix) {
        assert (prefix.getResolvedType().isCompatibleWith(this.type));
        return prefix;
    }
}

