/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.MethodInfo;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.BytecodeTransformer;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.ConstantPoolObject;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.ConstantPoolObjectMapper;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.ConstantPoolObjectReader;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Dependencies;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstEdit;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;

public class TeamMethodGenerator {
    static final char[][] JAVA_LANG_WEAKHASHMAP = new char[][]{"java".toCharArray(), "util".toCharArray(), "WeakHashMap".toCharArray()};
    static final char[][] JAVA_LANG_THREAD = new char[][]{"java".toCharArray(), "lang".toCharArray(), "Thread".toCharArray()};
    static final char[][] JAVA_LANG_THREADLOCAL = new char[][]{"java".toCharArray(), "lang".toCharArray(), "ThreadLocal".toCharArray()};
    final MethodDescriptor[] methodDescriptors = new MethodDescriptor[]{new MethodDescriptor("activate", "()V", Type.NONE, Type.NONE, 1), new MethodDescriptor("activate", "(Ljava/lang/Thread;)V", Type.THREAD, Type.NONE, 1), new MethodDescriptor("deactivate", "()V", Type.NONE, Type.NONE, 1), new MethodDescriptor("deactivate", "(Ljava/lang/Thread;)V", Type.THREAD, Type.NONE, 1), new MethodDescriptor("isActive", "()Z", Type.NONE, Type.BOOLEAN, 17), new MethodDescriptor("isActive", "(Ljava/lang/Thread;)Z", Type.THREAD, Type.BOOLEAN, 17), new MethodDescriptor("isExecutingCallin", "()Z", Type.NONE, Type.BOOLEAN, 1), new MethodDescriptor("deactivateForEndedThread", "(Ljava/lang/Thread;)V", Type.THREAD, Type.NONE, 1), new MethodDescriptor("internalIsActiveSpecificallyFor", "(Ljava/lang/Thread;)Z", Type.THREAD, Type.BOOLEAN, 1), new MethodDescriptor("_OT$setExecutingCallin", "(Z)Z", Type.BOOLEAN, Type.BOOLEAN, 1), new MethodDescriptor("_OT$activateForAllThreads", "()V", Type.NONE, Type.NONE, 2), new MethodDescriptor("_OT$saveActivationState", "()I", Type.NONE, Type.INT, 33), new MethodDescriptor("_OT$restoreActivationState", "(I)V", Type.INT, Type.NONE, 1), new MethodDescriptor("doRegistration", "()V", Type.NONE, Type.NONE, 2), new MethodDescriptor("doUnregistration", "()V", Type.NONE, Type.NONE, 2)};
    public byte[] classBytes;
    public int[] constantPoolOffsets;
    public SourceTypeBinding ooTeamBinding;

    public void registerTeamMethod(IBinaryMethod method, MethodBinding methodBinding) {
        String selector = String.valueOf(method.getSelector());
        String descriptor = String.valueOf(method.getMethodDescriptor());
        this.registerTeamMethod(methodBinding.declaringClass, methodBinding, selector, descriptor, -1);
    }

    public synchronized void maybeRegisterTeamClassBytes(ClassFileReader teamClass, ReferenceBinding teamClassBinding) {
        if (this.classBytes != null) {
            return;
        }
        this.classBytes = teamClass.getBytes();
        this.constantPoolOffsets = teamClass.getConstantPoolOffsets();
        IBinaryMethod[] iBinaryMethodArray = teamClass.getMethods();
        int n = iBinaryMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBinaryMethod method = iBinaryMethodArray[n2];
            if (this.classBytes == null && method instanceof MethodInfo) {
                this.classBytes = ((MethodInfo)method).reference;
                this.constantPoolOffsets = ((MethodInfo)method).constantPoolOffsets;
            }
            String selector = String.valueOf(method.getSelector());
            String descriptor = String.valueOf(method.getMethodDescriptor());
            int structOffset = ((MethodInfo)method).getStructOffset();
            this.registerTeamMethod(teamClassBinding, null, selector, descriptor, structOffset);
            ++n2;
        }
    }

    private boolean registerTeamMethod(ReferenceBinding declaringClass, MethodBinding methodBinding, String selector, String descriptor, int structOffset) {
        int s = 0;
        while (s < this.methodDescriptors.length) {
            if (selector.equals(this.methodDescriptors[s].selector) && descriptor.equals(this.methodDescriptors[s].signature)) {
                if (methodBinding != null) {
                    this.methodDescriptors[s].binding = methodBinding;
                }
                this.methodDescriptors[s].declaringClass = declaringClass;
                this.methodDescriptors[s].methodCodeOffset = structOffset;
                return true;
            }
            ++s;
        }
        return false;
    }

    public synchronized void registerOOTeamClass(SourceTypeBinding ooTeamBinding) {
        if (this.classBytes != null) {
            return;
        }
        this.ooTeamBinding = ooTeamBinding;
    }

    public boolean requestBytes() {
        if (this.classBytes != null) {
            return true;
        }
        if (this.ooTeamBinding != null) {
            if (this.isOOTConverted()) {
                return false;
            }
            boolean result = Dependencies.ensureBindingState(this.ooTeamBinding, 25);
            MethodModel model = this.methodDescriptors[0].binding.model;
            this.classBytes = model.getBytes();
            this.constantPoolOffsets = model.getConstantPoolOffsets();
            return result;
        }
        return false;
    }

    boolean isOOTConverted() {
        if (this.ooTeamBinding == null) {
            return false;
        }
        ClassScope scope = this.ooTeamBinding.scope;
        if (scope == null) {
            return false;
        }
        TypeDeclaration typeDecl = scope.referenceContext;
        return typeDecl.isConverted;
    }

    public boolean registerSourceMethodBytes(MethodBinding method) {
        String selector = String.valueOf(method.selector);
        String signature = String.valueOf(method.signature());
        return this.registerTeamMethod(method.declaringClass, method, selector, signature, -1);
    }

    public void addMethodsAndFields(TypeDeclaration teamDecl) {
        AstGenerator gen = new AstGenerator(teamDecl);
        boolean hasBoundRole = false;
        Object[] objectArray = teamDecl.getTeamModel().getRoles(false);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            RoleModel role = objectArray[n2];
            if (role.isBound()) {
                hasBoundRole = true;
                break;
            }
            ++n2;
        }
        objectArray = this.methodDescriptors;
        n = this.methodDescriptors.length;
        n2 = 0;
        while (n2 < n) {
            Object methodDescriptor = objectArray[n2];
            MethodDeclaration newMethod = null;
            newMethod = (((MethodDescriptor)methodDescriptor).modifiers & 7) == 1 ? new CopiedTeamMethod(teamDecl.compilationResult, (MethodDescriptor)methodDescriptor, gen) : (hasBoundRole ? new CopiedTeamMethod(teamDecl.compilationResult, (MethodDescriptor)methodDescriptor, gen) : gen.method(teamDecl.compilationResult, ((MethodDescriptor)methodDescriptor).modifiers, ((MethodDescriptor)methodDescriptor).makeReturnRef(gen), ((MethodDescriptor)methodDescriptor).selector.toCharArray(), null, new Statement[0]));
            AstEdit.addGeneratedMethod(teamDecl, newMethod);
            ++n2;
        }
        this.addFields(teamDecl, gen);
    }

    void addFields(TypeDeclaration teamDecl, AstGenerator gen) {
        this.addPrivateField(teamDecl, gen, this.weakHashMapTypeReference(gen), "_OT$activatedThreads".toCharArray(), gen.allocation(this.weakHashMapTypeReference(gen), null));
        this.addPrivateField(teamDecl, gen, gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT), "_OT$registrationLock".toCharArray(), gen.allocation(gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT), null));
        this.addPrivateField(teamDecl, gen, gen.baseTypeReference(TypeConstants.BOOLEAN), "_OT$lazyGlobalActiveFlag".toCharArray(), gen.booleanLiteral(false));
        this.addPrivateField(teamDecl, gen, gen.baseTypeReference(TypeConstants.BOOLEAN), "_OT$isExecutingCallin".toCharArray(), gen.booleanLiteral(false));
        this.addPrivateField(teamDecl, gen, gen.baseTypeReference(TypeConstants.INT), "_OT$registrationState".toCharArray(), gen.intLiteral(0));
        this.addPrivateField(teamDecl, gen, gen.baseTypeReference(TypeConstants.BOOLEAN), "_OT$globalActive".toCharArray(), gen.booleanLiteral(false));
        TypeDeclaration anonThreadLocal = gen.anonymousType(teamDecl.compilationResult);
        anonThreadLocal.methods = new MethodDeclaration[]{gen.method(teamDecl.compilationResult, 36, gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_INTEGER), "initialValue".toCharArray(), null, new Statement[]{gen.returnStatement(gen.intLiteral(0))})};
        this.addPrivateField(teamDecl, gen, this.threadLocalReference(gen), "_OT$implicitActivationsPerThread".toCharArray(), gen.anonymousAllocation(this.threadLocalReference(gen), null, anonThreadLocal));
    }

    void addPrivateField(TypeDeclaration teamDecl, AstGenerator gen, TypeReference type, char[] name, Expression init) {
        FieldDeclaration field = gen.field(2, type, name, init);
        AstEdit.addField(teamDecl, field, true, false);
        field.binding.modifiers |= 0x8000000;
    }

    QualifiedTypeReference weakHashMapTypeReference(AstGenerator gen) {
        return gen.parameterizedQualifiedTypeReference(JAVA_LANG_WEAKHASHMAP, new TypeReference[]{gen.qualifiedTypeReference(JAVA_LANG_THREAD), gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_BOOLEAN)});
    }

    QualifiedTypeReference threadLocalReference(AstGenerator gen) {
        return gen.parameterizedQualifiedTypeReference(JAVA_LANG_THREADLOCAL, new TypeReference[]{gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_INTEGER)});
    }

    public static void addFakedTeamRegistrationMethods(ReferenceBinding teamBinding) {
        MethodBinding registrationMethod = new MethodBinding(1, "_OT$registerAtBases".toCharArray(), TypeBinding.VOID, Binding.NO_PARAMETERS, Binding.NO_EXCEPTIONS, teamBinding);
        teamBinding.addMethod(registrationMethod);
        MethodModel.getModel((MethodBinding)registrationMethod)._fakeKind = MethodModel.FakeKind.TEAM_REGISTRATION_METHOD;
        registrationMethod = new MethodBinding(1, "_OT$unregisterFromBases".toCharArray(), TypeBinding.VOID, Binding.NO_PARAMETERS, Binding.NO_EXCEPTIONS, teamBinding);
        teamBinding.addMethod(registrationMethod);
        MethodModel.getModel((MethodBinding)registrationMethod)._fakeKind = MethodModel.FakeKind.TEAM_REGISTRATION_METHOD;
    }

    class CopiedTeamMethod
    extends MethodDeclaration {
        MethodDescriptor descriptor;

        public CopiedTeamMethod(CompilationResult compilationResult, MethodDescriptor descriptor, AstGenerator gen) {
            super(compilationResult);
            this.selector = descriptor.selector.toCharArray();
            this.descriptor = descriptor;
            this.isCopied = true;
            this.modifiers = descriptor.modifiers;
            this.arguments = descriptor.makeArgs(gen);
            this.returnType = descriptor.makeReturnRef(gen);
        }

        public void resolve(ClassScope upperScope) {
        }

        public void analyseCode(ClassScope classScope, InitializationFlowContext initializationContext, FlowInfo flowInfo) {
        }

        public void generateCode(ClassScope classScope, ClassFile classFile) {
            int structOffset;
            int[] offsets;
            byte[] bytes;
            if (TeamMethodGenerator.this.isOOTConverted()) {
                return;
            }
            this.binding.copyInheritanceSrc = this.descriptor.binding;
            TeamConstantPoolMapper mapper = new TeamConstantPoolMapper(this.descriptor.binding, this.binding);
            if (this.descriptor.methodCodeOffset == -1) {
                MethodModel srcModel = this.descriptor.binding.model;
                bytes = srcModel.getBytes();
                offsets = srcModel.getConstantPoolOffsets();
                structOffset = srcModel.getStructOffset();
            } else {
                bytes = TeamMethodGenerator.this.classBytes;
                offsets = TeamMethodGenerator.this.constantPoolOffsets;
                structOffset = this.descriptor.methodCodeOffset;
            }
            ConstantPoolObjectReader reader = new ConstantPoolObjectReader(bytes, offsets, this.descriptor.declaringClass.getTeamModel(), this.scope.environment());
            new BytecodeTransformer().doCopyMethodCode(null, this.binding, (SourceTypeBinding)this.binding.declaringClass, this, bytes, offsets, structOffset, reader, mapper, classFile);
        }
    }

    static class MethodDescriptor {
        String selector;
        String signature;
        Type args;
        Type returnType;
        int modifiers;
        int methodCodeOffset;
        ReferenceBinding declaringClass;
        MethodBinding binding;

        MethodDescriptor(String selector, String signature, Type args, Type returnType, int modifiers) {
            this.selector = selector;
            this.signature = signature;
            this.args = args;
            this.returnType = returnType;
            this.modifiers = modifiers;
        }

        Argument[] makeArgs(AstGenerator gen) {
            switch (this.args) {
                case THREAD: {
                    return new Argument[]{gen.argument("thread".toCharArray(), gen.qualifiedTypeReference(JAVA_LANG_THREAD))};
                }
                case BOOLEAN: {
                    return new Argument[]{gen.argument("flag".toCharArray(), gen.baseTypeReference(TypeConstants.BOOLEAN))};
                }
                case INT: {
                    return new Argument[]{gen.argument("flags".toCharArray(), gen.baseTypeReference(TypeConstants.INT))};
                }
            }
            return null;
        }

        TypeReference makeReturnRef(AstGenerator gen) {
            switch (this.returnType) {
                case BOOLEAN: {
                    return gen.baseTypeReference(TypeConstants.BOOLEAN);
                }
                case INT: {
                    return gen.baseTypeReference(TypeConstants.INT);
                }
                case NONE: {
                    return gen.baseTypeReference(TypeConstants.VOID);
                }
            }
            throw new InternalCompilerError("Unexpected return type " + (Object)((Object)this.returnType));
        }
    }

    static class TeamConstantPoolMapper
    extends ConstantPoolObjectMapper {
        ReferenceBinding srcType;
        ReferenceBinding dstType;

        public TeamConstantPoolMapper(MethodBinding srcMethodBinding, MethodBinding dstMethodBinding) {
            super(srcMethodBinding, dstMethodBinding);
            this.srcType = srcMethodBinding.declaringClass;
            this.dstType = dstMethodBinding.declaringClass;
        }

        public ConstantPoolObject mapConstantPoolObject(ConstantPoolObject src_cpo, boolean addMarkerArgAllowed) {
            return this.mapConstantPoolObject(src_cpo);
        }

        public ConstantPoolObject mapConstantPoolObject(ConstantPoolObject src_cpo) {
            int type = src_cpo.getType();
            TypeBinding clazz = null;
            switch (type) {
                case 10: {
                    clazz = src_cpo.getMethodRef().declaringClass;
                    break;
                }
                case 9: {
                    clazz = src_cpo.getFieldRef().declaringClass;
                    break;
                }
                case 7: {
                    clazz = src_cpo.getClassObject();
                }
            }
            if (clazz != this.srcType) {
                return src_cpo;
            }
            switch (type) {
                case 9: {
                    return new ConstantPoolObject(9, this.mapField(src_cpo.getFieldRef()));
                }
                case 10: {
                    return new ConstantPoolObject(10, this.mapMethod(src_cpo.getMethodRef()));
                }
                case 7: {
                    return new ConstantPoolObject(7, this.dstType);
                }
            }
            return src_cpo;
        }

        private MethodBinding mapMethod(MethodBinding methodRef) {
            MethodBinding[] methodBindingArray = this.dstType.methods();
            int n = methodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                MethodBinding dstBinding = methodBindingArray[n2];
                if (CharOperation.equals(dstBinding.selector, methodRef.selector) && CharOperation.equals(dstBinding.signature(), methodRef.signature())) {
                    return dstBinding;
                }
                ++n2;
            }
            return methodRef;
        }

        private FieldBinding mapField(FieldBinding fieldRef) {
            FieldBinding[] fieldBindingArray = this.dstType.fields();
            int n = fieldBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                FieldBinding dstBinding = fieldBindingArray[n2];
                if (CharOperation.equals(dstBinding.name, fieldRef.name) && dstBinding.type == fieldRef.type) {
                    return dstBinding;
                }
                ++n2;
            }
            return fieldRef;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        NONE,
        THREAD,
        BOOLEAN,
        INT;

    }
}

