/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;

class Tokenizer
extends StreamTokenizer {
    public static final char TT_SPACE = ' ';
    public static final char TT_QUOTE = '\'';
    public static final char TT_DOUBLE_QUOTE = '\"';
    public static final char TT_COMMA = ',';
    public static final int TT_SYMBOL = -100;
    public static final int TT_SQL_KEYWORD = -200;
    private int tokenType = -1;
    private String token;

    public Tokenizer(String sql) {
        super(new StringReader(sql));
        this.resetSyntax();
        this.wordChars(48, 57);
        this.wordChars(97, 122);
        this.wordChars(65, 90);
        this.wordChars(95, 95);
        this.wordChars(32, 32);
        this.wordChars(39, 39);
        this.wordChars(34, 34);
        this.wordChars(10, 10);
        this.wordChars(13, 13);
        this.wordChars(46, 46);
        this.wordChars(42, 42);
        this.wordChars(47, 47);
        this.eolIsSignificant(false);
    }

    public int nextToken() {
        try {
            this.tokenType = super.nextToken();
            switch (this.tokenType) {
                case -1: {
                    this.tokenType = -1;
                    this.token = null;
                    break;
                }
                case -3: {
                    this.token = this.sval;
                    if (this.isNumeric(this.token)) {
                        this.tokenType = -2;
                    }
                    break;
                }
                case 39: {
                    this.token = "'" + this.sval + "'";
                    break;
                }
                case 34: {
                    this.token = "\"" + this.sval + "\"";
                    break;
                }
                default: {
                    this.token = String.valueOf((char)this.ttype);
                    break;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.tokenType;
    }

    public int getTokenType() {
        return this.tokenType;
    }

    public String getToken() {
        return this.token;
    }

    boolean isNumeric(String text) {
        int i = 0;
        while (i < text.length()) {
            char chr = text.charAt(i);
            if (chr < '0' || chr > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }
}

