/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule.mysql;

import zigen.plugin.db.core.SQLFormatter;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.TablePKColumn;
import zigen.plugin.db.core.rule.DefaultSQLCreatorFactory;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

public class MySQLSQLCreatorFactory
extends DefaultSQLCreatorFactory {
    public MySQLSQLCreatorFactory(ITable table) {
        super(table);
    }

    public String VisibleColumnSizePattern() {
        return ".*CHAR|^VARCHAR.*|^DECIMAL|^FLOAT|^DOUBLE|^REAL|^TIMESTAMP|^TIME|.*VARYING";
    }

    public String[] getSupportColumnType() {
        return new String[]{"TINYINT", "BIT", "BOOL", "BOOLEAN", "SMALLINT", "MEDIUMINT", "INT", "INTEGER", "BIGINT", "FLOAT", "DOUBLE", "DECIMAL", "DEC", "DATE", "DATETIME", "TIMESTAMP", "TIME", "YEAR", "CHAR", "VARCHAR", "TINYBLOB", "TINYTEXT", "BLOB", "TEXT", "MEDIUMBLOB", "MEDIUMTEXT", "LONGBLOB", "LONGTEXT", "ENUM"};
    }

    protected String getConstraintPKStr() {
        StringBuffer sb = new StringBuffer();
        if (this.pks == null || this.pks.length == 0) {
            return null;
        }
        int i = 0;
        i = 0;
        while (i < this.pks.length) {
            TablePKColumn pkc = this.pks[i];
            if (i == 0) {
                this.primaryKeyName = pkc.getName();
                sb.append("CONSTRAINT ");
                sb.append("PRIMARY KEY ");
                sb.append("(");
                sb.append(pkc.getColumnName());
            } else {
                sb.append(", " + pkc.getColumnName());
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public String createSelect(String _condition, int limit) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT * FROM ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        String[] conditions = SQLFormatter.splitOrderCause(_condition);
        String condition = conditions[0];
        String orderBy = conditions[1];
        if (condition != null && !"".equals(condition.trim())) {
            sb.append(" WHERE " + condition);
        }
        if (orderBy != null && !"".equals(orderBy)) {
            sb.append(" " + orderBy);
        }
        if (limit > 0) {
            sb.append(" LIMIT " + (limit + 1));
        }
        return sb.toString();
    }

    public boolean isSupportPager() {
        return true;
    }

    public String createSelectForPager(String _condition, int offset, int limit) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT * FROM ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        String[] conditions = SQLFormatter.splitOrderCause(_condition);
        String condition = conditions[0];
        String orderBy = conditions[1];
        if (condition != null && !"".equals(condition.trim())) {
            sb.append(" WHERE ");
            sb.append(condition);
        }
        if (limit > 0) {
            sb.append(" LIMIT ");
            sb.append(offset - 1);
            sb.append(", ");
            sb.append(limit);
        }
        if (orderBy != null && !"".equals(orderBy)) {
            sb.append(" " + orderBy);
        }
        return sb.toString();
    }

    public String createCommentOnTableDDL(String commnets) {
        return null;
    }

    public String createCommentOnColumnDDL(Column column) {
        return null;
    }

    public String createRenameTableDDL(String newTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        sb.append(" RENAME TO ");
        sb.append(SQLUtil.enclose(newTableName, this.encloseChar));
        return sb.toString();
    }

    public String createRenameColumnDDL(Column from, Column to) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        sb.append(" CHANGE COLUMN ");
        sb.append(SQLUtil.enclose(from.getName(), this.encloseChar));
        sb.append(" ");
        sb.append(SQLUtil.enclose(to.getName(), this.encloseChar));
        sb.append(" ");
        sb.append(to.getTypeName());
        if (this.isVisibleColumnSize(from.getTypeName())) {
            sb.append("(");
            sb.append(from.getSize());
            sb.append(")");
        }
        return sb.toString();
    }

    public String[] createAddColumnDDL(Column column) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        sb.append(" ADD (");
        sb.append(SQLUtil.enclose(column.getName(), this.encloseChar));
        sb.append(" ");
        sb.append(column.getTypeName());
        if (this.isVisibleColumnSize(column.getTypeName())) {
            sb.append("(");
            sb.append(column.getSize());
            sb.append(")");
        }
        if (column.getDefaultValue() != null && !"".equals(column.getDefaultValue())) {
            sb.append(" DEFAULT ");
            sb.append(column.getDefaultValue());
        }
        if (column.isNotNull()) {
            sb.append(" NOT NULL");
        } else {
            sb.append(" NULL");
        }
        sb.append(")");
        return new String[]{sb.toString()};
    }

    public String[] createModifyColumnDDL(Column from, Column to) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        sb.append(" CHANGE COLUMN ");
        sb.append(SQLUtil.enclose(to.getName(), this.encloseChar));
        sb.append(" ");
        sb.append(SQLUtil.enclose(to.getName(), this.encloseChar));
        sb.append(" ");
        sb.append(to.getTypeName());
        if (this.isVisibleColumnSize(to.getTypeName())) {
            sb.append("(");
            sb.append(to.getSize());
            sb.append(")");
        }
        sb.append(" DEFAULT ");
        if ("".equals(to.getDefaultValue())) {
            sb.append("NULL");
        } else {
            sb.append(to.getDefaultValue());
        }
        if (to.isNotNull()) {
            sb.append(" NOT NULL");
        } else {
            sb.append(" NULL");
        }
        return new String[]{sb.toString()};
    }

    public String[] createDropColumnDDL(Column column, boolean cascadeConstraints) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        sb.append(" DROP COLUMN ");
        sb.append(SQLUtil.enclose(column.getName(), this.encloseChar));
        return new String[]{sb.toString()};
    }

    public boolean supportsModifyColumnSize(String columnType) {
        return false;
    }

    public boolean supportsModifyColumnType() {
        return false;
    }

    public boolean supportsRemarks() {
        return false;
    }

    public boolean supportsDropColumnCascadeConstraints() {
        return false;
    }

    public boolean supportsRollbackDDL() {
        return false;
    }

    public String createCreateIndexDDL(String indexName, Column[] columns, int indexType) {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE");
        if (1 == indexType) {
            sb.append(" UNIQUE");
        } else if (2 == indexType) {
            sb.append(" BITMAP");
        }
        sb.append(" INDEX ");
        sb.append(SQLUtil.enclose(indexName, this.encloseChar));
        sb.append(" ON ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        sb.append("(");
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(SQLUtil.enclose(column.getColumn().getColumnName(), this.encloseChar));
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public String createDropIndexDDL(String indexName) {
        StringBuffer sb = new StringBuffer();
        sb.append("DROP INDEX ");
        sb.append(SQLUtil.enclose(indexName, this.encloseChar));
        sb.append(" ON ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        return sb.toString();
    }

    public String createCreateConstraintPKDDL(String constraintName, Column[] columns) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        sb.append(" ADD CONSTRAINT ");
        sb.append(SQLUtil.enclose(constraintName, this.encloseChar));
        sb.append(" PRIMARY KEY");
        sb.append("(");
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(SQLUtil.enclose(column.getColumn().getColumnName(), this.encloseChar));
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public String createCreateConstraintUKDDL(String constraintName, Column[] columns) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        sb.append(" ADD CONSTRAINT ");
        sb.append(SQLUtil.enclose(constraintName, this.encloseChar));
        sb.append(" UNIQUE ");
        sb.append("(");
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(SQLUtil.enclose(column.getColumn().getColumnName(), this.encloseChar));
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public String createCreateConstraintFKDDL(String constraintName, Column[] columns, ITable refTable, Column[] refColumns, boolean onDeleteCascade) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        sb.append(" ADD CONSTRAINT ");
        sb.append(SQLUtil.enclose(constraintName, this.encloseChar));
        sb.append(" FOREIGN KEY");
        sb.append("(");
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(SQLUtil.enclose(column.getColumn().getColumnName(), this.encloseChar));
            ++i;
        }
        sb.append(")");
        sb.append(" REFERENCES ");
        sb.append(this.getTableNameWithSchemaForSQL(refTable, this.isVisibleSchemaName));
        sb.append("(");
        i = 0;
        while (i < refColumns.length) {
            Column refColumn = refColumns[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(SQLUtil.enclose(refColumn.getColumn().getColumnName(), this.encloseChar));
            ++i;
        }
        sb.append(")");
        if (onDeleteCascade) {
            sb.append(" ON DELETE CASCADE");
        }
        return sb.toString();
    }

    public String createDropConstraintDDL(String constraintName, String type) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        if (type.equals("PRIMARY KEY")) {
            sb.append(" DROP PRIMARY KEY");
        } else if (type.equals("FOREGIN KEY")) {
            sb.append(" DROP FOREIGN KEY ");
            sb.append(SQLUtil.enclose(constraintName, this.encloseChar));
        }
        return sb.toString();
    }

    public String createDDL() {
        StringBuffer sb = new StringBuffer();
        String folderName = this.table.getFolderName();
        if ("VIEW".equals(folderName)) {
            sb.append(super.getCreateView());
        } else {
            sb.append(super.getCreateTableStr());
        }
        return sb.toString();
    }

    protected String getViewDDL_SQL(String dbName, String owner, String view) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT");
        sb.append("        view_definition");
        sb.append("    FROM");
        sb.append("        information_schema.views");
        sb.append("    WHERE");
        sb.append("        table_schema = '" + SQLUtil.encodeQuotation(owner) + "'");
        sb.append("        AND table_name = '" + SQLUtil.encodeQuotation(view) + "'");
        return sb.toString();
    }
}

