/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule.symfoware;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.SQLFormatter;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TablePKColumn;
import zigen.plugin.db.core.rule.DefaultSQLCreatorFactory;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

public class SymfowareSQLCreatorFactory
extends DefaultSQLCreatorFactory {
    public SymfowareSQLCreatorFactory(ITable table) {
        super(table);
    }

    public String createSelect(String _condition, int limit) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT * FROM ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        String[] conditions = SQLFormatter.splitOrderCause(_condition);
        String condition = conditions[0];
        String orderBy = conditions[1];
        if (condition != null && !"".equals(condition.trim())) {
            sb.append(" WHERE " + condition);
        }
        if (orderBy != null && !"".equals(orderBy)) {
            sb.append(" " + orderBy);
        }
        if (!sb.toString().trim().endsWith("WITH OPTION LOCK_MODE(NL)")) {
            sb.append(" WITH OPTION LOCK_MODE(NL)");
        }
        return sb.toString();
    }

    public String createCountAll(String condition) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT COUNT(*) FROM ");
        sb.append(this.table.getSqlTableName());
        if (condition != null && !"".equals(condition.trim())) {
            sb.append(" WHERE " + condition);
        }
        sb.append(" WITH OPTION LOCK_MODE(NL)");
        return sb.toString();
    }

    public String createCountForQuery(String query) {
        StringBuffer sb = new StringBuffer();
        sb.append(super.createCountForQuery(query));
        sb.append(" WITH OPTION LOCK_MODE(NL)");
        return sb.toString();
    }

    protected String getCreateView() {
        StringBuffer wk = new StringBuffer();
        try {
            boolean onPatch = DbPlugin.getDefault().getPreferenceStore().getBoolean("SQLEditorPreferencePage.FormatPatch");
            int type = DbPlugin.getDefault().getPreferenceStore().getInt("SQLFormatPreferencePage.UseFormatterType");
            wk.append("CREATE VIEW ");
            wk.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
            wk.append(DbPluginConstant.LINE_SEP);
            wk.append("(");
            int i = 0;
            while (i < this.cols.length) {
                Column col = this.cols[i];
                if (i > 0) {
                    wk.append(",");
                }
                wk.append(col.getName());
                wk.append(DbPluginConstant.LINE_SEP);
                ++i;
            }
            wk.append(")");
            wk.append(DbPluginConstant.LINE_SEP);
            wk.append("AS");
            wk.append(DbPluginConstant.LINE_SEP);
            wk.append(this.getViewDDL(this.table.getDbConfig(), this.table.getSchemaName(), this.table.getName()));
            StringBuffer sb = new StringBuffer();
            sb.append(SQLFormatter.format(wk.toString(), type, onPatch));
            this.setDemiliter(sb);
            return sb.toString();
        }
        catch (Exception e) {
            DbPlugin.log(e);
            return null;
        }
    }

    protected String getViewDDL_SQL(String dbName, String owner, String view) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT");
        sb.append("        D.DESC_VALUE");
        sb.append("    FROM");
        sb.append("        RDBII_SYSTEM.RDBII_TABLE T");
        sb.append("        ,RDBII_SYSTEM.RDBII_DESCRIPTION D");
        sb.append("    WHERE");
        sb.append("        T.DB_CODE = D.DB_CODE");
        sb.append("        AND T.TABLE_CODE = D.OBJECT_CODE");
        sb.append("        AND T.DB_NAME = '" + SQLUtil.encodeQuotation(dbName) + "'");
        sb.append("        AND T.SCHEMA_NAME = '" + SQLUtil.encodeQuotation(owner) + "'");
        sb.append("        AND T.TABLE_NAME = '" + SQLUtil.encodeQuotation(view) + "'");
        sb.append("        AND T.TABLE_TYPE = 'VW'");
        return sb.toString();
    }

    public String[] createAddColumnDDL(Column column) {
        return null;
    }

    public String createCommentOnColumnDDL(Column column) {
        return null;
    }

    public String createCommentOnTableDDL(String commnets) {
        return null;
    }

    public String[] createDropColumnDDL(Column column, boolean cascadeConstraints) {
        return null;
    }

    public String[] createModifyColumnDDL(Column from, Column to) {
        return null;
    }

    public String createRenameColumnDDL(Column from, Column to) {
        return null;
    }

    public String createRenameTableDDL(String newTableName) {
        return null;
    }

    public boolean supportsModifyColumnSize(String columnType) {
        return false;
    }

    public boolean supportsModifyColumnType() {
        return false;
    }

    public boolean supportsRemarks() {
        return false;
    }

    public boolean supportsDropColumnCascadeConstraints() {
        return false;
    }

    public String VisibleColumnSizePattern() {
        return "^CHAR|^VARCHAR.*|^NCHAR.*|^NATIONAL.*|^NUMERIC|^DEC.*|^FLOAT|^BLOB|^INTERVAL.*";
    }

    public String getTableComment() {
        StringBuffer sb = new StringBuffer();
        if (this.table.getRemarks() != null && !"".equals(this.table.getRemarks())) {
            sb.append("ALTER TABLE ");
            sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
            sb.append(" COMMENT ");
            sb.append("'");
            sb.append(this.table.getRemarks());
            sb.append("'");
            this.setDemiliter(sb);
        }
        return sb.toString();
    }

    public String getColumnComment() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.cols.length) {
            Column col = this.cols[i];
            TableColumn tCol = col.getColumn();
            if (tCol.getRemarks() != null && !"".equals(tCol.getRemarks())) {
                sb.append("ALTER TABLE  ");
                sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
                sb.append(" MODIFY ");
                sb.append(tCol.getColumnName());
                sb.append(" COMMENT ");
                sb.append("'");
                sb.append(tCol.getRemarks());
                sb.append("'");
                this.setDemiliter(sb);
            }
            ++i;
        }
        return sb.toString();
    }

    protected String getConstraintPKStr() {
        StringBuffer sb = new StringBuffer();
        if (this.pks == null || this.pks.length == 0) {
            return null;
        }
        int i = 0;
        i = 0;
        while (i < this.pks.length) {
            TablePKColumn pkc = this.pks[i];
            if (i == 0) {
                this.primaryKeyName = pkc.getName();
                sb.append("PRIMARY KEY ");
                sb.append("(");
                sb.append(pkc.getColumnName());
            } else {
                sb.append(", " + pkc.getColumnName());
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    protected String[] getConstraintIDXStr() {
        return null;
    }
}

