/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.csv;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import zigen.plugin.db.csv.DefaultCsvMappingFactory;
import zigen.plugin.db.csv.ICsvMappingFactory;

public class OracleCsvMappingFactory
extends DefaultCsvMappingFactory
implements ICsvMappingFactory {
    public static final int ORACLE_TIMESTAMP = -100;

    public OracleCsvMappingFactory(boolean convertUnicode, boolean nonDoubleQuate) {
        super(convertUnicode, nonDoubleQuate);
    }

    public String getCsvValue(ResultSet rs, int icol) throws SQLException {
        ResultSetMetaData rmd = rs.getMetaData();
        int type = rmd.getColumnType(icol);
        return super.getCsvValue(rs, icol);
    }

    protected String getDate(ResultSet rs, int icol) throws SQLException {
        Timestamp value = rs.getTimestamp(icol);
        if (rs.wasNull()) {
            return "";
        }
        String temp = this.timeStampFormat.format(new Date(value.getTime()));
        if (!this.nonDoubleQuate) {
            return "\"" + temp + "\"";
        }
        return temp;
    }

    protected String getTimestamp(ResultSet rs, int icol) throws SQLException {
        Timestamp value = rs.getTimestamp(icol);
        if (rs.wasNull()) {
            return "";
        }
        String temp = this.timeStampFormat2.format(new Date(value.getTime()));
        if (!this.nonDoubleQuate) {
            return "\"" + temp + "\"";
        }
        return temp;
    }
}

