/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.diff;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import zigen.plugin.db.diff.IDDLDiff;
import zigen.plugin.db.ui.views.internal.ColorManager;
import zigen.plugin.db.ui.views.internal.SQLCodeConfiguration;

public class DDLDiffViewer
extends TextMergeViewer {
    List fSourceViewer;
    protected ColorManager colorManager;
    protected SQLCodeConfiguration sqlConfiguration;
    protected IDocumentPartitioner partitioner;

    public DDLDiffViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, configuration);
    }

    public void addToolItems(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator("modes"));
        tbm.add((IContributionItem)new Separator("navigation"));
        tbm.add((IContributionItem)new Separator("merge"));
        this.createToolItems((ToolBarManager)tbm);
        this.hideGroupItems(tbm.getItems(), "merge");
    }

    private void hideGroupItems(IContributionItem[] items, String groupId) {
        boolean readingGroupItems = false;
        int i = 0;
        while (i < items.length) {
            IContributionItem item = items[i];
            if (readingGroupItems) {
                item.setVisible(false);
            }
            if (item instanceof Separator && item.getId() != null) {
                readingGroupItems = groupId.equals(item.getId());
            }
            ++i;
        }
    }

    public void setInput(Object input) {
        if (input instanceof IDDLDiff && this.fSourceViewer != null) {
            Iterator iterator = this.fSourceViewer.iterator();
            while (iterator.hasNext()) {
                try {
                    SourceViewer sourceViewer = (SourceViewer)iterator.next();
                    sourceViewer.unconfigure();
                    SQLCodeConfiguration config = this.getSourceViewerConfiguration((ISourceViewer)sourceViewer);
                    sourceViewer.configure((SourceViewerConfiguration)config);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
        }
        super.setInput(input);
    }

    private SQLCodeConfiguration getSourceViewerConfiguration(ISourceViewer sourceViewer) {
        if (this.colorManager == null) {
            this.colorManager = new ColorManager();
        }
        this.sqlConfiguration = new SQLCodeConfiguration(this.colorManager);
        return this.sqlConfiguration;
    }

    protected void configureTextViewer(TextViewer textViewer) {
        if (textViewer instanceof SourceViewer) {
            if (this.fSourceViewer == null) {
                this.fSourceViewer = new ArrayList();
            }
            this.fSourceViewer.add(textViewer);
        }
    }
}

