/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.internal.action;

import java.sql.Connection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleSourceDetailInfo;
import zigen.plugin.db.ext.oracle.internal.OracleSourceDetailSearcher;
import zigen.plugin.db.ext.oracle.internal.OracleSourceErrorInfo;
import zigen.plugin.db.ext.oracle.internal.OracleSourceErrorSearcher;
import zigen.plugin.db.ui.actions.TableViewEditorAction;
import zigen.plugin.db.ui.editors.TableViewEditorFor31;
import zigen.plugin.db.ui.editors.sql.SourceEditorInput;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.Trigger;

public class OpenTriggerAction
extends TableViewEditorAction {
    public OpenTriggerAction() {
        this.setText("Open Trigger Source");
        this.setToolTipText("Open Trigger Source");
        this.setImageDescriptor("IMG_OBJ_FILE");
    }

    public void run() {
        try {
            TableViewEditorFor31 tEditor;
            IStructuredSelection selection;
            Object obj;
            if (this.editor instanceof TableViewEditorFor31 && (obj = (selection = (IStructuredSelection)(tEditor = (TableViewEditorFor31)this.editor).getTableDefineEditor().getConstraintViewer().getSelection()).getFirstElement()) instanceof Trigger) {
                Trigger trigger = (Trigger)obj;
                ITable table = tEditor.getTableNode();
                OracleSourceDetailInfo sourceDetail = null;
                OracleSourceErrorInfo[] sourceErrors = null;
                Connection con = Transaction.getInstance(table.getDbConfig()).getConnection();
                String owner = trigger.getOracleSourceInfo().getOwner();
                String type = trigger.getOracleSourceInfo().getType();
                String name = trigger.getOracleSourceInfo().getName();
                sourceDetail = OracleSourceDetailSearcher.execute(con, owner, name, type, true);
                sourceErrors = OracleSourceErrorSearcher.execute(con, owner, name, type);
                SourceEditorInput input = new SourceEditorInput(table.getDbConfig(), trigger, sourceDetail, sourceErrors);
                IWorkbenchPage page = DbPlugin.getDefault().getPage();
                IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"zigen.plugin.db.ui.editors.sql.SourceEditor", (boolean)true);
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }
}

