/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import java.sql.Connection;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.SchemaSearcher;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableInfo;
import zigen.plugin.db.core.TableSearcher;
import zigen.plugin.db.core.TimeWatcher;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleSynonymInfoSearcher;
import zigen.plugin.db.ext.oracle.internal.SynonymInfo;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.internal.Synonym;
import zigen.plugin.db.ui.internal.Table;
import zigen.plugin.db.ui.internal.TreeLeaf;
import zigen.plugin.db.ui.internal.TreeNode;
import zigen.plugin.db.ui.internal.View;
import zigen.plugin.db.ui.jobs.AbstractJob;
import zigen.plugin.db.ui.jobs.Messages;
import zigen.plugin.db.ui.jobs.RefreshColumnJob;
import zigen.plugin.db.ui.jobs.RefreshTreeNodeAction;

public class RefreshFolderJob
extends AbstractJob {
    private TreeViewer viewer;
    private Folder folder;

    public RefreshFolderJob(TreeViewer viewer, Folder folder) {
        super(Messages.getString("RefreshFolderJob.0"));
        this.viewer = viewer;
        this.folder = folder;
    }

    protected IStatus run(IProgressMonitor monitor) {
        TableInfo[] tables = null;
        try {
            TimeWatcher ts = new TimeWatcher();
            ts.start();
            Connection con = Transaction.getInstance(this.folder.getDbConfig()).getConnection();
            tables = SchemaSearcher.isSupport(con) ? TableSearcher.execute(con, this.folder.getSchema().getName(), new String[]{this.folder.getName()}) : TableSearcher.execute(con, null, new String[]{this.folder.getName()});
            ts.stop();
            if (!this.updateTables(monitor, con, this.folder.getSchema(), this.folder, tables)) {
                return Status.CANCEL_STATUS;
            }
        }
        catch (Exception e) {
            this.showErrorMessage(Messages.getString("RefreshFolderJob.1"), e);
        }
        return Status.OK_STATUS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean updateTables(IProgressMonitor monitor, Connection con, Schema schema, Folder folder, TableInfo[] tables) throws Exception {
        String label = folder.getName();
        ArrayList<String> newTableList = new ArrayList<String>();
        monitor.beginTask(Messages.getString("RefreshFolderJob.2"), tables.length);
        TimeWatcher ts = new TimeWatcher();
        ts.start();
        int i = 0;
        while (i < tables.length) {
            Table node;
            TimeWatcher ts1;
            block14: {
                TableInfo tableinfo;
                block13: {
                    ts1 = new TimeWatcher();
                    ts1.start();
                    tableinfo = tables[i];
                    monitor.subTask(String.valueOf(tableinfo.getName()) + Messages.getString("RefreshFolderJob.3"));
                    if (!"SYNONYM".equals(label)) break block13;
                    monitor.setTaskName(Messages.getString("RefreshFolderJob.5"));
                    node = new Synonym(tableinfo.getName(), tableinfo.getComment());
                    switch (DBType.getType(con.getMetaData())) {
                        case 1: {
                            if (schema == null) throw new Exception(Messages.getString("RefreshFolderJob.6"));
                            String owner = schema.getName();
                            String synonymName = tableinfo.getName();
                            SynonymInfo info = OracleSynonymInfoSearcher.execute(con, owner, synonymName);
                            ((Synonym)node).setSynonymInfo(info);
                            break block14;
                        }
                        default: {
                            throw new UnsupportedOperationException(Messages.getString("RefreshFolderJob.7"));
                        }
                    }
                }
                if ("VIEW".equals(label)) {
                    monitor.setTaskName(Messages.getString("RefreshFolderJob.9"));
                    node = new View(tableinfo.getName(), tableinfo.getComment());
                } else {
                    monitor.setTaskName(Messages.getString("RefreshFolderJob.10"));
                    node = new Table(tableinfo.getName(), tableinfo.getComment());
                }
            }
            newTableList.add(node.getName());
            TreeLeaf leaf = folder.getChild(node.getName());
            if (leaf == null) {
                this.addTable(folder, node);
                this.showResults(new RefreshTreeNodeAction(this.viewer, node, 0));
            } else {
                this.updateTable(leaf, node);
                this.showResults(new RefreshTreeNodeAction(this.viewer, leaf, 0));
            }
            if (monitor.isCanceled()) {
                return false;
            }
            ts1.stop();
            monitor.worked(1);
            ++i;
        }
        ts.stop();
        TreeLeaf[] leafs = folder.getChildrens();
        int i2 = 0;
        while (i2 < leafs.length) {
            TreeLeaf leaf = leafs[i2];
            if (!newTableList.contains(leaf.getName())) {
                folder.removeChild(leaf);
            }
            ++i2;
        }
        ts.start();
        try {
            this.showResults(new RefreshTreeNodeAction(this.viewer, folder, 0));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        ts.stop();
        return true;
    }

    private void addTable(Folder folder, ITable newNode) {
        folder.addChild((TreeNode)((Object)newNode));
        TableColumn tColumn = new TableColumn();
        tColumn.setColumnName(DbPluginConstant.TREE_LEAF_LOADING);
        newNode.addChild(new Column(tColumn));
    }

    private void updateTable(TreeLeaf oldNode, ITable newNode) {
        RefreshColumnJob job = null;
        if (oldNode instanceof Synonym) {
            Synonym synonym = (Synonym)oldNode;
            synonym.update((Synonym)newNode);
            synonym.setEnabled(true);
            if (synonym.isExpanded()) {
                job = new RefreshColumnJob(this.viewer, synonym);
            }
        } else if (oldNode instanceof View) {
            View view = (View)oldNode;
            view.update((View)newNode);
            view.setEnabled(true);
            if (view.isExpanded()) {
                job = new RefreshColumnJob(this.viewer, view);
            }
        } else if (oldNode instanceof Table) {
            Table table = (Table)oldNode;
            table.update((Table)newNode);
            table.setEnabled(true);
            if (table.isExpanded()) {
                job = new RefreshColumnJob(this.viewer, table);
            }
        }
        if (job != null) {
            TimeWatcher ts = new TimeWatcher();
            ts.start();
            job.setPriority(20);
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException e) {
                DbPlugin.log(e);
            }
            ts.stop();
        }
    }
}

