/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.commands;

import java.io.File;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.client.OperationProgressNotifyListener;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class BranchTagCommand
implements ISVNCommand {
    private SVNUrl[] sourceUrls;
    private SVNUrl destinationUrl;
    private IResource[] resources;
    private boolean createOnServer;
    private String message;
    private SVNRevision revision;
    private boolean makeParents;
    private ISVNClientAdapter svnClient;
    private SVNWorkspaceRoot root;
    private boolean multipleTransactions = true;
    private Map urlMap = new HashMap();

    public BranchTagCommand(SVNWorkspaceRoot root, IResource[] resources, SVNUrl[] sourceUrls, SVNUrl destinationUrl, String message, boolean createOnServer, SVNRevision revision) {
        this.root = root;
        this.resources = resources;
        this.sourceUrls = sourceUrls;
        this.destinationUrl = destinationUrl;
        this.createOnServer = createOnServer;
        this.message = message;
        this.revision = revision;
    }

    public BranchTagCommand(ISVNClientAdapter svnClient, IResource[] resources, SVNUrl[] sourceUrls, SVNUrl destinationUrl, String message, boolean createOnServer, SVNRevision revision) {
        this.svnClient = svnClient;
        this.resources = resources;
        this.sourceUrls = sourceUrls;
        this.destinationUrl = destinationUrl;
        this.createOnServer = createOnServer;
        this.message = message;
        this.revision = revision;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws SVNException {
        try {
            try {
                block19: {
                    block20: {
                        monitor.beginTask(null, 100);
                        if (this.svnClient == null) {
                            this.svnClient = this.root.getRepository().getSVNClient();
                        }
                        OperationManager.getInstance().beginOperation(this.svnClient, new OperationProgressNotifyListener(monitor, this.svnClient));
                        if (!this.createOnServer) break block20;
                        boolean copyAsChild = this.sourceUrls.length > 1;
                        String commonRoot = null;
                        if (copyAsChild) {
                            commonRoot = this.getCommonRoot();
                        }
                        if (!this.multipleTransactions || !copyAsChild || this.destinationUrl.toString().startsWith(commonRoot)) {
                            this.svnClient.copy(this.sourceUrls, this.destinationUrl, this.message, this.revision, copyAsChild, this.makeParents);
                            this.multipleTransactions = false;
                            break block19;
                        } else {
                            int i = 0;
                            while (i < this.sourceUrls.length) {
                                String fromUrl = this.sourceUrls[i].toString();
                                String uncommonPortion = fromUrl.substring(commonRoot.length());
                                String toUrl = String.valueOf(this.destinationUrl.toString()) + uncommonPortion;
                                SVNUrl destination = new SVNUrl(toUrl);
                                SVNUrl[] source = new SVNUrl[]{this.sourceUrls[i]};
                                this.urlMap.put(fromUrl, destination);
                                this.svnClient.copy(source, destination, this.message, this.revision, copyAsChild, this.makeParents);
                                ++i;
                            }
                        }
                        break block19;
                    }
                    File[] files = new File[this.resources.length];
                    int i = 0;
                    while (true) {
                        block21: {
                            if (i < this.resources.length) break block21;
                        }
                        files[i] = this.resources[i].getLocation().toFile();
                        ++i;
                    }
                    boolean copyAsChild = files.length > 1;
                    String commonRoot = null;
                    if (copyAsChild) {
                        commonRoot = this.getCommonRoot();
                    }
                    if (!this.multipleTransactions || !copyAsChild || this.destinationUrl.toString().startsWith(commonRoot)) {
                        try {
                            this.svnClient.copy(files, this.destinationUrl, this.message, copyAsChild, this.makeParents);
                            this.multipleTransactions = false;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    } else {
                        int i2 = 0;
                        while (i2 < this.sourceUrls.length) {
                            String fromUrl = this.sourceUrls[i2].toString();
                            String uncommonPortion = fromUrl.substring(commonRoot.length());
                            String toUrl = String.valueOf(this.destinationUrl.toString()) + uncommonPortion;
                            SVNUrl destination = new SVNUrl(toUrl);
                            File[] source = new File[]{files[i2]};
                            try {
                                this.urlMap.put(fromUrl, destination);
                                this.svnClient.copy(source, destination, this.message, copyAsChild, this.makeParents);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                            ++i2;
                        }
                    }
                }
                monitor.worked(100);
            }
            catch (Exception e) {
                throw SVNException.wrapException(e);
            }
        }
        catch (Throwable throwable) {
            Object var11_21 = null;
            OperationManager.getInstance().endOperation();
            monitor.done();
            throw throwable;
        }
        {
            Object var11_22 = null;
            OperationManager.getInstance().endOperation();
        }
        monitor.done();
    }

    public void setMakeParents(boolean makeParents) {
        this.makeParents = makeParents;
    }

    public void setMultipleTransactions(boolean multipleTransactions) {
        this.multipleTransactions = multipleTransactions;
    }

    public SVNUrl getDestinationUrl(String sourceUrl) {
        if (!this.multipleTransactions) {
            if (this.sourceUrls.length == 1) {
                return this.destinationUrl;
            }
            String uncommonPortion = sourceUrl.substring(this.getCommonRoot().length());
            String toUrl = String.valueOf(this.destinationUrl.toString()) + uncommonPortion;
            try {
                return new SVNUrl(toUrl);
            }
            catch (MalformedURLException malformedURLException) {
                return this.destinationUrl;
            }
        }
        return (SVNUrl)this.urlMap.get(sourceUrl);
    }

    private String getCommonRoot() {
        String commonRoot = null;
        String urlString = this.sourceUrls[0].toString();
        int i = 0;
        block0: while (i < urlString.length()) {
            String partialPath = urlString.substring(0, i + 1);
            if (partialPath.endsWith("/")) {
                int j = 1;
                while (j < this.sourceUrls.length) {
                    if (!this.sourceUrls[j].toString().startsWith(partialPath)) break block0;
                    ++j;
                }
                commonRoot = partialPath.substring(0, i);
            }
            ++i;
        }
        return commonRoot;
    }
}

