/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.commands;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.ISVNRunnable;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.client.OperationProgressNotifyListener;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ShareProjectCommand
implements ISVNCommand {
    protected ISVNRepositoryLocation location;
    protected IProject project;
    protected String remoteDirName;
    protected String comment;
    protected boolean createDirectory;

    public ShareProjectCommand(ISVNRepositoryLocation location, IProject project, String remoteDirName, boolean createDirectory) {
        this.location = location;
        this.project = project;
        this.remoteDirName = remoteDirName == null ? project.getName() : remoteDirName;
        this.createDirectory = createDirectory;
    }

    public ShareProjectCommand(ISVNRepositoryLocation location, IProject project) {
        this(location, project, null, true);
    }

    public void run(IProgressMonitor monitor) throws SVNException {
        boolean alreadyExists = SVNProviderPlugin.getPlugin().getRepositories().isKnownRepository(this.location.getLocation(), false);
        try {
            final ISVNClientAdapter svnClient = this.location.getSVNClient();
            SVNProviderPlugin.run(new ISVNRunnable(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor pm) throws SVNException {
                    String message = ShareProjectCommand.this.comment == null ? Policy.bind("SVNProvider.initialImport") : ShareProjectCommand.this.comment;
                    try {
                        SVNUrl url = ShareProjectCommand.this.location.getUrl().appendPath(ShareProjectCommand.this.remoteDirName);
                        if (ShareProjectCommand.this.createDirectory) {
                            svnClient.mkdir(url, true, message);
                        }
                        try {
                            OperationManager.getInstance().beginOperation(svnClient, new OperationProgressNotifyListener(pm, svnClient));
                            svnClient.checkout(url, ShareProjectCommand.this.project.getLocation().toFile(), SVNRevision.HEAD, !ShareProjectCommand.this.createDirectory);
                        }
                        catch (Throwable throwable) {
                            Object var4_7 = null;
                            OperationManager.getInstance().endOperation();
                            throw throwable;
                        }
                        {
                            Object var4_8 = null;
                            OperationManager.getInstance().endOperation();
                        }
                    }
                    catch (SVNClientException e) {
                        throw new SVNException("Error while creating module: " + e.getMessage(), e);
                    }
                    SVNProviderPlugin.getPlugin().getStatusCacheManager().refreshStatus((IContainer)ShareProjectCommand.this.project, true);
                    try {
                        RepositoryProvider.map((IProject)ShareProjectCommand.this.project, (String)SVNProviderPlugin.getTypeId());
                        return;
                    }
                    catch (TeamException e) {
                        throw new SVNException("Cannot register project with svn provider", e);
                    }
                }
            }, monitor);
        }
        catch (SVNException e) {
            if (!alreadyExists) {
                SVNProviderPlugin.getPlugin().getRepositories().disposeRepository(this.location);
            }
            throw e;
        }
        if (!alreadyExists) {
            SVNProviderPlugin.getPlugin().getRepositories().addOrUpdateRepository(this.location);
        }
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

