/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.cgi.server;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.epic.debug.cgi.server.CGIConfig;
import org.epic.debug.cgi.server.StreamForwarder;
import org.epic.debug.util.ExecutionArguments;
import sunlabs.brazil.server.Handler;
import sunlabs.brazil.server.Request;
import sunlabs.brazil.server.Server;

public class EpicCgiHandler
implements Handler {
    private static final Object LOCK = new Object();
    private static final String ROOT = "root";
    private static final String SUFFIX = "suffix";
    private static final String PREFIX = "prefix";
    private static final String CUSTOM = "custom";
    private static final String ENV = "ENV";
    private static String software = "Mini Java CgiHandler 0.2";
    private static Hashtable envMap = new Hashtable(2);
    private CGIConfig config;
    private Socket diagSocket;
    private Socket outSocket;
    private Socket errorSocket;
    private PrintWriter mDiag;
    private OutputStream mOut;
    private OutputStream mError;
    private Exception defaultEnvError;

    static {
        envMap.put("content-length", "CONTENT_LENGTH");
        envMap.put("content-type", "CONTENT_TYPE");
    }

    public boolean init(Server server, String prefix) {
        this.config = new CGIConfig(server, prefix);
        return this.connectToCGIProxy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean respond(Request request) {
        Object object = LOCK;
        synchronized (object) {
            return this.respondImpl(request);
        }
    }

    private boolean respondImpl(Request request) {
        String prefix;
        String url = request.props.getProperty("url.orig", request.url);
        if (!url.startsWith(prefix = this.config.getRequestProperty(request, PREFIX, "/"))) {
            return false;
        }
        if (url.endsWith("favicon.ico")) {
            return false;
        }
        String suffixes = this.config.getRequestProperty(request, SUFFIX, ".cgi");
        String root = this.config.getRequestProperty(request, ROOT, request.props.getProperty(ROOT, "."));
        request.log(5, "suffix=" + suffixes + " root=" + root + " url: " + url);
        Object[] ret = this.findCGIFile(request, url, suffixes, root);
        if (ret == null) {
            return false;
        }
        File cgiFile = (File)ret[0];
        int pathInfoStartI = (Integer)ret[1];
        String[] command = this.createCommandLine(request, cgiFile);
        String[] env = this.createEnvironment(request, cgiFile, root, url, pathInfoStartI);
        this.execCGI(request, cgiFile, command, env);
        return true;
    }

    private boolean connectToCGIProxy() {
        try {
            this.diagSocket = new Socket("localhost", this.config.getDiagPort());
            this.outSocket = new Socket("localhost", this.config.getOutPort());
            this.errorSocket = new Socket("localhost", this.config.getErrorPort());
            this.mError = this.errorSocket.getOutputStream();
            this.mOut = this.outSocket.getOutputStream();
            this.mDiag = new PrintWriter(this.diagSocket.getOutputStream(), true);
            if (this.defaultEnvError != null) {
                this.mDiag.println("Failed to retrieve global environment variables:");
                this.defaultEnvError.printStackTrace(this.mDiag);
                this.mDiag.println("CGI scripts might not be executed properly.");
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private String[] createCommandLine(Request request, File cgiFile) {
        String perlParams;
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(this.config.getPerlExecutable());
        commandList.add("-I" + cgiFile.getParentFile().getAbsolutePath().replace('\\', '/'));
        commandList.addAll(this.config.getRunInclude());
        if (this.config.getDebugMode()) {
            commandList.add(this.config.getDebugInclude());
            commandList.add("-d");
        }
        if ((perlParams = this.config.getPerlParams()) != null && perlParams.length() > 0) {
            ExecutionArguments exArgs = new ExecutionArguments(perlParams);
            commandList.addAll(exArgs.getProgramArgumentsL());
        }
        commandList.add(cgiFile.getAbsolutePath());
        if (request.query.indexOf("=") == -1) {
            commandList.add(request.query);
        }
        String[] command = commandList.toArray(new String[commandList.size()]);
        return command;
    }

    private String[] createEnvironment(Request request, File cgiFile, String root, String url, int pathInfoStartI) {
        ArrayList<String> env = new ArrayList<String>();
        Enumeration keys = request.headers.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String special = (String)envMap.get(key.toLowerCase());
            if (special != null) {
                env.add(String.valueOf(special) + "=" + request.headers.get(key));
                continue;
            }
            env.add("HTTP_" + key.toUpperCase().replace('-', '_') + "=" + request.headers.get(key));
        }
        env.add("GATEWAY_INTERFACE=CGI/1.1");
        env.add("SERVER_SOFTWARE=" + software);
        env.add("SERVER_NAME=" + this.config.getHostname());
        env.add("PATH_INFO=" + url.substring(pathInfoStartI));
        String suffix = cgiFile.getName();
        suffix = suffix.lastIndexOf(46) != -1 ? suffix.substring(suffix.lastIndexOf(46)) : "";
        String pre = url.substring(0, pathInfoStartI);
        if (pre.endsWith(suffix)) {
            env.add("SCRIPT_NAME=" + pre);
        } else {
            env.add("SCRIPT_NAME=" + pre + suffix);
        }
        env.add("SERVER_PORT=" + this.config.getServerPort());
        env.add("REMOTE_ADDR=" + request.getSocket().getInetAddress().getHostAddress());
        env.add("PATH_TRANSLATED=" + root + url.substring(pathInfoStartI));
        env.add("REQUEST_METHOD=" + request.method);
        env.add("SERVER_PROTOCOL=" + request.protocol);
        env.add("QUERY_STRING=" + request.query);
        if (this.config.getProtocol().equals("https")) {
            env.add("HTTPS=on");
        }
        env.add("SERVER_URL=" + request.serverUrl());
        if (!this.config.getRequestProperty(request, CUSTOM, "").equals("")) {
            Map props = this.config.getProperties("");
            for (String key : props.keySet()) {
                env.add("CONFIG_" + key + "=" + props.get(key));
            }
            env.add("CONFIG_PREFIX=" + this.config.getPropsPrefix());
        }
        Map userEnv = this.config.getProperties("ENV_");
        for (String key : userEnv.keySet()) {
            env.add(String.valueOf(key) + "=" + userEnv.get(key));
        }
        String[] environ = env.toArray(new String[env.size()]);
        return environ;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void execCGI(Request request, File cgiFile, String[] command, String[] env) {
        this.mDiag.println("***********************************************************");
        this.mDiag.println("Requested URI: " + request.props.getProperty("url.orig", request.url));
        this.mDiag.println("---------------------CGI Command Line----------------------");
        i = 0;
        while (true) {
            if (i >= command.length) break;
            this.mDiag.println(command[i]);
            ++i;
        }
        this.mDiag.println("-------------------Environment Variables-------------------");
        i = 0;
        while (true) {
            if (i >= env.length) {
                cgi = null;
                stderrFwd = null;
                ** try [egrp 0[TRYBLOCK] [2, 6 : 128->414)] { 
lbl17:
                // 1 sources

                break;
            }
            this.mDiag.println(env[i]);
            ++i;
        }
        {
            cgi = Runtime.getRuntime().exec(command, env, new File(cgiFile.getParent()));
            in = new DataInputStream(new BufferedInputStream(cgi.getInputStream()));
            if (request.postData != null) {
                toCgi = cgi.getOutputStream();
                toCgi.write(request.postData, 0, request.postData.length);
                toCgi.close();
                this.mDiag.println("------------------------POST data--------------------------");
                this.mDiag.println(new String(request.postData, "ISO-8859-1"));
                this.mDiag.flush();
            }
            stderrFwd = new StreamForwarder("EpicCgiHandler.readError", new BufferedInputStream(cgi.getErrorStream()), this.mError);
            stderrFwd.start();
            this.mDiag.println("-----------------------Script Output-----------------------");
            type = "text/html";
            status = 200;
lbl35:
            // 6 sources

            while (true) {
                block25: {
                    head = in.readLine();
                    if (head != null && head.length() != 0) break block25;
                    this.mOut.write("\r\n".getBytes());
                    this.mOut.flush();
                    ** GOTO lbl100
                }
                this.mOut.write(head.getBytes("ISO-8859-1"));
                this.mOut.write("\r\n".getBytes());
                this.mOut.flush();
                colonIndex = head.indexOf(58);
                if (colonIndex < 0) {
                    request.sendError(500, "Missing header from cgi output");
                    this.mError.write("Error 500: Missing header from cgi output".getBytes("ASCII"));
                }
                ** GOTO lbl-1000
                break;
            }
        }
lbl51:
        // 1 sources

        catch (Exception e) {
            if (cgi != null) {
                cgi.destroy();
            }
            trace = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)trace, true));
            request.sendError(500, "CGI failure", trace.toString());
            try {
                this.mError.write(("Error 500: CGI failure: " + e.getMessage()).getBytes("ASCII"));
                e.printStackTrace(new PrintStream(this.mError));
            }
            catch (IOException v0) {}
            try {
                if (stderrFwd == null) return;
                stderrFwd.join();
                return;
            }
            catch (Exception v1) {
                return;
            }
        }
lbl68:
        // 1 sources

        catch (Throwable var14_17) {
            try {
                if (stderrFwd == null) throw var14_17;
                stderrFwd.join();
                throw var14_17;
            }
            catch (Exception v2) {}
            throw var14_17;
        }
        try {
            if (stderrFwd == null) return;
            stderrFwd.join();
            return;
        }
        catch (Exception v3) {}
        return;
lbl-1000:
        // 1 sources

        {
            block28: {
                block27: {
                    block26: {
                        lower = head.toLowerCase();
                        if (!lower.startsWith("status:")) break block26;
                        try {
                            status = Integer.parseInt(head.substring(colonIndex + 1).trim());
                        }
                        catch (NumberFormatException v4) {}
                        ** GOTO lbl35
                    }
                    if (!lower.startsWith("content-type:")) break block27;
                    type = head.substring(colonIndex + 1).trim();
                    ** GOTO lbl35
                }
                if (!lower.startsWith("location:")) break block28;
                status = 302;
                request.addHeader(head);
                ** GOTO lbl35
            }
            request.addHeader(head);
            ** continue;
lbl100:
            // 1 sources

            buff = new ByteArrayOutputStream();
            buf = new byte[1024];
            while ((bread = in.read(buf, 0, buf.length)) > 0) {
                buff.write(buf, 0, bread);
                this.mOut.write(buf, 0, bread);
                this.mOut.flush();
            }
            request.sendHeaders(status, type, buff.size());
            buff.writeTo((OutputStream)request.out);
            request.log(5, "CGI output " + buff.size() + " bytes.");
            cgi.waitFor();
        }
        try {
            if (stderrFwd == null) return;
            stderrFwd.join();
            return;
        }
        catch (Exception v5) {}
    }

    private Object[] findCGIFile(Request request, String uri, String suffixes, String root) {
        String suffix = null;
        StringTokenizer tok = new StringTokenizer(suffixes, ",");
        int start = 1;
        int end = 0;
        while (tok.hasMoreTokens()) {
            suffix = tok.nextToken();
            request.log(5, "Checking for suffix: " + suffix);
            start = 1;
            end = 0;
            while (end < uri.length()) {
                String s;
                end = uri.indexOf(47, start);
                if (end < 0) {
                    end = uri.length();
                }
                if (!(s = uri.substring(1, end)).endsWith(suffix)) {
                    s = String.valueOf(s) + suffix;
                }
                File cgiFile = new File(root, s);
                request.log(5, "looking for: " + cgiFile);
                if (cgiFile.isFile()) {
                    request.log(5, "found: " + cgiFile);
                    return new Object[]{cgiFile, new Integer(end)};
                }
                start = end + 1;
            }
        }
        return null;
    }
}

