/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.remote;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.epic.debug.LaunchConfigurationDelegate;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.remote.CreateRemotePackageJob;
import org.epic.debug.remote.RemoteDebugTarget;
import org.epic.debug.util.DebuggerProxy;
import org.epic.debug.util.IPathMapper;
import org.epic.debug.util.RemotePathMapper;
import org.epic.debug.util.RemotePort;

public class RemoteLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    @Override
    protected void doLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        int debugPortNo;
        RemotePort debugPort;
        RemotePathMapper mapper = new RemotePathMapper(this.getProject(launch), this.getRemoteProjectDir(launch));
        if (this.shouldCreateDebugPackage(launch)) {
            CreateRemotePackageJob job = new CreateRemotePackageJob(this, launch, mapper);
            job.schedule();
        }
        if (!(debugPort = new RemotePort("DebugTarget.mDebugPort", debugPortNo = Integer.parseInt(this.getEpicDebuggerPort(launch)), debugPortNo)).startConnect()) {
            PerlDebugPlugin.errorDialog("Could not listen on local debug port " + debugPortNo + "\nCheck that it is not bound by another application.");
            launch.terminate();
            return;
        }
        DebuggerProxy process = new DebuggerProxy("Remote Debugger", launch, this.getEpicDebuggerIP(launch));
        launch.addProcess((IProcess)process);
        monitor.subTask("Waiting for debugger connection...");
        while (!launch.isTerminated() && debugPort.waitForConnect(true, false) != 1 && !monitor.isCanceled()) {
        }
        if (monitor.isCanceled()) {
            launch.terminate();
            debugPort.shutdown();
            return;
        }
        if (launch.isTerminated()) {
            debugPort.shutdown();
            return;
        }
        RemoteDebugTarget target = new RemoteDebugTarget(launch, process, debugPort, (IPathMapper)mapper);
        launch.addDebugTarget((IDebugTarget)target);
        if (!target.getDebugger().isTerminated()) {
            process.init(target.getDebugger());
        } else {
            launch.terminate();
        }
    }

    @Override
    protected IProject getProject(ILaunch launch) throws CoreException {
        return super.getProject(launch);
    }

    File getDebugPackageFile(ILaunch launch) throws CoreException {
        return new File(launch.getLaunchConfiguration().getAttribute("ATTR_REMOTE_DEBUG_PACKAGE_PATH", ""));
    }

    String getEpicDebuggerIP(ILaunch launch) throws CoreException {
        return launch.getLaunchConfiguration().getAttribute("ATTR_REMOTE_HOST", "");
    }

    String getEpicDebuggerPort(ILaunch launch) throws CoreException {
        return launch.getLaunchConfiguration().getAttribute("ATTR_REMOTE_PORT", "");
    }

    String getRemoteProjectDir(ILaunch launch) throws CoreException {
        return launch.getLaunchConfiguration().getAttribute("ATTR_REMOTE_DEST", "");
    }

    Path getScriptPath(ILaunch launch) throws CoreException {
        return new Path(launch.getLaunchConfiguration().getAttribute("ATTR_STARTUP_FILE", ""));
    }

    private boolean shouldCreateDebugPackage(ILaunch launch) throws CoreException {
        return launch.getLaunchConfiguration().getAttribute("ATTR_REMOTE_CREATE_DEBUG_PACKAGE", true);
    }
}

