/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.epic.debug.db.DebuggerInterface;
import org.epic.debug.util.IPathMapper;

public abstract class AbstractPathMapper
implements IPathMapper {
    private final List epicPathPrefixes = new ArrayList();
    private final List dbPathPrefixes = new ArrayList();

    protected AbstractPathMapper() {
    }

    protected void addMapping(IPath epicPathPrefix, IPath dbPathPrefix) {
        this.epicPathPrefixes.add(epicPathPrefix);
        this.dbPathPrefixes.add(dbPathPrefix);
    }

    @Override
    public IPath getDebuggerPath(IPath epicPath, DebuggerInterface db) {
        return this.swapPrefix(epicPath, this.epicPathPrefixes, this.dbPathPrefixes);
    }

    @Override
    public IPath getEpicPath(IPath dbPath) {
        return this.swapPrefix(dbPath, this.dbPathPrefixes, this.epicPathPrefixes);
    }

    @Override
    public boolean requiresEffectiveIncPath() {
        return false;
    }

    @Override
    public void setEffectiveIncPath(List inc) {
    }

    private IPath swapPrefix(IPath path, final List srcPrefixes, List targetPrefixes) {
        Integer[] srcPrefixI = new Integer[srcPrefixes.size()];
        int i = 0;
        while (i < srcPrefixI.length) {
            srcPrefixI[i] = new Integer(i);
            ++i;
        }
        Arrays.sort(srcPrefixI, new Comparator(){

            public int compare(Object o1, Object o2) {
                int i1 = (Integer)o1;
                int i2 = (Integer)o2;
                return srcPrefixes.get(i2).toString().length() - srcPrefixes.get(i1).toString().length();
            }
        });
        i = 0;
        while (i < srcPrefixI.length) {
            IPath srcPrefix = (IPath)srcPrefixes.get(srcPrefixI[i]);
            if (srcPrefix.isPrefixOf(path)) {
                path = path.removeFirstSegments(srcPrefix.segmentCount());
                return ((IPath)targetPrefixes.get(srcPrefixI[i])).append(path);
            }
            ++i;
        }
        return null;
    }
}

