/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class ResourceUtilities {
    public static File extractResources(Plugin plugin, String pathInPlugin) throws CoreException {
        File file;
        if (!ResourceUtilities.isDeployedAsJar(plugin.getBundle())) {
            return null;
        }
        File pluginJar = ResourceUtilities.getBundleJar(plugin.getBundle());
        File location = new File(plugin.getStateLocation().toFile(), pathInPlugin);
        if (location.exists() && location.lastModified() > pluginJar.lastModified()) {
            return location;
        }
        try {
            ResourceUtilities.deleteRecursively(location);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, plugin.getBundle().getSymbolicName(), 0, "Could not delete directory " + location.getAbsolutePath() + "; " + "please report this as a bug in EPIC", (Throwable)e));
        }
        ZipFile zipFile = new ZipFile(pluginJar);
        try {
            File destDir = location.getParentFile();
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (!entry.getName().startsWith(pathInPlugin)) continue;
                ResourceUtilities.extractZipEntry(zipFile, entry, destDir);
            }
            file = location;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, plugin.getBundle().getSymbolicName(), 0, "Could not extract resources to directory " + location.getAbsolutePath() + "; " + "please report this as a bug in EPIC", (Throwable)e));
            }
        }
        try {
            zipFile.close();
        }
        catch (IOException iOException) {}
        return file;
    }

    public static File getBundleJar(Bundle plugin) throws CoreException {
        try {
            URL url = Platform.resolve((URL)plugin.getEntry("/"));
            if (url.getProtocol().equalsIgnoreCase("jar")) {
                String path = url.getPath();
                assert (path.startsWith("file:"));
                assert (path.endsWith(".jar!/"));
                path = path.substring(5, path.length() - 2);
                return new File(path);
            }
            return null;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, plugin.getSymbolicName(), 0, "Could not determine plug-in deployment jar; please report this as a bug in EPIC", (Throwable)e));
        }
    }

    public static boolean isDeployedAsJar(Bundle plugin) throws CoreException {
        try {
            return Platform.resolve((URL)plugin.getEntry("/")).getProtocol().equalsIgnoreCase("jar");
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, plugin.getSymbolicName(), 0, "Could not determine plug-in deployment type; please report this as a bug in EPIC", (Throwable)e));
        }
    }

    private static void deleteRecursively(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory() && !files[i].getName().equals(".") && !files[i].getName().equals("..")) {
                ResourceUtilities.deleteRecursively(files[i]);
            } else if (!files[i].delete()) {
                throw new IOException("Could not delete file " + files[i].getAbsolutePath());
            }
            ++i;
        }
        if (!dir.delete()) {
            throw new IOException("Could not delete dir " + dir.getAbsolutePath());
        }
    }

    private static void extractZipEntry(ZipFile zipFile, ZipEntry entry, File destBase) throws IOException {
        if (entry.isDirectory()) {
            File outDir = new File(destBase, entry.getName());
            if (!outDir.mkdirs() && !outDir.isDirectory()) {
                throw new IOException("Failed to extract " + entry.getName());
            }
        } else {
            InputStream in = null;
            OutputStream out = null;
            try {
                int bread;
                File outFile = new File(destBase, entry.getName());
                outFile.getParentFile().mkdirs();
                in = zipFile.getInputStream(entry);
                out = new BufferedOutputStream(new FileOutputStream(outFile));
                byte[] buf = new byte[4096];
                while ((bread = in.read(buf)) != -1) {
                    out.write(buf, 0, bread);
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

