/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.actions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.epic.core.PerlCore;
import org.epic.core.PerlProject;
import org.epic.core.model.ISourceElement;
import org.epic.core.model.Package;
import org.epic.core.model.SourceFile;
import org.epic.core.util.FileUtilities;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.actions.OpenDeclarationAction;
import org.epic.perleditor.editors.PerlEditor;
import org.epic.perleditor.editors.PerlPartitioner;
import org.epic.perleditor.editors.perl.SourceParser;

abstract class AbstractOpenDeclaration {
    private static final String REQUIRE_REG_EXPR = "^[\\s]*require\\s+(\\S+)";
    private final OpenDeclarationAction action;

    public AbstractOpenDeclaration(OpenDeclarationAction action) {
        this.action = action;
    }

    public Result run(ITextSelection selection) {
        return this.runWithSearchString(this.getSearchString(selection));
    }

    public Result run() {
        return this.runWithSearchString(this.getSearchString((ITextSelection)this.getEditor().getSelectionProvider().getSelection()));
    }

    protected abstract IRegion findDeclaration(SourceFile var1, String var2) throws CoreException;

    protected abstract String getLocalSearchString(String var1);

    protected abstract String getSearchString(ITextSelection var1);

    protected abstract String getTargetModule(String var1);

    protected void messageBox(String title, String message) {
        Shell shell = PerlEditorPlugin.getWorkbenchWindow().getShell();
        MessageDialog.openInformation((Shell)shell, (String)title, (String)message);
    }

    private Result runWithSearchString(String searchString) {
        try {
            return this._runWithSearchString(searchString);
        }
        catch (CoreException e) {
            this.getLog().log(e.getStatus());
            return new Result(4, null, null, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Result _runWithSearchString(String searchString) throws CoreException {
        if (searchString == null) {
            return Result.invalidSearch();
        }
        String targetModule = this.getTargetModule(searchString);
        if (targetModule != null && targetModule.equals("main")) {
            targetModule = null;
            searchString = this.getLocalSearchString(searchString);
        }
        if (targetModule != null) {
            String localSearchString = this.getLocalSearchString(searchString);
            File moduleFile = this.findModuleFile(targetModule);
            if (moduleFile == null) return Result.moduleNotFound(targetModule);
            Result res = this.searchModuleFile(moduleFile, localSearchString);
            if (!res.isFound()) return Result.notFound(searchString);
            return res;
        }
        IRegion match = this.findDeclaration(this.getEditor().getSourceFile(), searchString);
        if (match != null) {
            this.getEditor().selectAndReveal(match.getOffset(), match.getLength());
            return Result.found();
        }
        String[] usedModules = this.findUsedModules(this.getEditor().getSourceFile());
        int i = 0;
        while (i < usedModules.length) {
            Result res;
            File moduleFile = this.findModuleFile(usedModules[i]);
            if (moduleFile != null && (res = this.searchModuleFile(moduleFile, searchString)).isFound()) {
                return res;
            }
            ++i;
        }
        Result res = this.searchInRequires(searchString, this.getCurrentDir(), this.getEditor().getSourceFile().getDocument(), new HashSet());
        if (!res.isFound()) return Result.notFound(searchString);
        return res;
    }

    private File findModuleFile(String moduleName) throws CoreException {
        if (moduleName.length() == 0) {
            return null;
        }
        String fileSep = File.separatorChar == '\\' ? "\\\\" : File.separator;
        String modulePath = String.valueOf(moduleName.replaceAll("::", fileSep)) + ".pm";
        List dirs = this.getProject().getEffectiveIncPath();
        for (File dir : dirs) {
            File f;
            if (".".equals(dir.getName())) {
                dir = this.getCurrentDir();
            }
            if (!(f = new File(dir, modulePath)).exists() || !f.isFile()) continue;
            return f;
        }
        return null;
    }

    private File[] findRequiredFiles(File fromDir, IDocument source) throws CoreException {
        String text = source.get();
        List elems = SourceParser.getElements(text, REQUIRE_REG_EXPR, "", "", true);
        ArrayList<File> requiredFiles = new ArrayList<File>();
        for (ISourceElement elem : elems) {
            File moduleFile;
            Matcher m;
            String elemText = elem.getName();
            if (elemText.indexOf("\"") != -1 || elemText.indexOf("'") != -1) {
                File requiredFile;
                m = Pattern.compile("['\"]([^'\"]*?)['\"]").matcher(elemText);
                if (!m.find() || !(requiredFile = new File(fromDir, m.group(1))).isFile()) continue;
                requiredFiles.add(requiredFile);
                continue;
            }
            m = Pattern.compile("([A-Za-z0-9:]+)").matcher(elemText);
            if (!m.find() || (moduleFile = this.findModuleFile(m.group(1))) == null) continue;
            requiredFiles.add(moduleFile);
        }
        return requiredFiles.toArray(new File[requiredFiles.size()]);
    }

    private String[] findUsedModules(SourceFile sourceFile) throws CoreException {
        ArrayList<String> names = new ArrayList<String>();
        for (Package pkg : sourceFile.getPackages()) {
            Iterator i = pkg.getUses().iterator();
            while (i.hasNext()) {
                names.add(((ISourceElement)i.next()).getName());
            }
        }
        return names.toArray(new String[names.size()]);
    }

    private File getCurrentDir() {
        IEditorInput input = this.getEditor().getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            return new File(".");
        }
        IPath scriptFilePath = ((IFileEditorInput)input).getFile().getLocation();
        if (scriptFilePath == null) {
            return new File(".");
        }
        String ext = scriptFilePath.getFileExtension();
        if (ext == null || !ext.toLowerCase().equals("pm")) {
            return scriptFilePath.toFile().getParentFile();
        }
        return new File(".");
    }

    private PerlEditor getEditor() {
        return this.action.getEditor();
    }

    private ILog getLog() {
        return this.action.getLog();
    }

    private PerlProject getProject() {
        IEditorInput input = this.getEditor().getEditorInput();
        IResource resource = (IResource)input.getAdapter(IResource.class);
        return PerlCore.create(resource.getProject());
    }

    protected IDocument getSourceDocument() {
        return this.getSourceDocument(this.getEditor());
    }

    private IDocument getSourceDocument(File file) throws IOException {
        Document document;
        block8: {
            StringWriter sw = new StringWriter();
            BufferedReader r = null;
            try {
                int bread;
                r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1"));
                char[] buf = new char[4096];
                while ((bread = r.read(buf)) > 0) {
                    sw.write(buf, 0, bread);
                }
                Document doc = new Document(sw.toString());
                new PerlPartitioner(this.getLog(), (IDocument)doc);
                document = doc;
                if (r == null) break block8;
            }
            catch (Throwable throwable) {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                r.close();
            }
            catch (IOException iOException) {}
        }
        return document;
    }

    private IDocument getSourceDocument(PerlEditor editor) {
        return editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
    }

    private Result searchEditor(PerlEditor editor, String searchString) throws CoreException {
        SourceFile sourceFile = editor.getSourceFile();
        sourceFile.parse();
        IRegion match = this.findDeclaration(sourceFile, searchString);
        if (match != null) {
            editor.getSite().getPage().activate((IWorkbenchPart)editor);
            editor.selectAndReveal(match.getOffset(), match.getLength());
            return Result.found();
        }
        return Result.notFound(searchString);
    }

    private Result searchExternalFile(File moduleFile, String searchString) throws CoreException {
        try {
            SourceFile sourceFile = new SourceFile(this.getLog(), this.getSourceDocument(moduleFile));
            sourceFile.parse();
            IRegion match = this.findDeclaration(sourceFile, searchString);
            return match != null ? Result.found() : Result.notFound(searchString);
        }
        catch (IOException e) {
            this.getLog().log((IStatus)new Status(4, PerlEditorPlugin.getPluginId(), 0, "Could not read module file " + moduleFile.getAbsolutePath(), (Throwable)e));
            return Result.exception();
        }
    }

    private Result searchInRequires(String searchString, File fromDir, IDocument source, Set visitedFiles) throws CoreException {
        File[] requiredFiles = this.findRequiredFiles(fromDir, source);
        int i = 0;
        while (i < requiredFiles.length) {
            if (!visitedFiles.contains(requiredFiles[i])) {
                visitedFiles.add(requiredFiles[i]);
                Result res = this.searchModuleFile(requiredFiles[i], searchString);
                if (res.isFound()) {
                    return res;
                }
                try {
                    res = this.searchInRequires(searchString, requiredFiles[i].getParentFile(), this.getSourceDocument(requiredFiles[i]), visitedFiles);
                    if (res.isFound()) {
                        return res;
                    }
                }
                catch (IOException e) {
                    this.getLog().log((IStatus)new Status(4, PerlEditorPlugin.getPluginId(), 0, "Could not read module file " + requiredFiles[i].getAbsolutePath(), (Throwable)e));
                    return Result.exception();
                }
            }
            ++i;
        }
        return Result.notFound(searchString);
    }

    private Result searchModuleFile(File moduleFile, String searchString) throws CoreException {
        IPath path = Path.fromOSString((String)moduleFile.getAbsolutePath());
        IFile fileInWorkspace = this.getProject().getProject().getWorkspace().getRoot().getFileForLocation(path);
        if (fileInWorkspace != null) {
            return this.searchModuleFile(moduleFile, fileInWorkspace, searchString);
        }
        Result res = this.searchExternalFile(moduleFile, searchString);
        if (res.isFound()) {
            FileEditorInput input = FileUtilities.getFileEditorInput(path);
            PerlEditor newEditor = (PerlEditor)this.getEditor().getSite().getPage().openEditor((IEditorInput)input, this.getEditor().getSite().getId());
            return this.searchEditor(newEditor, searchString);
        }
        return res;
    }

    private Result searchModuleFile(File moduleFile, IFile fileInWorkspace, String searchString) throws CoreException {
        IWorkbenchPage page = this.getEditor().getSite().getPage();
        IEditorPart editor = page.findEditor((IEditorInput)new FileEditorInput(fileInWorkspace));
        if (editor instanceof PerlEditor) {
            return this.searchEditor((PerlEditor)editor, searchString);
        }
        Result res = this.searchExternalFile(moduleFile, searchString);
        if (!res.isFound()) {
            return res;
        }
        try {
            FileEditorInput input = new FileEditorInput(fileInWorkspace);
            PerlEditor newEditor = (PerlEditor)this.getEditor().getSite().getPage().openEditor((IEditorInput)input, this.getEditor().getSite().getId());
            return this.searchEditor(newEditor, searchString);
        }
        catch (PartInitException e) {
            this.getLog().log((IStatus)new Status(4, PerlEditorPlugin.getPluginId(), 0, "Problems encountered while opening editor for " + moduleFile.getAbsolutePath(), (Throwable)e));
            return Result.exception();
        }
    }

    public static class Result {
        public static final int FOUND = 0;
        public static final int NOT_FOUND = 1;
        public static final int MODULE_NOT_FOUND = 2;
        public static final int INVALID_SEARCH = 3;
        public static final int EXCEPTION = 4;
        public final int statusCode;
        public final String searchString;
        public final String targetModule;
        public final File moduleFile;

        private Result(int statusCode, String searchString, String targetModule, File moduleFile) {
            this.statusCode = statusCode;
            this.searchString = searchString;
            this.targetModule = targetModule;
            this.moduleFile = moduleFile;
        }

        public boolean isFound() {
            return this.statusCode == 0;
        }

        public static Result exception() {
            return new Result(4, null, null, null);
        }

        public static Result found() {
            return new Result(0, null, null, null);
        }

        public static Result invalidSearch() {
            return new Result(3, null, null, null);
        }

        public static Result moduleNotFound(String targetModule) {
            return new Result(2, null, targetModule, null);
        }

        public static Result notFound(String searchString) {
            return new Result(1, searchString, null, null);
        }
    }
}

