/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors.perl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.epic.core.model.ISourceElement;
import org.epic.core.util.PerlExecutor;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.editors.PerlPartitioner;
import org.epic.perleditor.editors.perl.SourceElement;
import org.epic.perleditor.editors.perl.SourceParser;
import org.epic.perleditor.templates.ContextType;
import org.epic.perleditor.templates.ContextTypeRegistry;
import org.epic.perleditor.templates.TemplateEngine;
import org.epic.perleditor.templates.perl.IPerlCompletionProposal;
import org.epic.perleditor.templates.perl.ModuleCompletionHelper;
import org.epic.perleditor.templates.perl.PerlCompletionProposalComparator;
import org.epic.perleditor.templates.perl.SubroutineEngine;
import org.epic.perleditor.templates.perl.VariableEngine;

public class PerlCompletionProcessor
implements IContentAssistProcessor {
    private static final IPerlCompletionProposal[] NO_PROPOSALS = new IPerlCompletionProposal[0];
    public static Pattern MODULE_PREFIX_PATTERN = Pattern.compile("([A-Za-z0-9_]+(::|->))+");
    public static Pattern VAR_PREFIX_PATTERN = Pattern.compile("\\$[A-Za-z0-9_]+(::|->)$");
    private final IContextInformationValidator fValidator = new Validator();
    private final PerlCompletionProposalComparator fComparator = new PerlCompletionProposalComparator();
    private final TextEditor fTextEditor;
    private final TemplateEngine fTemplateEngine;

    public PerlCompletionProcessor(TextEditor textEditor) {
        this.fTextEditor = textEditor;
        ContextType contextType = this.getContextType();
        this.fTemplateEngine = contextType != null ? new TemplateEngine(contextType) : null;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        IDocument document = viewer.getDocument();
        String lastTextLine = null;
        try {
            int lastLine = document.getLineOfOffset(documentOffset);
            lastTextLine = document.get(document.getLineOffset(lastLine), document.getLineLength(lastLine));
        }
        catch (BadLocationException badLocationException) {}
        String moduleNamePrefix = this.getModuleNamePrefix(lastTextLine);
        if (moduleNamePrefix != null) {
            return this.computeModuleNameProposals(viewer, documentOffset, moduleNamePrefix);
        }
        String className = this.getClassName(documentOffset, document);
        return className != null ? this.computeMethodProposals(viewer, documentOffset, className) : this.sort(PerlCompletionProcessor.concatenate(this.computeVariableProposals(viewer, documentOffset), this.computeTemplateProposals(viewer, documentOffset)));
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        String activationChars = PerlEditorPlugin.getDefault().getPreferenceStore().getString("CodeAssist.autoActivationChars");
        return activationChars.toCharArray();
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.fValidator;
    }

    public String getErrorMessage() {
        return null;
    }

    private ICompletionProposal[] computeMethodProposals(ITextViewer viewer, int documentOffset, String className) {
        List proposals = this.getProposalsForClassname(className);
        ContextType contextType = this.getContextType();
        if (contextType != null) {
            SubroutineEngine subroutineEngine = new SubroutineEngine(contextType);
            subroutineEngine.complete(viewer, documentOffset, proposals.toArray(new String[proposals.size()]));
            return subroutineEngine.getResults();
        }
        return new IPerlCompletionProposal[0];
    }

    private ICompletionProposal[] computeModuleNameProposals(ITextViewer viewer, int documentOffset, String moduleNamePrefix) {
        ModuleCompletionHelper completionHelper = ModuleCompletionHelper.getInstance();
        return completionHelper.getProposals(moduleNamePrefix, documentOffset, viewer);
    }

    private IPerlCompletionProposal[] computeTemplateProposals(ITextViewer viewer, int documentOffset) {
        this.fTemplateEngine.reset();
        this.fTemplateEngine.complete(viewer, documentOffset);
        return this.fTemplateEngine.getResults();
    }

    private IPerlCompletionProposal[] computeVariableProposals(ITextViewer viewer, int documentOffset) {
        if (!PerlEditorPlugin.getDefault().getPreferenceStore().getBoolean("CodeAssist.inspectVariables")) {
            return NO_PROPOSALS;
        }
        ContextType contextType = this.getContextType();
        if (contextType == null) {
            return NO_PROPOSALS;
        }
        Set variables = this.getCompletionVariables(viewer, documentOffset);
        VariableEngine varsEngine = new VariableEngine(contextType);
        varsEngine.complete(viewer, documentOffset, variables.toArray(new String[variables.size()]));
        return varsEngine.getResults();
    }

    private Set getCompletionVariables(ITextViewer viewer, int documentOffset) {
        List variablesModel = new ArrayList();
        HashSet<String> variables = new HashSet<String>();
        String variableChars = "%$@";
        String filehandleChars = "<";
        try {
            documentOffset = this.getCompletionStartOffset(viewer.getDocument(), documentOffset, String.valueOf(variableChars) + filehandleChars);
            if (documentOffset < viewer.getDocument().getLength()) {
                String key = viewer.getDocument().get(documentOffset, 1);
                if (variableChars.indexOf(key) != -1) {
                    variablesModel = this.getVariableElements(viewer, documentOffset);
                } else if (filehandleChars.indexOf(key) != -1) {
                    variablesModel = SourceParser.getElements(viewer.getDocument(), "open[a-z]*\\s*?\\s*?[(]\\s*?([A-Z_0-9]+)\\s*?[,]", "<", ">", true);
                }
            }
            for (ISourceElement elem : variablesModel) {
                String name = elem.getName();
                if (variables.contains(name)) continue;
                variables.add(name);
                if (name.startsWith("@")) {
                    variables.add("$" + name.substring(1) + "[]");
                    continue;
                }
                if (!name.startsWith("%")) continue;
                variables.add("$" + name.substring(1) + "{}");
            }
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        return variables;
    }

    private List getVariableElements(ITextViewer viewer, int documentOffset) throws BadLocationException {
        IDocument doc = viewer.getDocument();
        IDocumentPartitioner p = ((IDocumentExtension3)doc).getDocumentPartitioner("org.epic.perleditor.perlPartitioning");
        if (!(p instanceof PerlPartitioner)) {
            return Collections.EMPTY_LIST;
        }
        ITypedRegion[] regions = ((PerlPartitioner)p).computePartitioning(0, documentOffset);
        ArrayList<SourceElement> elements = new ArrayList<SourceElement>();
        int i = 0;
        while (i < regions.length) {
            String name;
            if (regions[i].getType().equals("VARIABLE") && ((name = doc.get(regions[i].getOffset(), regions[i].getLength())).length() <= 1 || name.charAt(1) != '{')) {
                elements.add(new SourceElement(name, regions[i].getOffset(), regions[i].getLength()));
            }
            ++i;
        }
        return elements;
    }

    private String getClassName(int documentOffset, IDocument document) {
        String text;
        block6: {
            documentOffset = this.getCompletionStartOffset(document, documentOffset, "_");
            text = document.get(0, documentOffset);
            if (text.endsWith("->") || text.endsWith("::")) break block6;
            return null;
        }
        try {
            int lineNo = document.getLineOfOffset(documentOffset);
            String line = text.substring(document.getLineOffset(lineNo));
            if (VAR_PREFIX_PATTERN.matcher(line).find()) {
                String objName = line.substring(line.lastIndexOf(36));
                objName = objName.indexOf("->") != -1 ? objName.substring(0, objName.indexOf("->")) : objName.substring(0, objName.indexOf("::"));
                Pattern p = Pattern.compile("\\" + objName + "\\s*=\\s*([a-zA-Z:->0-9_]+)(->|::|;)");
                Matcher m = p.matcher(text);
                String className = null;
                while (m.find()) {
                    className = m.group(1);
                }
                return className;
            }
            Matcher m = MODULE_PREFIX_PATTERN.matcher(line);
            if (m.find()) {
                String str = m.group(0);
                return str.substring(0, str.length() - 2);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private List getProposalsForClassname(String className) {
        String perlCode = "use " + className + ";\n\n" + "foreach $name (sort keys %" + className + "::) {\n" + " next if($name !~ /[a-z]/ || $name =~ /^_/);\n" + "   if(defined &{\"" + className + "::$name\"}) {\n" + "       print \"$name()\\n\";\n" + "   }\n" + "   else {\n" + "       #print \"$name\\n\";\n" + "   }\n" + "}\n";
        PerlExecutor executor = new PerlExecutor();
        try {
            List list = executor.execute((ITextEditor)this.fTextEditor, null, perlCode).getStdoutLines();
            return list;
        }
        catch (CoreException e) {
            PerlEditorPlugin.getDefault().getLog().log(e.getStatus());
            ArrayList arrayList = new ArrayList();
            return arrayList;
        }
        finally {
            executor.dispose();
        }
    }

    private IPerlCompletionProposal[] sort(IPerlCompletionProposal[] proposals) {
        Arrays.sort(proposals, this.fComparator);
        return proposals;
    }

    private int getCompletionStartOffset(IDocument document, int caretOffset, String specialChars) throws BadLocationException {
        while (this.stepLeft(document, caretOffset, specialChars)) {
            --caretOffset;
        }
        if (this.stepLeft(document, caretOffset, specialChars)) {
            --caretOffset;
        }
        return caretOffset;
    }

    private ContextType getContextType() {
        return ContextTypeRegistry.getInstance().getContextType("perl");
    }

    private String getModuleNamePrefix(String line) {
        Pattern pattern = Pattern.compile(".*use\\s*(.*)$", 40);
        Matcher matcher = pattern.matcher(line);
        return matcher.matches() ? matcher.group(1) : null;
    }

    private boolean stepLeft(IDocument doc, int offset, String specialChars) throws BadLocationException {
        return offset != 0 && (Character.isUnicodeIdentifierPart(doc.getChar(offset - 1)) || specialChars.indexOf(doc.getChar(offset - 1)) != -1);
    }

    private static IPerlCompletionProposal[] concatenate(IPerlCompletionProposal[] a, IPerlCompletionProposal[] b) {
        IPerlCompletionProposal[] result = new IPerlCompletionProposal[b.length + a.length];
        System.arraycopy(b, 0, result, 0, b.length);
        System.arraycopy(a, 0, result, b.length, a.length);
        return result;
    }

    private static class Validator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        protected int fInstallOffset;

        private Validator() {
        }

        public boolean isContextInformationValid(int offset) {
            return Math.abs(this.fInstallOffset - offset) < 5;
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            this.fInstallOffset = offset;
        }

        public boolean updatePresentation(int documentPosition, TextPresentation presentation) {
            return false;
        }
    }
}

