/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.epic.core.util.PerlExecutor;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.editors.util.PerlValidatorErrors;

abstract class PerlValidatorBase {
    private static final boolean DEBUG = true;
    private static int maxErrorsShown = 500;
    private static final int BUF_SIZE = 1024;
    private final ILog log;
    private final PerlValidatorErrors errors;
    private final PerlExecutor executor;

    protected PerlValidatorBase(ILog log, PerlExecutor executor) {
        this.log = log;
        this.executor = executor;
        this.errors = new PerlValidatorErrors();
    }

    public synchronized void validate(IResource resource, String sourceCode) throws CoreException {
        String perlOutput = this.runPerl(resource, sourceCode);
        this.printPerlOutput(perlOutput);
        this.clearAllUsedMarkers(resource);
        List lines = PerlValidatorBase.makeLinesList(perlOutput);
        boolean continued = false;
        int i = lines.size() - 1;
        while (i >= 0) {
            String line = (String)lines.get(i);
            if (line.startsWith(" ")) {
                continued = true;
            } else {
                if (continued) {
                    line = String.valueOf(line) + lines.get(i + 1);
                }
                continued = false;
                ParsedErrorLine pline = new ParsedErrorLine(line, this.log);
                IResource errorResource = this.getErrorResource(pline, resource);
                if (!this.shouldIgnore(pline, errorResource)) {
                    PerlValidatorErrors.ErrorMessage errorMsg = this.errors.getErrorMessage(pline.getMessage());
                    Integer lineNr = new Integer(pline.getLineNumber());
                    HashMap<String, Object> attributes = new HashMap<String, Object>(11);
                    attributes.put("severity", errorMsg.getSeverity());
                    attributes.put("org.epic.marker.printfPerlErrorMessage", errorMsg.getExplanation());
                    if (!pline.isLocalError() && errorResource == resource) {
                        attributes.put("message", String.valueOf(pline.getMessage()) + " in " + pline.getPath() + " line " + lineNr);
                    } else {
                        attributes.put("message", pline.getMessage());
                        attributes.put("lineNumber", lineNr);
                        if (this.shouldUnderlineError(errorResource, pline.getLineNumber())) {
                            try {
                                String errorSourceCode = errorResource == resource ? sourceCode : this.readSourceFile(errorResource);
                                this.underlineError(errorResource, errorSourceCode, pline.getLineNumber(), attributes);
                            }
                            catch (IOException e) {
                                Status status = new Status(4, PerlEditorPlugin.getPluginId(), 0, "Could not read source file of resource: " + errorResource.getLocation() + ". Error markers will " + "be incorrect for this resource.", (Throwable)e);
                                throw new CoreException((IStatus)status);
                            }
                        }
                    }
                    this.addMarker(errorResource, attributes);
                }
            }
            --i;
        }
        this.removeUnusedMarkers(resource);
    }

    protected abstract void addMarker(IResource var1, Map var2);

    protected abstract void clearAllUsedMarkers(IResource var1);

    protected IResource getErrorResource(ParsedErrorLine line, IResource resource) {
        return line.isLocalError() ? resource : null;
    }

    protected List getPerlArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-c");
        return args;
    }

    protected abstract boolean isProblemMarkerPresent(ParsedErrorLine var1, IResource var2);

    protected String readSourceFile(String path) throws IOException {
        String string;
        block8: {
            BufferedReader in = null;
            try {
                StringWriter sourceCode = new StringWriter();
                char[] buf = new char[1024];
                in = new BufferedReader(new FileReader(path));
                int read = 0;
                while ((read = in.read(buf)) > 0) {
                    sourceCode.write(buf, 0, read);
                }
                string = sourceCode.toString();
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return string;
    }

    protected String readSourceFile(IResource resource) throws IOException {
        return this.readSourceFile(resource.getLocation().makeAbsolute().toString());
    }

    protected abstract void removeUnusedMarkers(IResource var1);

    protected abstract boolean shouldUnderlineError(IResource var1, int var2);

    private static List makeLinesList(String perlOutput) {
        ArrayList<String> lines = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(perlOutput, "\r\n");
        int lineCount = 0;
        while (st.hasMoreTokens() && lineCount < maxErrorsShown) {
            lines.add(st.nextToken());
            ++lineCount;
        }
        return lines;
    }

    private void printPerlOutput(String perlOutput) {
        if (perlOutput.indexOf("syntax OK") == -1) {
            System.out.println("-----------------------------------------");
            System.out.println("           OUTPUT");
            System.out.println("-----------------------------------------");
            System.out.println(perlOutput);
            System.out.println("-----------------------------------------");
        }
    }

    private boolean shouldIgnore(ParsedErrorLine line, IResource resource) {
        if (line.getLineNumber() < 0) {
            return true;
        }
        if (this.isProblemMarkerPresent(line, resource)) {
            return true;
        }
        return line.getMessage().indexOf("BEGIN failed--compilation aborted") == 0;
    }

    private String runPerl(IResource resource, String sourceCode) throws CoreException {
        return this.executor.execute((IResource)resource, (List)this.getPerlArgs(), (String)sourceCode).stderr;
    }

    private void underlineError(IResource resource, String sourceCode, int lineNo, Map attributes) {
        int lineOffset = 0;
        try {
            Document document = new Document(sourceCode);
            lineOffset = document.getLineOffset(lineNo - 1);
        }
        catch (BadLocationException e) {
            this.log.log((IStatus)new Status(4, PerlEditorPlugin.getPluginId(), 0, "Unexpected exception in PerlValidator.underlineError: " + resource.getFullPath() + ", lineNo: " + lineNo + "; report it as bug in plug-in " + PerlEditorPlugin.getPluginId(), (Throwable)e));
        }
        int endOfLine = sourceCode.indexOf("\n", lineOffset);
        String markerLine = endOfLine != -1 ? sourceCode.substring(lineOffset, endOfLine) : sourceCode.substring(lineOffset);
        char[] bytes = markerLine.toCharArray();
        int start = 0;
        while (start < bytes.length) {
            if (bytes[start] != '\t' && bytes[start] != ' ') break;
            ++start;
        }
        int end = (start += lineOffset) + markerLine.trim().length();
        attributes.put("charStart", new Integer(start));
        attributes.put("charEnd", new Integer(end));
    }

    protected static class ParsedErrorLine {
        private static final Pattern errorLineNoPattern = Pattern.compile("^(.*) at (\\S+) line (\\d+)[\\.,]");
        private static final Pattern cgiCarpPattern = Pattern.compile("^\\[.*?\\] \\S+: (.*)");
        private final ILog log;
        private final String line;
        private final String msg;
        private final String path;
        private final int lineNo;

        public ParsedErrorLine(String line, ILog log) {
            this.line = line;
            this.log = log;
            Matcher m = errorLineNoPattern.matcher(line);
            if (m.find()) {
                this.msg = this.normalizeMsg(m.group(1));
                this.path = m.group(2);
                this.lineNo = this.parseInt(m.group(3));
            } else {
                this.msg = this.normalizeMsg(line);
                this.path = "-";
                this.lineNo = -1;
            }
        }

        public int getLineNumber() {
            return this.lineNo;
        }

        public String getMessage() {
            return this.msg;
        }

        public String getPath() {
            return this.path;
        }

        public boolean isLocalError() {
            return "-".equals(this.path);
        }

        public String toString() {
            return String.valueOf(this.msg) + ", " + this.path + ":" + this.lineNo;
        }

        private int parseInt(String str) {
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                this.log.log((IStatus)new Status(4, PerlEditorPlugin.getPluginId(), 0, "Could not parse line number contained in Perl error message {" + this.line + "}; report it as a bug " + "in plug-in " + PerlEditorPlugin.getPluginId(), (Throwable)e));
                return -1;
            }
        }

        private String normalizeMsg(String msg) {
            return this.stripCGICarpOutput(msg);
        }

        private String stripCGICarpOutput(String msg) {
            Matcher m;
            if (msg.startsWith("[") && (m = cgiCarpPattern.matcher(msg)).find()) {
                return m.group(1);
            }
            return msg;
        }
    }
}

