/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.templates.perl;

import java.text.DateFormat;
import java.util.Calendar;
import org.eclipse.ui.PlatformUI;
import org.epic.core.util.PerlExecutableUtilities;
import org.epic.perleditor.templates.SimpleTemplateVariable;
import org.epic.perleditor.templates.TemplateContext;
import org.epic.perleditor.templates.perl.PerlTemplateMessages;

public class GlobalVariables {

    static class Cursor
    extends SimpleTemplateVariable {
        public Cursor() {
            super(PerlTemplateMessages.getString("GlobalVariables.variable.name.cursor"), PerlTemplateMessages.getString("GlobalVariables.variable.description.cursor"));
            this.setEvaluationString("");
            this.setResolved(true);
        }
    }

    static class Date
    extends SimpleTemplateVariable {
        public Date() {
            super(PerlTemplateMessages.getString("GlobalVariables.variable.name.date"), PerlTemplateMessages.getString("GlobalVariables.variable.description.date"));
            this.setResolved(true);
        }

        @Override
        public String evaluate(TemplateContext context) {
            return DateFormat.getDateInstance().format(new java.util.Date());
        }
    }

    static class Dollar
    extends SimpleTemplateVariable {
        public Dollar() {
            super(PerlTemplateMessages.getString("GlobalVariables.variable.name.dollar"), PerlTemplateMessages.getString("GlobalVariables.variable.description.dollar"));
            this.setEvaluationString("$");
            this.setResolved(true);
        }
    }

    static class Filename
    extends SimpleTemplateVariable {
        public Filename() {
            super(PerlTemplateMessages.getString("GlobalVariables.variable.name.filename"), PerlTemplateMessages.getString("GlobalVariables.variable.description.filename"));
            this.setResolved(true);
        }

        @Override
        public String evaluate(TemplateContext context) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getTitle();
        }
    }

    static class PerlInterpreter
    extends SimpleTemplateVariable {
        public PerlInterpreter() {
            super(PerlTemplateMessages.getString("GlobalVariables.variable.name.perlInterpreter"), PerlTemplateMessages.getString("GlobalVariables.variable.description.perlInterpreter"));
            this.setResolved(true);
        }

        @Override
        public String evaluate(TemplateContext context) {
            return (String)PerlExecutableUtilities.getPerlCommandLine().get(0);
        }
    }

    static class Time
    extends SimpleTemplateVariable {
        public Time() {
            super(PerlTemplateMessages.getString("GlobalVariables.variable.name.time"), PerlTemplateMessages.getString("GlobalVariables.variable.description.time"));
            this.setResolved(true);
        }

        @Override
        public String evaluate(TemplateContext context) {
            return DateFormat.getTimeInstance().format(new java.util.Date());
        }
    }

    static class User
    extends SimpleTemplateVariable {
        public User() {
            super(PerlTemplateMessages.getString("GlobalVariables.variable.name.user"), PerlTemplateMessages.getString("GlobalVariables.variable.description.user"));
            this.setResolved(true);
        }

        @Override
        public String evaluate(TemplateContext context) {
            return System.getProperty("user.name");
        }
    }

    static class Year
    extends SimpleTemplateVariable {
        public Year() {
            super(PerlTemplateMessages.getString("GlobalVariables.variable.name.year"), PerlTemplateMessages.getString("GlobalVariables.variable.description.year"));
            this.setResolved(true);
        }

        @Override
        public String evaluate(TemplateContext context) {
            return Integer.toString(Calendar.getInstance().get(1));
        }
    }
}

