/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.views;

import java.io.File;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.ITextEditor;
import org.epic.core.util.PerlExecutor;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.PerlPluginImages;
import org.epic.perleditor.popupmenus.PopupMessages;
import org.epic.perleditor.views.PerlDocViewMessages;

public class PerlDocView
extends ViewPart {
    private Button searchPerldocButton;
    private Text searchPerldocText;
    private Display display;
    private TabFolder tabFolder;
    private FindReplaceAction findReplaceAction;
    private static int ITEM_COUNT = 4;
    private static String[] searchOptions = new String[]{"-t -f", "-t -q", "-t", "-m"};
    private static String[] tabItemsLabels = new String[]{"Builtin Function", "FAQ", "Module", "Module Source"};
    private boolean[] foundItems = new boolean[4];
    private SourceViewer[] sourceViewers = new SourceViewer[4];
    private TabItem[] tabItems = new TabItem[4];
    private final FindReplaceTarget findReplaceTarget = new FindReplaceTarget();
    private final IPropertyChangeListener fontPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals(PerlDocView.this.getFontPropertyPreferenceKey())) {
                Font textFont = JFaceResources.getFontRegistry().get(PerlDocView.this.getFontPropertyPreferenceKey());
                int i = 0;
                while (i < PerlDocView.this.sourceViewers.length) {
                    PerlDocView.this.sourceViewers[i].getTextWidget().setFont(textFont);
                    ++i;
                }
            }
        }
    };

    public PerlDocView() {
        JFaceResources.getFontRegistry().addListener(this.fontPropertyChangeListener);
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getDisplay();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        parent.setLayout((Layout)gridLayout);
        new Label(parent, 0).setText("Search:");
        this.searchPerldocText = new Text(parent, 2048);
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        this.searchPerldocText.setLayoutData((Object)gridData);
        this.searchPerldocButton = new Button(parent, 0x800008);
        this.searchPerldocButton.setImage(PerlPluginImages.get("org.epic.perleditor.search.gif"));
        this.searchPerldocButton.setToolTipText("Search Perldoc");
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        Font textFont = JFaceResources.getFontRegistry().get(this.getFontPropertyPreferenceKey());
        this.tabFolder = new TabFolder(parent, 2048);
        int i = 0;
        while (i < this.sourceViewers.length) {
            this.sourceViewers[i] = new SourceViewer((Composite)this.tabFolder, null, 770);
            this.sourceViewers[i].setEditable(false);
            this.sourceViewers[i].getTextWidget().setFont(textFont);
            ++i;
        }
        gridData = new GridData(272);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 6;
        this.tabFolder.setLayoutData((Object)gridData);
        parent.pack();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                Widget item = event.widget;
                if (item == PerlDocView.this.searchPerldocButton) {
                    PerlDocView.this.search();
                }
            }
        };
        KeyAdapter keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                Widget item = event.widget;
                switch (event.keyCode) {
                    case 13: {
                        if (item != PerlDocView.this.searchPerldocText) break;
                        PerlDocView.this.search();
                    }
                }
            }
        };
        this.searchPerldocButton.addListener(13, listener);
        this.searchPerldocText.addKeyListener((KeyListener)keyListener);
        this.createActions();
    }

    public void dispose() {
        PerlEditorPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fontPropertyChangeListener);
        super.dispose();
    }

    public Object getAdapter(Class required) {
        if (IFindReplaceTarget.class.equals((Object)required)) {
            return this.findReplaceTarget;
        }
        return null;
    }

    public String getDisplayedText(int tabNo) {
        return this.sourceViewers[tabNo].getTextWidget().getText();
    }

    public void search() {
        try {
            this.search(this.searchPerldocText.getText());
        }
        catch (CoreException e) {
            PerlEditorPlugin.getDefault().getLog().log(e.getStatus());
        }
    }

    public void search(String searchText) throws CoreException {
        this.search(searchText, null);
    }

    public void search(String searchText, ITextEditor textEditor) throws CoreException {
        if (searchText.trim().length() == 0) {
            return;
        }
        if (!this.searchPerldocText.getText().equals(searchText)) {
            this.searchPerldocText.setText(searchText);
        }
        int itemsFound = 0;
        int i = 0;
        while (i < ITEM_COUNT) {
            String result = this.getPerlDoc(searchOptions[i], searchText, textEditor);
            this.sourceViewers[i].setDocument((IDocument)new Document(result));
            this.foundItems[i] = result.length() > 0;
            itemsFound += result.length() > 0 ? 1 : 0;
            ++i;
        }
        i = 0;
        while (i < ITEM_COUNT) {
            if (this.tabItems[i] != null) {
                this.tabItems[i].dispose();
                this.tabItems[i] = null;
            }
            ++i;
        }
        i = 0;
        while (i < ITEM_COUNT) {
            if (this.foundItems[i]) {
                this.tabItems[i] = new TabItem(this.tabFolder, 0);
                this.tabItems[i].setText(tabItemsLabels[i]);
                this.tabItems[i].setControl(this.sourceViewers[i].getControl());
            }
            ++i;
        }
        i = 0;
        while (i < ITEM_COUNT) {
            if (this.foundItems[i]) {
                this.tabItems[i].getControl().setFocus();
                break;
            }
            ++i;
        }
        if (itemsFound == 0) {
            MessageDialog.openInformation((Shell)this.display.getActiveShell(), (String)PopupMessages.getString("NoDocumentation.title"), (String)PopupMessages.getString("NoDocumentation.message"));
        }
        this.findReplaceAction.update();
    }

    private String getPerlDoc(String option, String searchText, ITextEditor textEditor) throws CoreException {
        String perlCode = "use Env qw(@PERL5LIB);\n\nsplice(@PERL5LIB, 0, 0, @INC);\nexec('perldoc " + option + " \"" + searchText + "\"');";
        PerlExecutor executor = new PerlExecutor();
        try {
            if (textEditor != null) {
                String string = executor.execute((ITextEditor)textEditor, null, (String)perlCode).stdout;
                return string;
            }
            String string = executor.execute((File)new File((String)new File((String)".").getCanonicalPath()), null, (String)perlCode).stdout;
            return string;
        }
        finally {
            executor.dispose();
        }
    }

    public void setFocus() {
    }

    private void createActions() {
        IActionBars actionBars = ((IViewSite)this.getSite()).getActionBars();
        ResourceBundle bundle = PerlDocViewMessages.getBundle();
        this.findReplaceAction = new FindReplaceAction(bundle, "find_replace_action_", (IWorkbenchPart)this);
        actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)this.findReplaceAction);
        actionBars.updateActionBars();
    }

    private String getFontPropertyPreferenceKey() {
        return "org.eclipse.jface.textfont";
    }

    private class FindReplaceTarget
    implements IFindReplaceTarget {
        private FindReplaceTarget() {
        }

        private IFindReplaceTarget getActiveTarget() {
            int selectedTab = PerlDocView.this.tabFolder.getSelectionIndex();
            if (selectedTab < 0) {
                return null;
            }
            TabItem[] selection = PerlDocView.this.tabFolder.getSelection();
            int i = 0;
            while (i < PerlDocView.this.sourceViewers.length) {
                if (selection[0].getControl() == PerlDocView.this.sourceViewers[i].getControl()) {
                    return PerlDocView.this.sourceViewers[i].getFindReplaceTarget();
                }
                ++i;
            }
            return null;
        }

        public boolean canPerformFind() {
            if (this.getActiveTarget() == null) {
                return false;
            }
            return this.getActiveTarget().canPerformFind();
        }

        public int findAndSelect(int widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
            return this.getActiveTarget().findAndSelect(widgetOffset, findString, searchForward, caseSensitive, wholeWord);
        }

        public Point getSelection() {
            return this.getActiveTarget().getSelection();
        }

        public String getSelectionText() {
            return this.getActiveTarget().getSelectionText();
        }

        public boolean isEditable() {
            return false;
        }

        public void replaceSelection(String text) {
            this.getActiveTarget().replaceSelection(text);
        }
    }
}

