/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.operations;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.commands.RevertResourcesCommand;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.operations.RepositoryProviderOperation;

public class RevertOperation
extends RepositoryProviderOperation {
    private boolean recurse = false;
    private IResource[] resourcesToRevert;
    private boolean canRunAsJob = true;

    public RevertOperation(IWorkbenchPart part, IResource[] resources) {
        super(part, resources);
    }

    protected String getTaskName() {
        return Policy.bind("RevertOperation.taskName");
    }

    protected String getTaskName(SVNTeamProvider provider) {
        return Policy.bind("RevertOperation.0", provider.getProject().getName());
    }

    protected void execute(SVNTeamProvider provider, IResource[] resources, IProgressMonitor monitor) throws SVNException, InterruptedException {
        block6: {
            monitor.beginTask(null, 100);
            try {
                try {
                    RevertResourcesCommand command = new RevertResourcesCommand(provider.getSVNWorkspaceRoot(), resources);
                    command.setRecurse(this.recurse);
                    command.setResourcesToRevert(this.resourcesToRevert);
                    command.setProject(provider.getProject());
                    command.run(Policy.subMonitorFor(monitor, 100));
                }
                catch (SVNException e) {
                    if (e.operationInterrupted()) {
                        this.showCancelledMessage();
                        break block6;
                    }
                    this.collectStatus(e.getStatus());
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    public void setRecurse(boolean recurse) {
        this.recurse = recurse;
    }

    public void setResourcesToRevert(IResource[] resourcesToRevert) {
        this.resourcesToRevert = resourcesToRevert;
    }

    protected boolean canRunAsJob() {
        return this.canRunAsJob;
    }

    public void setCanRunAsJob(boolean canRunAsJob) {
        this.canRunAsJob = canRunAsJob;
    }
}

