/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.properties;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNTreeConflict;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNConflictDescriptor;
import org.tigris.subversion.svnclientadapter.SVNConflictVersion;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNPropertyPage
extends PropertyPage {
    private Text urlValue;
    private Text revisionValue;
    private Text repositoryRootValue;
    private Text repositoryUuidValue;
    private Text statusValue;
    private Text propertiesValue;
    private Text copiedFromValue;
    private Text lastChangedRevisionValue;
    private Text lastChangedDateValue;
    private Text lastCommitAuthorValue;
    private Text lockOwner;
    private Text lockCreationDate;
    private Label lockComment;
    private Text treeConflict;
    private ISVNLocalResource svnResource;
    private LocalResourceStatus status;
    private SVNUrl urlCopiedFrom;
    private SVNRevision revision;
    private ISVNInfo info;
    private String lockOwnerText;
    private String lockDateText;
    private String lockCommentText;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        composite.setLayoutData((Object)data);
        this.getStatus();
        this.addFirstSection(composite);
        if (this.status != null) {
            this.addSeparator(composite);
            this.addSecondSection(composite);
            this.setValues();
        }
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.svn_resource_properties_page_context");
        return composite;
    }

    private void addFirstSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label label = new Label(composite, 0);
        label.setText(Policy.bind("SVNPropertyPage.path"));
        Text pathValue = new Text(composite, 72);
        GridData gd = new GridData();
        gd.widthHint = 500;
        pathValue.setLayoutData((Object)gd);
        pathValue.setText(((IResource)this.getElement()).getFullPath().toString());
        pathValue.setBackground(composite.getBackground());
        if (!(this.getElement() instanceof IContainer)) {
            label = new Label(composite, 0);
            label.setText(Policy.bind("SVNPropertyPage.name"));
            Text nameValue = new Text(composite, 72);
            gd = new GridData();
            gd.widthHint = 500;
            nameValue.setLayoutData((Object)gd);
            nameValue.setText(((IResource)this.getElement()).getName());
            nameValue.setBackground(composite.getBackground());
        }
        label = new Label(composite, 0);
        label.setText(Policy.bind("SVNPropertyPage.url"));
        this.urlValue = new Text(composite, 72);
        gd = new GridData();
        gd.widthHint = 500;
        this.urlValue.setLayoutData((Object)gd);
        this.urlValue.setBackground(composite.getBackground());
        label = new Label(composite, 0);
        label.setText(Policy.bind("SVNPropertyPage.repositoryRoot"));
        this.repositoryRootValue = new Text(composite, 72);
        gd = new GridData();
        gd.widthHint = 500;
        this.repositoryRootValue.setLayoutData((Object)gd);
        this.repositoryRootValue.setBackground(composite.getBackground());
        if (this.info != null && this.info.getUuid() != null) {
            label = new Label(composite, 0);
            label.setText(Policy.bind("SVNPropertyPage.uuid"));
            Text uuidValue = new Text(composite, 72);
            gd = new GridData();
            gd.widthHint = 500;
            uuidValue.setLayoutData((Object)gd);
            uuidValue.setBackground(composite.getBackground());
            uuidValue.setText(this.info.getUuid());
        }
        label = new Label(composite, 0);
        label.setText(Policy.bind("SVNPropertyPage.revision"));
        this.revisionValue = new Text(composite, 8);
        this.revisionValue.setBackground(composite.getBackground());
    }

    private void addSecondSection(Composite parent) {
        GridData gd;
        Composite composite = this.createDefaultComposite(parent);
        Label label = new Label(composite, 0);
        label.setText(Policy.bind("SVNPropertyPage.status"));
        this.statusValue = new Text(composite, 8);
        this.statusValue.setBackground(composite.getBackground());
        label = new Label(composite, 0);
        label.setText(Policy.bind("SVNPropertyPage.propStatus"));
        this.propertiesValue = new Text(composite, 8);
        this.propertiesValue.setBackground(composite.getBackground());
        if (this.urlCopiedFrom != null) {
            label = new Label(composite, 0);
            label.setText(Policy.bind("SVNPropertyPage.copiedFrom"));
            this.copiedFromValue = new Text(composite, 72);
            this.copiedFromValue.setBackground(composite.getBackground());
            gd = new GridData();
            gd.widthHint = 500;
            this.copiedFromValue.setLayoutData((Object)gd);
        }
        if (this.status.getLastChangedRevision() != null) {
            label = new Label(composite, 0);
            label.setText(Policy.bind("SVNPropertyPage.changedRevision"));
            this.lastChangedRevisionValue = new Text(composite, 8);
            this.lastChangedRevisionValue.setBackground(composite.getBackground());
            label = new Label(composite, 0);
            label.setText(Policy.bind("SVNPropertyPage.changedDate"));
            this.lastChangedDateValue = new Text(composite, 8);
            this.lastChangedDateValue.setBackground(composite.getBackground());
            label = new Label(composite, 0);
            label.setText(Policy.bind("SVNPropertyPage.changedAuthor"));
            this.lastCommitAuthorValue = new Text(composite, 8);
            this.lastCommitAuthorValue.setBackground(composite.getBackground());
        }
        if (this.lockOwnerText != null) {
            label = new Label(composite, 0);
            label.setText(Policy.bind("SVNPropertyPage.lockOwner"));
            this.lockOwner = new Text(composite, 8);
            this.lockOwner.setBackground(composite.getBackground());
            label = new Label(composite, 0);
            label.setText(Policy.bind("SVNPropertyPage.lockCreationDate"));
            this.lockCreationDate = new Text(composite, 8);
            this.lockCreationDate.setBackground(composite.getBackground());
            label = new Label(composite, 0);
            label.setText(Policy.bind("SVNPropertyPage.lockComment"));
            this.lockComment = new Label(composite, 64);
            gd = new GridData();
            gd.widthHint = 500;
            this.lockComment.setLayoutData((Object)gd);
        }
        if (this.status.hasTreeConflict()) {
            label = new Label(composite, 0);
            label.setText(Policy.bind("SVNPropertyPage.treeConflict"));
            this.treeConflict = new Text(composite, 8);
            this.treeConflict.setBackground(composite.getBackground());
            SVNConflictDescriptor conflictDescriptor = this.status.getConflictDescriptor();
            if (conflictDescriptor == null) {
                this.treeConflict.setText("true");
            } else {
                SVNConflictVersion srcRightVersion;
                SVNTreeConflict svnTreeConflict = new SVNTreeConflict((ISVNStatus)this.status);
                this.treeConflict.setText(svnTreeConflict.getDescription());
                SVNConflictVersion srcLeftVersion = svnTreeConflict.getConflictDescriptor().getSrcLeftVersion();
                if (srcLeftVersion != null) {
                    new Label(composite, 0);
                    Text srcLeftVersionValue = new Text(composite, 72);
                    GridData gd2 = new GridData();
                    gd2.widthHint = 500;
                    srcLeftVersionValue.setLayoutData((Object)gd2);
                    srcLeftVersionValue.setText("Source  left: " + srcLeftVersion.toString());
                    srcLeftVersionValue.setBackground(composite.getBackground());
                }
                if ((srcRightVersion = svnTreeConflict.getConflictDescriptor().getSrcRightVersion()) != null) {
                    new Label(composite, 0);
                    Text srcRightVersionValue = new Text(composite, 72);
                    GridData gd3 = new GridData();
                    gd3.widthHint = 500;
                    srcRightVersionValue.setLayoutData((Object)gd3);
                    srcRightVersionValue.setText("Source right: " + srcRightVersion.toString());
                    srcRightVersionValue.setBackground(composite.getBackground());
                }
            }
        }
    }

    private void addSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        return composite;
    }

    /*
     * Unable to fully structure code
     */
    private void getStatus() {
        block17: {
            block16: {
                block15: {
                    repository = null;
                    svnClient = null;
                    resource = (IResource)this.getElement();
                    svnProvider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)resource.getProject(), (String)SVNProviderPlugin.getTypeId());
                    if (svnProvider != null) break block15;
                    while (true) {
                        if (repository != null) {
                            repository.returnSVNClient(svnClient);
                        }
                        return;
                    }
                }
                try {
                    try {
                        this.svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                        if (this.svnResource == null) ** continue;
                        this.status = this.svnResource.getStatus();
                        repository = this.svnResource.getRepository();
                        svnClient = repository.getSVNClient();
                        info = svnClient.getInfoFromWorkingCopy(this.svnResource.getFile());
                        this.urlCopiedFrom = info.getCopyUrl();
                        this.revision = this.svnResource.getRevision();
                        this.lockOwnerText = this.status.getLockOwner();
                        this.lockCommentText = this.status.getLockComment();
                        if (this.status.getLockCreationDate() != null) {
                            this.lockDateText = this.status.getLockCreationDate().toString();
                        }
                        if (!this.status.isAdded()) {
                            try {
                                info = svnClient.getInfo(this.status.getUrl());
                            }
                            catch (Exception v0) {}
                        }
                        if (info == null || this.status.getLockOwner() != null || this.status.getUrlString() == null || (prop = this.svnResource.getSvnProperty("svn:needs-lock")) == null) break block16;
                        this.lockOwnerText = info.getLockOwner();
                        if (info.getLockCreationDate() != null) {
                            this.lockDateText = info.getLockCreationDate().toString();
                        }
                        this.lockCommentText = info.getLockComment();
                    }
                    catch (Exception e) {
                        SVNUIPlugin.log((IStatus)new Status(4, "org.tigris.subversion.subclipse.ui", -6, "Property Exception", (Throwable)e));
                    }
                }
                catch (Throwable var7_8) {
                    if (repository != null) {
                        repository.returnSVNClient(svnClient);
                    }
                    throw var7_8;
                }
            }
            if (repository != null) {
                repository.returnSVNClient(svnClient);
            }
            break block17;
            if (repository != null) {
                repository.returnSVNClient(svnClient);
            }
        }
    }

    private void setValues() {
        this.urlValue.setText(this.status.getUrlString() != null ? this.status.getUrlString() : "");
        this.repositoryRootValue.setText(this.svnResource.getRepository() != null ? this.svnResource.getRepository().getUrl().toString() : "");
        this.revisionValue.setText(this.revision != null ? this.revision.toString() : "");
        StringBuffer sb = new StringBuffer(this.status.getTextStatus().toString());
        if (this.status.isSwitched()) {
            sb.append(", switched");
        }
        if (this.status.isCopied()) {
            sb.append(", copied");
        }
        if (this.status.isTextMerged()) {
            sb.append(", merged");
        }
        if (this.status.hasTreeConflict()) {
            sb.append(", tree conflict");
        }
        this.statusValue.setText(sb.toString());
        this.propertiesValue.setText(this.status.getPropStatus().toString());
        if (this.urlCopiedFrom != null) {
            this.copiedFromValue.setText(this.urlCopiedFrom.toString());
        }
        if (this.status.getLastChangedRevision() != null) {
            this.lastChangedRevisionValue.setText(this.status.getLastChangedRevision() != null ? this.status.getLastChangedRevision().toString() : "");
            this.lastChangedDateValue.setText(this.status.getLastChangedDate() != null ? this.status.getLastChangedDate().toString() : "");
            this.lastCommitAuthorValue.setText(this.status.getLastCommitAuthor() != null ? this.status.getLastCommitAuthor() : "");
        }
        if (this.lockOwnerText != null) {
            this.lockOwner.setText(this.lockOwnerText);
        }
        if (this.lockDateText != null) {
            this.lockCreationDate.setText(this.lockDateText);
        }
        if (this.lockCommentText != null) {
            this.lockComment.setText(this.lockCommentText);
        }
    }

    protected void performDefaults() {
    }

    public boolean performOk() {
        return true;
    }
}

