/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.commands.RevertResourcesCommand;
import org.tigris.subversion.subclipse.core.commands.UpdateResourcesCommand;
import org.tigris.subversion.subclipse.core.sync.SVNStatusSyncInfo;
import org.tigris.subversion.subclipse.core.sync.SVNWorkspaceSubscriber;
import org.tigris.subversion.subclipse.core.util.Assert;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.conflicts.SVNConflictResolver;
import org.tigris.subversion.subclipse.ui.subscriber.SVNSynchronizeOperation;
import org.tigris.subversion.svnclientadapter.ISVNConflictResolver;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class OverrideAndUpdateSynchronizeOperation
extends SVNSynchronizeOperation {
    private IResource[] modifiedResources;
    private IResource[] resources;
    private boolean revertAndUpdate = true;
    private boolean prompted;
    private List<IStatus> errors = new ArrayList<IStatus>();
    public static final int PROGRESS_DIALOG = 1;
    public static final int PROGRESS_BUSYCURSOR = 2;

    public OverrideAndUpdateSynchronizeOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements, IResource[] modifiedResources, IResource[] resources) {
        super(configuration, elements);
        this.modifiedResources = modifiedResources;
        this.resources = resources;
    }

    protected boolean promptForConflictHandling(Shell shell, SyncInfoSet syncSet) {
        return true;
    }

    protected void run(SVNTeamProvider provider, SyncInfoSet set, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (!this.revertAndUpdate) {
            return;
        }
        if (!this.prompted) {
            this.getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    OverrideAndUpdateSynchronizeOperation.this.revertAndUpdate = MessageDialog.openQuestion((Shell)OverrideAndUpdateSynchronizeOperation.this.getShell(), (String)Policy.bind("SyncAction.override.title"), (String)Policy.bind("SyncAction.override.confirm"));
                }
            });
            this.prompted = true;
        }
        if (!this.revertAndUpdate) {
            return;
        }
        IResource[] modifiedResourceArray = this.extractResources(this.modifiedResources, set);
        IResource[] resourceArray = this.extractResources(this.resources, set);
        if (modifiedResourceArray != null && modifiedResourceArray.length > 0) {
            monitor.beginTask(null, 100);
            try {
                try {
                    new RevertResourcesCommand(provider.getSVNWorkspaceRoot(), modifiedResourceArray).run(Policy.subMonitorFor(monitor, 100));
                }
                catch (SVNException e) {
                    this.collectStatus(e.getStatus());
                }
            }
            finally {
                monitor.done();
            }
        }
        if (monitor.isCanceled()) {
            return;
        }
        SVNRevision revision = SVNRevision.HEAD;
        monitor.beginTask(null, 100);
        try {
            try {
                IResource[] incomingResources = this.getIncoming(resourceArray);
                SVNWorkspaceSubscriber.getInstance().updateRemote(incomingResources);
                UpdateResourcesCommand command = new UpdateResourcesCommand(provider.getSVNWorkspaceRoot(), incomingResources, revision);
                command.setConflictResolver((ISVNConflictResolver)new SVNConflictResolver());
                command.run(Policy.subMonitorFor(monitor, 100));
            }
            catch (SVNException e) {
                this.collectStatus(e.getStatus());
            }
            catch (TeamException e) {
                this.collectStatus(e.getStatus());
            }
        }
        finally {
            monitor.done();
        }
    }

    protected boolean canRunAsJob() {
        return true;
    }

    protected String getJobName() {
        return Policy.bind("SyncAction.override.title");
    }

    private IResource[] getIncoming(IResource[] resources) throws TeamException {
        ArrayList<IResource> incomingResources = new ArrayList<IResource>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            SVNStatusSyncInfo info = (SVNStatusSyncInfo)SVNWorkspaceSubscriber.getInstance().getSyncInfo(resource);
            if (info != null && (SyncInfo.getDirection((int)info.getKind()) == 8 || SyncInfo.getDirection((int)info.getKind()) == 12)) {
                incomingResources.add(resource);
            }
            ++i;
        }
        IResource[] incomingArray = new IResource[incomingResources.size()];
        incomingResources.toArray(incomingArray);
        return incomingArray;
    }

    private void collectStatus(IStatus status) {
        if (this.isLastError(status)) {
            return;
        }
        if (!status.isOK()) {
            this.addError(status);
        }
    }

    private boolean isLastError(IStatus status) {
        return this.errors.size() > 0 && this.getLastError() == status;
    }

    private void addError(IStatus status) {
        if (status.isOK()) {
            return;
        }
        if (this.isLastError(status)) {
            return;
        }
        this.errors.add(status);
    }

    private IStatus getLastError() {
        Assert.isTrue((this.errors.size() > 0 ? 1 : 0) != 0);
        IStatus status = this.errors.get(this.errors.size() - 1);
        return status;
    }
}

