/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.utils;

import java.net.MalformedURLException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNUrlUtils {
    public static SVNUrl getCommonRootUrl(SVNUrl url1, SVNUrl url2) {
        String[] segs2;
        if (!url1.getProtocol().equals(url2.getProtocol()) || !url1.getHost().equals(url2.getHost()) || url1.getPort() != url2.getPort()) {
            return null;
        }
        String url = String.valueOf(url1.getProtocol()) + "://" + url1.getHost() + ":" + url1.getPort();
        String[] segs1 = url1.getPathSegments();
        int minLength = segs1.length >= (segs2 = url2.getPathSegments()).length ? segs2.length : segs1.length;
        int i = 0;
        while (i < minLength) {
            if (!segs1[i].equals(segs2[i])) break;
            url = String.valueOf(url) + "/" + segs1[i];
            ++i;
        }
        try {
            return new SVNUrl(url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static SVNUrl getCommonRootUrl(SVNUrl[] urls) {
        SVNUrl commonRoot = urls[0];
        int i = 0;
        while (i < urls.length) {
            if ((commonRoot = SVNUrlUtils.getCommonRootUrl(commonRoot, urls[i])) == null) {
                return null;
            }
            ++i;
        }
        return commonRoot;
    }

    public static String getRelativePath(SVNUrl rootUrl, SVNUrl url) {
        return SVNUrlUtils.getRelativePath(rootUrl, url, false);
    }

    public static String getRelativePath(SVNUrl rootUrl, SVNUrl url, boolean includeStartingSlash) {
        String rootUrlStr = rootUrl.toString();
        String urlStr = url.toString();
        if (urlStr.indexOf(rootUrlStr) == -1) {
            return null;
        }
        if (urlStr.length() == rootUrlStr.length()) {
            return "";
        }
        return urlStr.substring(rootUrlStr.length() + (includeStartingSlash ? 0 : 1));
    }

    public static SVNUrl getUrlFromLocalFileName(String localFileName, SVNUrl parentUrl, String parentPathName) {
        return SVNUrlUtils.getUrlFromLocalFileName(localFileName, parentUrl.toString(), parentPathName);
    }

    public static SVNUrl getUrlFromLocalFileName(String localFileName, String parentUrl, String parentPathName) {
        String localFile;
        String parentPath;
        block5: {
            parentPath = parentPathName.indexOf(92) > 0 ? parentPathName.replaceAll("\\\\", "/") : parentPathName;
            localFile = localFileName.indexOf(92) > 0 ? localFileName.replaceAll("\\\\", "/") : localFileName;
            try {
                if (localFile.indexOf(parentPath) == 0) break block5;
                return null;
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        if (localFile.length() == parentPath.length()) {
            return new SVNUrl(parentUrl);
        }
        char lastChar = parentPath.charAt(parentPath.length() - 1);
        String relativeFileName = localFile.substring(parentPath.length() + (lastChar != '\\' && lastChar != '/' ? 1 : 0));
        if (parentUrl.charAt(parentUrl.length() - 1) == '/') {
            return new SVNUrl(String.valueOf(parentUrl) + relativeFileName);
        }
        return new SVNUrl(String.valueOf(parentUrl) + "/" + relativeFileName);
    }
}

