/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.actions;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.epic.core.util.MarkerUtilities;
import org.epic.perleditor.actions.PerlEditorAction;
import org.epic.perleditor.editors.PerlEditor;

public abstract class PerlUserJobAction
extends PerlEditorAction {
    protected PerlUserJobAction(PerlEditor editor) {
        super(editor);
    }

    protected abstract Object[] doJob(IResource var1);

    protected abstract String getJobTitle(IResource var1);

    protected Map createMarkerAttributes(MarkerUtilities factory, Object violation) {
        return Collections.EMPTY_MAP;
    }

    @Override
    protected final void doRun() {
        final String marker = this.getMarker();
        final IResource resource = this.getResource();
        final MarkerUtilities factory = new MarkerUtilities(this.getLog(), this.getPluginId());
        Job job = new Job(this.getJobTitle(resource)){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                factory.deleteMarkers(resource, marker);
                Object[] violations = PerlUserJobAction.this.doJob(resource);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                int i = 0;
                while (i < violations.length) {
                    Map attributes = PerlUserJobAction.this.createMarkerAttributes(factory, violations[i]);
                    factory.createMarker(resource, marker, attributes);
                    ++i;
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    protected String getMarker() {
        return "";
    }
}

