/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.actions;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.epic.perleditor.actions.PerlEditorAction;
import org.epic.perleditor.editors.PerlEditor;
import org.epic.perleditor.editors.PerlEditorMessages;

public class ToggleCommentAction
extends PerlEditorAction {
    public ToggleCommentAction(PerlEditor editor) {
        super(editor);
    }

    @Override
    protected void doRun() {
        PerlEditor editor = this.getEditor();
        Point selRange = editor.getViewer().getSelectedRange();
        IDocument myDoc = editor.getViewer().getDocument();
        try {
            int line2 = 0;
            line2 = selRange.y > 0 ? myDoc.getLineOfOffset(selRange.x + selRange.y - 1) : myDoc.getLineOfOffset(selRange.x + selRange.y);
            boolean noCommentFound = true;
            int i = myDoc.getLineOfOffset(selRange.x);
            while (i <= line2 && noCommentFound) {
                if (myDoc.getChar(myDoc.getLineOffset(i)) != '#') {
                    noCommentFound = false;
                }
                ++i;
            }
            TextOperationAction action = noCommentFound ? new TextOperationAction(PerlEditorMessages.getResourceBundle(), "Uncomment.", (ITextEditor)editor, 12) : new TextOperationAction(PerlEditorMessages.getResourceBundle(), "Comment.", (ITextEditor)editor, 11);
            action.run();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String getPerlEditorActionId() {
        return "org.epic.perleditor.actions.ToggleCommentAction";
    }
}

