/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.eclipse;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import net.sf.colorer.ParserFactory;
import net.sf.colorer.eclipse.ColorerPlugin;
import net.sf.colorer.eclipse.EscapedWriter;
import net.sf.colorer.eclipse.Messages;
import net.sf.colorer.impl.ReaderLineSource;
import net.sf.colorer.swt.dialog.ActionListener;
import net.sf.colorer.swt.dialog.GeneratorDialog;
import net.sf.colorer.viewer.HTMLGenerator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class HTMLGeneratorAction
implements IObjectActionDelegate {
    IWorkbenchPart workbenchPart;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public void setActivePart(IAction action, IWorkbenchPart part) {
        this.workbenchPart = part;
    }

    public void selectionChanged(IAction arg0, ISelection arg1) {
    }

    public void run(IAction action) {
        ISelectionProvider selectionProvider = this.workbenchPart.getSite().getSelectionProvider();
        ISelection isel = selectionProvider.getSelection();
        if (!(isel instanceof StructuredSelection)) {
            return;
        }
        StructuredSelection selection = (StructuredSelection)selectionProvider.getSelection();
        GeneratorDialog gd = new GeneratorDialog();
        Vector fileList = new Vector();
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            IResource adapted = null;
            if (obj instanceof IAdaptable) {
                adapted = (IResource)((IAdaptable)obj).getAdapter(class$org$eclipse$core$resources$IResource == null ? HTMLGeneratorAction.class$("org.eclipse.core.resources.IResource") : class$org$eclipse$core$resources$IResource);
            }
            if (adapted == null) continue;
            this.addElement(adapted, fileList);
        }
        gd.setFileList(fileList);
        ParserFactory pf = ColorerPlugin.getDefaultPF();
        Vector<String> hrdSchemas = new Vector<String>();
        Enumeration hrds = pf.enumerateHRDInstances("rgb");
        while (hrds.hasMoreElements()) {
            String hrd_name = (String)hrds.nextElement();
            String hrd_descr = pf.getHRDescription("rgb", hrd_name);
            hrdSchemas.addElement(hrd_descr);
            hrdSchemas.addElement(hrd_name);
        }
        gd.setHRDSchema(hrdSchemas);
        IPreferenceStore ps = ColorerPlugin.getDefault().getPreferenceStore();
        gd.setPrefix(ps.getString("g.Prefix"));
        gd.setSuffix(ps.getString("g.Suffix"));
        gd.setHRDSchema(ps.getString("g.HRDSchema"));
        gd.setHtmlHeaderFooter(ps.getBoolean("g.HtmlHeaderFooter"));
        gd.setInfoHeader(ps.getBoolean("g.InfoHeader"));
        gd.setUseLineNumbers(ps.getBoolean("g.UseLineNumbers"));
        gd.setOutputEncoding(ps.getString("g.OutputEncoding"));
        gd.setTargetDirectory(ps.getString("g.TargetDirectory"));
        gd.setLinkSource(ps.getString("g.LinkSource"));
        gd.run(new Generator());
    }

    void addElement(IResource resource, Vector list) {
        if (resource instanceof IFile) {
            IFile iFile = (IFile)resource;
            String fileLocation = iFile.getLocation().toString();
            list.addElement(fileLocation);
        }
        if (resource instanceof IContainer) {
            IContainer folder = (IContainer)resource;
            try {
                IResource[] items = folder.members(false);
                for (int idx = 0; idx < items.length; ++idx) {
                    this.addElement(items[idx], list);
                }
            }
            catch (CoreException e) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Generator
    implements ActionListener {
        Generator() {
        }

        public void action(GeneratorDialog gd, int action) {
            switch (action) {
                case 1: {
                    IPreferenceStore ps = ColorerPlugin.getDefault().getPreferenceStore();
                    ps.setValue("g.Prefix", gd.getPrefix());
                    ps.setValue("g.Suffix", gd.getSuffix());
                    ps.setValue("g.HRDSchema", gd.getHRDSchema());
                    ps.setValue("g.HtmlHeaderFooter", gd.isHtmlHeaderFooter());
                    ps.setValue("g.InfoHeader", gd.isInfoHeader());
                    ps.setValue("g.UseLineNumbers", gd.isUseLineNumbers());
                    ps.setValue("g.OutputEncoding", gd.getOutputEncoding());
                    ps.setValue("g.TargetDirectory", gd.getTargetDirectory());
                    if (gd.getLinkSource() != null) {
                        ps.setValue("g.LinkSource", gd.getLinkSource());
                    }
                    gd.getShell().close();
                    break;
                }
                case 2: {
                    String[] fileList = gd.getFileList();
                    String lastFileName = null;
                    StringBuffer fileNames = new StringBuffer();
                    String filePath = gd.getTargetDirectory();
                    int num = 0;
                    try {
                        for (int i = 0; i < fileList.length; ++i) {
                            gd.setProgress((i + 1) * 100 / fileList.length);
                            String fileLocation = fileList[i];
                            File file = new File(fileLocation);
                            lastFileName = file.getName();
                            fileNames.append(lastFileName).append("\n");
                            ReaderLineSource rls = new ReaderLineSource(new FileReader(file));
                            String targetName = filePath + "/" + gd.getPrefix() + file.getName() + gd.getSuffix();
                            OutputStreamWriter commonWriter = null;
                            commonWriter = "default".equals(gd.getOutputEncoding()) ? new OutputStreamWriter(new FileOutputStream(targetName)) : new OutputStreamWriter((OutputStream)new FileOutputStream(targetName), gd.getOutputEncoding());
                            Writer escapedWriter = null;
                            escapedWriter = gd.isHtmlSubst() ? new EscapedWriter(commonWriter) : commonWriter;
                            ParserFactory pf = ColorerPlugin.getDefaultPF();
                            HTMLGenerator hg = new HTMLGenerator(pf, rls, gd.getHRDSchema());
                            hg.generate(commonWriter, escapedWriter, file.getName(), gd.isUseLineNumbers(), gd.isHtmlSubst(), gd.isInfoHeader(), gd.isHtmlHeaderFooter());
                            ++num;
                        }
                        MessageDialog.openInformation(null, (String)Messages.get("htmlgen.done"), (String)Messages.format("htmlgen.done.msg", new Object[]{String.valueOf(num), filePath, fileNames.toString()}));
                    }
                    catch (Exception e) {
                        MessageDialog.openError(null, (String)Messages.get("htmlgen.fault"), (String)Messages.format("htmlgen.fault.msg", new Object[]{String.valueOf(num), filePath, e, lastFileName}));
                    }
                    gd.setProgress(0);
                }
            }
        }
    }
}

